﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Reflection;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Diagnostics;
using System.Xml.Serialization;
using System.Xml;
using BMPSitingTool.Common;
namespace BMPSitingTool.Classes
{


    public class BMPCriteria
    {
        #region Variables        
        [XmlIgnore()]
        private string _applicationPath;

        private BMPobj dryPond;
        private BMPobj wetPond;
        private BMPobj infiltrationBasin;
        private BMPobj infiltrationTrench;
        private BMPobj bioretention;
        private BMPobj sandfilter_Surface;
        private BMPobj sandfilter_Nonsurface;
        private BMPobj constructedWetland;
        private BMPobj porousPavement;
        private BMPobj grassedSwales;
        private BMPobj vegetatedFilterstrip;
        private BMPobj rainBarrel;
        private BMPobj cistern;
        private BMPobj greenRoof;
        #endregion

        public BMPobj DryPond
        {
            get { return dryPond; }
            set { dryPond = value; }
        }
        public BMPobj WetPond
        {
            get { return wetPond; }
            set { wetPond = value; }
        }
        public BMPobj InfiltrationBasin
        {
            get { return infiltrationBasin; }
            set { infiltrationBasin = value; }
        }
        public BMPobj InfiltrationTrench
        {
            get { return infiltrationTrench; }
            set { infiltrationTrench = value; }
        }
        public BMPobj Bioretention
        {
            get { return bioretention; }
            set { bioretention = value; }
        }
        public BMPobj Sandfilter_Surface
        {
            get { return sandfilter_Surface; }
            set { sandfilter_Surface = value; }
        }
        public BMPobj Sandfilter_Nonsurface
        {
            get { return sandfilter_Nonsurface; }
            set { sandfilter_Nonsurface = value; }
        }
        public BMPobj ConstructedWetland
        {
            get { return constructedWetland; }
            set { constructedWetland = value; }
        }
        public BMPobj PorousPavement
        {
            get { return porousPavement; }
            set { porousPavement = value; }
        }
        public BMPobj GrassedSwales
        {
            get { return grassedSwales; }
            set { grassedSwales = value; }
        }
        public BMPobj VegetatedFilterstrip
        {
            get { return vegetatedFilterstrip; }
            set { vegetatedFilterstrip = value; }
        }
        public BMPobj RainBarrel
        {
            get { return rainBarrel; }
            set { rainBarrel = value; }
        }
        public BMPobj Cistern
        {
            get { return cistern; }
            set { cistern = value; }
        }
        public BMPobj GreenRoof
        {
            get { return greenRoof; }
            set { greenRoof = value; }
        }


        [XmlIgnore()]
        public string ApplicationPath
        {
            get { return _applicationPath; }
            set { _applicationPath = value; }
        }
        [XmlIgnore()]
        public string SitingToolCriteriaFile
        {
            get
            {
                string fn = null;

                fn = Path.GetDirectoryName(ApplicationPath) + "\\" + BMPSitingTool.Resource.SitingCriteria + Resource.XMLFileExt;
                return fn;
            }
            set
            {
                // not used. 
            }
        }
        public BMPCriteria()
        {

        }
        public BMPCriteria(string applicationPath)
        {
            _applicationPath = applicationPath;
        }



        public void DefaultBMPCriteria(string path)
        {
            Initialize_BMPs();
        }
        public void LoadBMPCriteria(string path)
        {
            try
            {

                if (File.Exists(path))
                {

                    System.IO.TextReader textreader = new System.IO.StreamReader(path);
                    System.Xml.Serialization.XmlSerializer serializer = new System.Xml.Serialization.XmlSerializer(typeof(BMPCriteria));
                    BMPCriteria bMPCriteria = (BMPCriteria)serializer.Deserialize(textreader);
                    dryPond = bMPCriteria.DryPond;
                    wetPond = bMPCriteria.WetPond;
                    infiltrationBasin = bMPCriteria.InfiltrationBasin;
                    infiltrationTrench = bMPCriteria.InfiltrationTrench;
                    bioretention = bMPCriteria.Bioretention;
                    sandfilter_Surface = bMPCriteria.Sandfilter_Surface;
                    sandfilter_Nonsurface = bMPCriteria.Sandfilter_Nonsurface;
                    constructedWetland = bMPCriteria.ConstructedWetland;
                    porousPavement = bMPCriteria.PorousPavement;
                    grassedSwales = bMPCriteria.GrassedSwales;
                    vegetatedFilterstrip = bMPCriteria.VegetatedFilterstrip;
                    rainBarrel = bMPCriteria.RainBarrel;
                    cistern = bMPCriteria.Cistern;
                    greenRoof = bMPCriteria.GreenRoof;
                    textreader.Close();
                }
                else
                {
                    Initialize_BMPs();
                }
            }
            catch (Exception e)
            {

                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "ERROR: " + e.Message + "\n" + e.StackTrace);
            }
        }

        public void SaveBMPCriteria(string path)
        {
            try
            {
                System.Xml.Serialization.XmlSerializer serializer = new System.Xml.Serialization.XmlSerializer(typeof(BMPCriteria));
                // serialize to XML
                using (System.IO.FileStream xmlStream = new System.IO.FileStream(path, System.IO.FileMode.Create, System.IO.FileAccess.ReadWrite))
                {
                    serializer.Serialize(xmlStream, this);
                    xmlStream.Close();
                }

            }
            catch (Exception e)
            {

                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "ERROR: " + e.Message + "\n" + e.StackTrace);
            }
        }
        
        private void Initialize_BMPs()
        {


            BMPobj oBMP = null;

            oBMP = new BMPobj();
            oBMP.BMPName = "Dry pond";
            oBMP.BMPType = "Point";
            oBMP.BMPId = 1;
 
            oBMP.DC_DA = ">10";
            oBMP.DC_DS = "<15";
            oBMP.DC_HG = "A-D";
            oBMP.DC_IMP = "<100";
            oBMP.DC_WT = ">4";
            oBMP.DC_RB = "NA";
            oBMP.DC_BB = "NA";
            oBMP.DC_SB = ">100";
            oBMP.DC_DA_State = "1";
            oBMP.DC_DS_State = "1";
            oBMP.DC_HG_State = "1";
            oBMP.DC_WT_State = "1";
            oBMP.DC_RB_State = "0";
            oBMP.DC_BB_State = "0";
            oBMP.DC_SB_State = "1";
            oBMP.DC_IMP_State = "1";
            oBMP.DC_DS_Weight = "<5:10;<10:7;<15:5;>=15:0";
            oBMP.DC_HG_Weight = "A:10;B:7;C:5;D:2";
            oBMP.DC_DS_Weight_State = "0";
            oBMP.DC_HG_Weight_State = "0";
            oBMP.DC_LO_State = "0";
            oBMP.DC_LO = "0";
            oBMP.DC_RLU_State = "1";
            dryPond = oBMP;

            oBMP = new BMPobj();
            oBMP.BMPName = "Wet pond";
            oBMP.BMPType = "Point";
            oBMP.BMPId = 2;
            // DC
            oBMP.DC_DA = ">25";
            oBMP.DC_DS = "<15";
            oBMP.DC_HG = "A-D";
            oBMP.DC_IMP = "<100";
            oBMP.DC_WT = ">4";
            oBMP.DC_RB = "NA";
            oBMP.DC_BB = "NA";
            oBMP.DC_SB = ">100";
            oBMP.DC_DA_State = "1";
            oBMP.DC_DS_State = "1";
            oBMP.DC_HG_State = "1";
            oBMP.DC_WT_State = "1";
            oBMP.DC_RB_State = "0";
            oBMP.DC_BB_State = "0";
            oBMP.DC_SB_State = "1";
            oBMP.DC_IMP_State = "1";
            oBMP.DC_DS_Weight = "<5:10;<10:7;<15:5;>=15:0";
            oBMP.DC_HG_Weight = "A:10;B:7;C:5;D:2";
            oBMP.DC_DS_Weight_State = "0";
            oBMP.DC_HG_Weight_State = "0";
            oBMP.DC_LO_State = "0";
            oBMP.DC_LO = "0";
            oBMP.DC_RLU_State = "1";
            WetPond = oBMP;

            oBMP = new BMPobj();
            oBMP.BMPName = "Infiltration basin";
            oBMP.BMPType = "Point";
            oBMP.BMPId = 3;
            // DC
            oBMP.DC_DA = "<10";
            oBMP.DC_DS = "<15";
            oBMP.DC_HG = "A-B";
            oBMP.DC_IMP = "<100";
            oBMP.DC_WT = ">4";
            oBMP.DC_RB = "NA";
            oBMP.DC_BB = "NA";
            oBMP.DC_SB = ">100";
            oBMP.DC_DA_State = "1";
            oBMP.DC_DS_State = "1";
            oBMP.DC_HG_State = "1";
            oBMP.DC_WT_State = "1";
            oBMP.DC_RB_State = "0";
            oBMP.DC_BB_State = "0";
            oBMP.DC_SB_State = "1";
            oBMP.DC_IMP_State = "1";
            oBMP.DC_DS_Weight = "<5:10;<10:7;<15:5;>=15:0";
            oBMP.DC_HG_Weight = "A:10;B:7;C:5;D:2";
            oBMP.DC_DS_Weight_State = "0";
            oBMP.DC_HG_Weight_State = "0";
            oBMP.DC_LO_State = "0";
            oBMP.DC_LO = "0";
            oBMP.DC_RLU_State = "1";
            InfiltrationBasin = oBMP;

            oBMP = new BMPobj();
            oBMP.BMPName = "Infiltration trench";
            oBMP.BMPType = "Point";
            oBMP.BMPId = 4;
            // DC
            oBMP.DC_DA = "<5";
            oBMP.DC_DS = "<15";
            oBMP.DC_HG = "A-B";
            oBMP.DC_IMP = "<100";
            oBMP.DC_WT = ">4";
            oBMP.DC_RB = "NA";
            oBMP.DC_BB = "NA";
            oBMP.DC_SB = ">100";
            oBMP.DC_DA_State = "1";
            oBMP.DC_DS_State = "1";
            oBMP.DC_HG_State = "1";
            oBMP.DC_WT_State = "1";
            oBMP.DC_RB_State = "0";
            oBMP.DC_BB_State = "0";
            oBMP.DC_SB_State = "1";
            oBMP.DC_IMP_State = "1";
            oBMP.DC_DS_Weight = "<5:10;<10:7;<15:5;>=15:0";
            oBMP.DC_HG_Weight = "A:10;B:7;C:5;D:2";
            oBMP.DC_DS_Weight_State = "0";
            oBMP.DC_HG_Weight_State = "0";
            oBMP.DC_LO_State = "0";
            oBMP.DC_LO = "0";
            oBMP.DC_RLU_State = "1";
            InfiltrationTrench = oBMP;

            oBMP = new BMPobj();
            oBMP.BMPName = "Bioretention";
            oBMP.BMPType = "Point";
            oBMP.BMPId = 5;
            // DC
            oBMP.DC_DA = "<2";
            oBMP.DC_DS = "<5";
            oBMP.DC_HG = "A-D";
            oBMP.DC_IMP = "<100";
            oBMP.DC_WT = ">2";
            oBMP.DC_RB = "<100";
            oBMP.DC_BB = "NA";
            oBMP.DC_SB = ">100";
            oBMP.DC_DA_State = "1";
            oBMP.DC_DS_State = "1";
            oBMP.DC_HG_State = "1";
            oBMP.DC_WT_State = "1";
            oBMP.DC_RB_State = "1";
            oBMP.DC_BB_State = "0";
            oBMP.DC_SB_State = "1";
            oBMP.DC_IMP_State = "1";
            oBMP.DC_DS_Weight = "<5:10;<10:7;<15:5;>=15:0";
            oBMP.DC_HG_Weight = "A:10;B:7;C:5;D:2";
            oBMP.DC_DS_Weight_State = "0";
            oBMP.DC_HG_Weight_State = "0";
            oBMP.DC_LO_State = "0";
            oBMP.DC_LO = "0";
            oBMP.DC_RLU_State = "1";
            Bioretention = oBMP;

            oBMP = new BMPobj();
            oBMP.BMPName = "Sand filter (surface)";
            oBMP.BMPType = "Point";
            oBMP.BMPId = 6;
            // DC
            oBMP.DC_DA = "<10";
            oBMP.DC_DS = "<10";
            oBMP.DC_HG = "A-D";
            oBMP.DC_IMP = "<100";
            oBMP.DC_WT = ">2";
            oBMP.DC_RB = "NA";
            oBMP.DC_BB = "NA";
            oBMP.DC_SB = ">100";
            oBMP.DC_DA_State = "1";
            oBMP.DC_DS_State = "1";
            oBMP.DC_HG_State = "1";
            oBMP.DC_WT_State = "1";
            oBMP.DC_RB_State = "0";
            oBMP.DC_BB_State = "0";
            oBMP.DC_SB_State = "1";
            oBMP.DC_IMP_State = "1";
            oBMP.DC_DS_Weight = "<5:10;<10:7;<15:5;>=15:0";
            oBMP.DC_HG_Weight = "A:10;B:7;C:5;D:2";
            oBMP.DC_DS_Weight_State = "0";
            oBMP.DC_HG_Weight_State = "0";
            oBMP.DC_LO_State = "0";
            oBMP.DC_LO = "0";
            oBMP.DC_RLU_State = "1";
            Sandfilter_Surface = oBMP;

            oBMP = new BMPobj();
            oBMP.BMPName = "Sand filter (non-surface)";
            oBMP.BMPType = "Point";
            oBMP.BMPId = 7;
            // DC
            oBMP.DC_DA = "<2";
            oBMP.DC_DS = "<10";
            oBMP.DC_HG = "A-D";
            oBMP.DC_IMP = "<100";
            oBMP.DC_WT = ">2";
            oBMP.DC_RB = "NA";
            oBMP.DC_BB = "NA";
            oBMP.DC_SB = ">100";
            oBMP.DC_DA_State = "1";
            oBMP.DC_DS_State = "1";
            oBMP.DC_HG_State = "1";
            oBMP.DC_WT_State = "1";
            oBMP.DC_RB_State = "0";
            oBMP.DC_BB_State = "0";
            oBMP.DC_SB_State = "1";
            oBMP.DC_IMP_State = "1";
            oBMP.DC_DS_Weight = "<5:10;<10:7;<15:5;>=15:0";
            oBMP.DC_HG_Weight = "A:10;B:7;C:5;D:2";
            oBMP.DC_DS_Weight_State = "0";
            oBMP.DC_HG_Weight_State = "0";
            oBMP.DC_LO_State = "0";
            oBMP.DC_LO = "0";
            oBMP.DC_RLU_State = "1";
            Sandfilter_Nonsurface = oBMP;

            oBMP = new BMPobj();
            oBMP.BMPName = "Constructed wetland";
            oBMP.BMPType = "Point";
            oBMP.BMPId = 8;
            // DC
            oBMP.DC_DA = ">25";
            oBMP.DC_DS = "<15";
            oBMP.DC_HG = "A-D";
            oBMP.DC_IMP = "<100";
            oBMP.DC_WT = ">4";
            oBMP.DC_RB = "NA";
            oBMP.DC_BB = "NA";
            oBMP.DC_SB = ">100";
            oBMP.DC_DA_State = "1";
            oBMP.DC_DS_State = "1";
            oBMP.DC_HG_State = "1";
            oBMP.DC_WT_State = "1";
            oBMP.DC_RB_State = "0";
            oBMP.DC_BB_State = "0";
            oBMP.DC_SB_State = "1";
            oBMP.DC_IMP_State = "1";
            oBMP.DC_DS_Weight = "<5:10;<10:7;<15:5;>=15:0";
            oBMP.DC_HG_Weight = "A:10;B:7;C:5;D:2";
            oBMP.DC_DS_Weight_State = "0";
            oBMP.DC_HG_Weight_State = "0";
            oBMP.DC_LO_State = "0";
            oBMP.DC_LO = "0";
            oBMP.DC_RLU_State = "1";
            ConstructedWetland = oBMP;

            oBMP = new BMPobj();
            oBMP.BMPName = "Porous Pavement";
            oBMP.BMPType = "Area";
            oBMP.BMPId = 9;
            // DC
            oBMP.DC_DA = "<3";
            oBMP.DC_DS = "<1";
            oBMP.DC_HG = "A-B";
            oBMP.DC_IMP = ">0";
            oBMP.DC_WT = ">2";
            oBMP.DC_RB = "NA";
            oBMP.DC_BB = "0";
            oBMP.DC_SB = "NA";
            oBMP.DC_DA_State = "1";
            oBMP.DC_DS_State = "1";
            oBMP.DC_HG_State = "1";
            oBMP.DC_WT_State = "1";
            oBMP.DC_RB_State = "0";
            oBMP.DC_BB_State = "1";
            oBMP.DC_SB_State = "0";
            oBMP.DC_IMP_State = "1";
            oBMP.DC_DS_Weight = "<5:10;<10:7;<15:5;>=15:0";
            oBMP.DC_HG_Weight = "A:10;B:7;C:5;D:2";
            oBMP.DC_DS_Weight_State = "0";
            oBMP.DC_HG_Weight_State = "0";
            oBMP.DC_LO_State = "0";
            oBMP.DC_LO = "0";
            oBMP.DC_RLU_State = "1";
            PorousPavement = oBMP;

            oBMP = new BMPobj();
            oBMP.BMPName = "Grassed swales";
            oBMP.BMPType = "Line";
            oBMP.BMPId = 10;
            // DC
            oBMP.DC_DA = "<5";
            oBMP.DC_DS = "<4";
            oBMP.DC_HG = "A-D";
            oBMP.DC_IMP = "<100";
            oBMP.DC_WT = ">2";
            oBMP.DC_RB = "<100";
            oBMP.DC_BB = "NA";
            oBMP.DC_SB = "NA";
            oBMP.DC_DA_State = "1";
            oBMP.DC_DS_State = "1";
            oBMP.DC_HG_State = "1";
            oBMP.DC_WT_State = "1";
            oBMP.DC_RB_State = "1";
            oBMP.DC_BB_State = "0";
            oBMP.DC_SB_State = "0";
            oBMP.DC_IMP_State = "1";
            oBMP.DC_DS_Weight = "<4:10;<10:2;<15:1;>=15:3";
            oBMP.DC_HG_Weight = "A:5;B:3;C:1;D:2";
            oBMP.DC_DS_Weight_State = "0";
            oBMP.DC_HG_Weight_State = "0";
            oBMP.DC_LO_State = "0";
            oBMP.DC_LO = "0";
            oBMP.DC_RLU_State = "1";
            GrassedSwales = oBMP;

            oBMP = new BMPobj();
            oBMP.BMPName = "Vegetated filterstrip";
            oBMP.BMPType = "Line";
            oBMP.BMPId = 11;
            // DC
            oBMP.DC_DA = "NA";
            oBMP.DC_DS = "<10";
            oBMP.DC_HG = "A-D";
            oBMP.DC_IMP = "<100";
            oBMP.DC_WT = ">2";
            oBMP.DC_RB = "<100";
            oBMP.DC_BB = "NA";
            oBMP.DC_SB = "NA";
            oBMP.DC_DA_State = "0";
            oBMP.DC_DS_State = "1";
            oBMP.DC_HG_State = "1";
            oBMP.DC_WT_State = "1";
            oBMP.DC_RB_State = "1";
            oBMP.DC_BB_State = "0";
            oBMP.DC_SB_State = "0";
            oBMP.DC_IMP_State = "1";
            oBMP.DC_DS_Weight = "<4:5;<10:3;<15:2;>=15:1";
            oBMP.DC_HG_Weight = "A:4;B:3;C:2;D:1";
            oBMP.DC_DS_Weight_State = "0";
            oBMP.DC_HG_Weight_State = "0";
            oBMP.DC_LO_State = "0";
            oBMP.DC_LO = "0";
            oBMP.DC_RLU_State = "1";
            VegetatedFilterstrip = oBMP;

            oBMP = new BMPobj();
            oBMP.BMPName = "Rain barrel";
            oBMP.BMPType = "Point";
            oBMP.BMPId = 12;
            // DC
            oBMP.DC_DA = "NA";
            oBMP.DC_DS = "NA";
            oBMP.DC_HG = "NA";
            oBMP.DC_IMP = "NA";
            oBMP.DC_WT = "NA";
            oBMP.DC_RB = "NA";
            oBMP.DC_BB = "<30";
            oBMP.DC_SB = "NA";
            oBMP.DC_DA_State = "0";
            oBMP.DC_DS_State = "0";
            oBMP.DC_HG_State = "0";
            oBMP.DC_WT_State = "0";
            oBMP.DC_RB_State = "0";
            oBMP.DC_BB_State = "1";
            oBMP.DC_SB_State = "0";
            oBMP.DC_IMP_State = "0";
            oBMP.DC_DS_Weight = "<4:10;<10:2;<15:1;>=15:3";
            oBMP.DC_HG_Weight = "A:5;B:3;C:1;D:2";
            oBMP.DC_DS_Weight_State = "0";
            oBMP.DC_HG_Weight_State = "0";
            oBMP.DC_LO_State = "0";
            oBMP.DC_LO = "0";
            oBMP.DC_RLU_State = "1";
            RainBarrel = oBMP;

            oBMP = new BMPobj();
            oBMP.BMPName = "Cistern";
            oBMP.BMPType = "Point";
            oBMP.BMPId = 13;
            // DC
            oBMP.DC_DA = "NA";
            oBMP.DC_DS = "NA";
            oBMP.DC_HG = "NA";
            oBMP.DC_IMP = "NA";
            oBMP.DC_WT = "NA";
            oBMP.DC_RB = "NA";
            oBMP.DC_BB = "<30";
            oBMP.DC_SB = "NA";
            oBMP.DC_DA_State = "0";
            oBMP.DC_DS_State = "0";
            oBMP.DC_HG_State = "0";
            oBMP.DC_WT_State = "0";
            oBMP.DC_RB_State = "0";
            oBMP.DC_BB_State = "1";
            oBMP.DC_SB_State = "0";
            oBMP.DC_IMP_State = "0";
            oBMP.DC_DS_Weight = "<4:10;<10:2;<15:1;>=15:3";
            oBMP.DC_HG_Weight = "A:5;B:3;C:1;D:2";
            oBMP.DC_DS_Weight_State = "0";
            oBMP.DC_HG_Weight_State = "0";
            oBMP.DC_LO_State = "0";
            oBMP.DC_LO = "0";
            oBMP.DC_RLU_State = "1";
            Cistern = oBMP;

            oBMP = new BMPobj();
            oBMP.BMPName = "Green roof";
            oBMP.BMPType = "Area";
            oBMP.BMPId = 14;
            // DC
            oBMP.DC_DA = "NA";
            oBMP.DC_DS = "NA";
            oBMP.DC_HG = "NA";
            oBMP.DC_IMP = "NA";
            oBMP.DC_WT = "NA";
            oBMP.DC_RB = "NA";
            oBMP.DC_BB = "0";
            oBMP.DC_SB = "NA";
            oBMP.DC_DA_State = "0";
            oBMP.DC_DS_State = "0";
            oBMP.DC_HG_State = "0";
            oBMP.DC_WT_State = "0";
            oBMP.DC_RB_State = "0";
            oBMP.DC_BB_State = "1";
            oBMP.DC_SB_State = "0";
            oBMP.DC_IMP_State = "0";
            oBMP.DC_DS_Weight = "<5:10;<10:7;<15:5;>=15:0";
            oBMP.DC_HG_Weight = "A:10;B:7;C:5;D:2";
            oBMP.DC_DS_Weight_State = "0";
            oBMP.DC_HG_Weight_State = "0";
            oBMP.DC_LO_State = "1";
            oBMP.DC_LO = "0";
            oBMP.DC_RLU_State = "1";
            GreenRoof = oBMP;

            return;


        }

        public BMPobj GetOneBMP(string bMPType)
        {

            if (bMPType == dryPond.BMPName)
            {
                return dryPond;
            }
            if (bMPType == wetPond.BMPName)
            {
                return wetPond;
            }
            if (bMPType == infiltrationBasin.BMPName)
            {
                return infiltrationBasin;
            }
            if (bMPType == infiltrationTrench.BMPName)
            {
                return infiltrationTrench;
            }
            if (bMPType == bioretention.BMPName)
            {
                return bioretention;
            }
            if (bMPType == sandfilter_Surface.BMPName)
            {
                return sandfilter_Surface;
            }
            if (bMPType == sandfilter_Nonsurface.BMPName)
            {
                return sandfilter_Nonsurface;
            }
            if (bMPType == constructedWetland.BMPName)
            {
                return constructedWetland;
            }
            if (bMPType == porousPavement.BMPName)
            {
                return porousPavement;
            }
            if (bMPType == grassedSwales.BMPName)
            {
                return grassedSwales;
            }
            if (bMPType == vegetatedFilterstrip.BMPName)
            {
                return vegetatedFilterstrip;
            }
            if (bMPType == rainBarrel.BMPName)
            {
                return rainBarrel;
            }
            if (bMPType == cistern.BMPName)
            {
                return cistern;
            }
            if (bMPType == greenRoof.BMPName)
            {
                return greenRoof;
            }
            return null;
        }

        public void SetOneBMP(string bMPType, BMPobj bMPtobeSaved)
        {

            if (bMPType == dryPond.BMPName)
            {
                dryPond = bMPtobeSaved;
            }
            if (bMPType == wetPond.BMPName)
            {
                wetPond = bMPtobeSaved; 
            }
            if (bMPType == infiltrationBasin.BMPName)
            {
                infiltrationBasin = bMPtobeSaved;
            }
            if (bMPType == infiltrationTrench.BMPName)
            {
                infiltrationTrench = bMPtobeSaved;
            }
            if (bMPType == bioretention.BMPName)
            {
                bioretention = bMPtobeSaved;
            }
            if (bMPType == sandfilter_Surface.BMPName)
            {
                sandfilter_Surface = bMPtobeSaved;
            }
            if (bMPType == sandfilter_Nonsurface.BMPName)
            {
                sandfilter_Nonsurface = bMPtobeSaved;
            }
            if (bMPType == constructedWetland.BMPName)
            {
                constructedWetland = bMPtobeSaved;
            }
            if (bMPType == porousPavement.BMPName)
            {
                porousPavement = bMPtobeSaved;
            }
            if (bMPType == grassedSwales.BMPName)
            {
                grassedSwales = bMPtobeSaved;
            }
            if (bMPType == vegetatedFilterstrip.BMPName)
            {
                vegetatedFilterstrip = bMPtobeSaved;
            }
            if (bMPType == rainBarrel.BMPName)
            {
                rainBarrel = bMPtobeSaved;
            }
            if (bMPType == cistern.BMPName)
            {
                cistern = bMPtobeSaved;
            }
            if (bMPType == greenRoof.BMPName)
            {
                greenRoof = bMPtobeSaved;
            }
            
        }
        public ArrayList GetBMPTypeList()
        {

            ArrayList bMPTypeList = new ArrayList();
            bMPTypeList.Add(dryPond.BMPName);
            bMPTypeList.Add(wetPond.BMPName);
            bMPTypeList.Add(infiltrationBasin.BMPName);
            bMPTypeList.Add(infiltrationTrench.BMPName);
            bMPTypeList.Add(bioretention.BMPName);
            bMPTypeList.Add(sandfilter_Surface.BMPName);
            bMPTypeList.Add(sandfilter_Nonsurface.BMPName);
            bMPTypeList.Add(constructedWetland.BMPName);
            bMPTypeList.Add(porousPavement.BMPName);
            bMPTypeList.Add(grassedSwales.BMPName);
            bMPTypeList.Add(vegetatedFilterstrip.BMPName);
            bMPTypeList.Add(rainBarrel.BMPName);
            bMPTypeList.Add(cistern.BMPName);
            bMPTypeList.Add(greenRoof.BMPName);
            return bMPTypeList;
        }
    }
}
