﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using ESRI.ArcGIS.SpatialAnalyst;
using ESRI.ArcGIS.Carto;
using ESRI.ArcGIS.Geodatabase;
using ESRI.ArcGIS.DataSourcesRaster;
using ESRI.ArcGIS.GeoAnalyst;
using ESRI.ArcGIS.esriSystem;
using BMPSitingTool.Utilities;
using BMPSitingTool.Common;

namespace BMPSitingTool.Classes
{
    class RasterOperators
    {
        private IHydrologyOp hydrologyOp;
        private IMapAlgebraOp mapAlgebraOp;
        private double cellSize;// will be used only when DEM is available

        public IHydrologyOp HydrologyOp
        {
            get { return hydrologyOp; }
            set { hydrologyOp = value; }
        }

        public IMapAlgebraOp MapAlgebraOp
        {
            get { return mapAlgebraOp; }
            set { mapAlgebraOp = value; }
        }

        public double CellSize
        {
            get { return cellSize; }
            set { cellSize = value; }
        }

        public RasterOperators()
        {

        }

        public RasterOperators(SitingToolSettings settings, IMap pMap)
        {
            IRasterAnalysisEnvironment pRAEnvMapAlgebra = null;
            IRasterAnalysisEnvironment pRAEnvHydrology = null;
            IRasterLayer pDEMRasterLayer = null;

            IWorkspaceFactory pWSF = new RasterWorkspaceFactory();
            IRasterWorkspace2 pRWS = (IRasterWorkspace2)pWSF.OpenFromFile(settings.Rasterfolder, 0);

            try
            {
                // Create the global gAlgebraOp object
                mapAlgebraOp = (IMapAlgebraOp)new RasterMapAlgebraOp();
                pRAEnvMapAlgebra = (IRasterAnalysisEnvironment)mapAlgebraOp;
                pRAEnvMapAlgebra.OutWorkspace = (IWorkspace)pRWS;

                // Create the global gHydrologyOp object
                hydrologyOp = (IHydrologyOp)new RasterHydrologyOp();
                pRAEnvHydrology = (IRasterAnalysisEnvironment)hydrologyOp;
                pRAEnvHydrology.OutWorkspace = (IWorkspace)pRWS;



                pDEMRasterLayer = (IRasterLayer)SitingToolUtilities.GetInputFeatureLayer(settings.DEMdata, pMap);
                if (pDEMRasterLayer != null)
                {
                    IRaster pDEMRaster = pDEMRasterLayer.Raster;
                    //Get the raster props
                    IRasterProps pDEMRasterProps = (IRasterProps)pDEMRaster;
                    //Get the raster cell size
                    cellSize = (pDEMRasterProps.MeanCellSize().X + pDEMRasterProps.MeanCellSize().Y) / 2;

                    pRAEnvMapAlgebra.SetExtent(ESRI.ArcGIS.GeoAnalyst.esriRasterEnvSettingEnum.esriRasterEnvValue, pDEMRasterProps.Extent);
                    pRAEnvMapAlgebra.SetCellSize(esriRasterEnvSettingEnum.esriRasterEnvValue, pDEMRasterProps.MeanCellSize().X);
                    pRAEnvMapAlgebra.OutSpatialReference = pDEMRasterProps.SpatialReference;
                    pRAEnvMapAlgebra.Mask = (IGeoDataset)pDEMRaster;

                    pRAEnvHydrology.SetExtent(esriRasterEnvSettingEnum.esriRasterEnvValue, pDEMRasterProps.Extent);
                    pRAEnvHydrology.SetCellSize(esriRasterEnvSettingEnum.esriRasterEnvValue, pDEMRasterProps.MeanCellSize().X);
                    pRAEnvHydrology.OutSpatialReference = pDEMRasterProps.SpatialReference;
                    pRAEnvHydrology.Mask = (IGeoDataset)pDEMRaster;
                }
                else
                {
                    cellSize = 1;//will not be used
                }
            }
            catch (Exception e)
            {
                MessageBox.Show("Error at RasterOperators: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at RasterOperators: " + e.Message);
            }
            //if (pDEMRasterLayer != null)
            //    Marshal.FinalReleaseComObject(pDEMRasterLayer);
            //if (pDEMRasterProps != null)
            //    Marshal.FinalReleaseComObject(pDEMRasterProps);
            //if (pRWS != null)
            //    Marshal.FinalReleaseComObject(pRWS);
            if (pWSF != null)
                Marshal.FinalReleaseComObject(pWSF);
            return;
        }
    }
}
