﻿using System;
using System.Collections.Generic;
using System.Collections;
using System.Linq;
using System.Text;
using System.IO;
using System.Reflection;
using System.ComponentModel;
using System.Windows.Forms;
using System.Xml;
using System.Xml.Serialization;
using BMPSitingTool.Common;
namespace BMPSitingTool.Classes
{
    public class SelectedBMPType
    {
        #region Variables
        [XmlIgnore()]
        private string _applicationPath;

        private List<string> _selectedBMP;
        public List<string> SelectedBMP
        {
            get { return _selectedBMP; }
            set { _selectedBMP = value; }
        }


        [XmlIgnore()]
        public string ApplicationPath
        {
            get { return _applicationPath; }
            set { _applicationPath = value; }
        }
        [XmlIgnore()]
        public string SelectBMPTypeFile
        {
            get
            {
                string fn = null;

                fn = Path.GetDirectoryName(ApplicationPath) + "\\" + BMPSitingTool.Resource.SelectedBMP + Resource.XMLFileExt;
                return fn;
            }
            set
            {
                // not used. 
            }
        }
        public SelectedBMPType()
        {

        }
        public SelectedBMPType(string applicationPath)
        {
            _applicationPath = applicationPath;

            _selectedBMP = new List<string>();
        }
        #endregion
        public void LoadSelectedBMPList(string path)
        {
            try
            {
                if (File.Exists(path))
                {

                    TextReader textreader = new StreamReader(path);
                    XmlSerializer serializer = new XmlSerializer(typeof(SelectedBMPType));
                    SelectedBMPType selectedBMPType = (SelectedBMPType)serializer.Deserialize(textreader);
                    _selectedBMP = selectedBMPType.SelectedBMP;
                    textreader.Close();
                }
                else
                {

                    _selectedBMP = new List<string>();

                }
            }
            catch (Exception e)
            {

                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "ERROR: " + e.Message + "\n" + e.StackTrace);
            }
        }
        public void SaveSelectedBMPList(string path)
        {
            try
            {

                XmlSerializer serializer = new XmlSerializer(typeof(SelectedBMPType));
                // serialize to XML
                using (FileStream xmlStream = new FileStream(path, FileMode.Create, FileAccess.ReadWrite))
                {
                    serializer.Serialize(xmlStream, this);
                    
                    xmlStream.Close();
                }

            }
            catch (Exception e)
            {

                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "ERROR: " + e.Message + "\n" + e.StackTrace);
            }
        }


    }
}
