using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Xml;
using System.Xml.Serialization;
using System.IO;
using System.Reflection;
using System.ComponentModel;
using System.Windows.Forms;
using BMPSitingTool.Common;

namespace BMPSitingTool.Classes
{



	#region  XmlSettingsSerializable
 
	public abstract class XmlSettingsSerializable
	{

		public virtual void SaveSettings(string path)
		{
			try
			{
				StreamWriter w = new StreamWriter(path);
				XmlSerializer s = new XmlSerializer(this.GetType());
                
				s.Serialize(w, this);
				w.Close();
                
			}
			catch (Exception e)
			{

                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "ERROR: " + e.Message + "\n" + e.StackTrace);
			}
		}

		public virtual void LoadSettings(string path)
		{
			try
			{
				if (File.Exists(path))
				{
					StreamReader sr = new StreamReader(path);
					XmlTextReader xr = new XmlTextReader(sr);
					XmlSerializer xs = new XmlSerializer(this.GetType());
					object c;
					if (xs.CanDeserialize(xr))
					{
						c = xs.Deserialize(xr);
						Type t = this.GetType();
						PropertyInfo[] properties = t.GetProperties();
						foreach (PropertyInfo p in properties)
						{
							p.SetValue(this, p.GetValue(c, null), null);
						}
					}
					xr.Close();
					sr.Close();
				}
				else
				{
                    Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "LoadSetting: file " + path + " does not exist");
				}
			}
			catch (Exception e)
			{

                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "ERROR: " + e.Message + "\n" + e.StackTrace);
			}
		}



	}

	#endregion
	/// <summary>
	/// User settings for inserting and visualizing Siting tool model results. 
	/// </summary>
	public class SitingToolSettings : XmlSettingsSerializable
	{

		#region Variables
        private bool _dataValid;
        private string _applicationPath;
        private string _workingfolder;
        private string _workingfolderParent;
        private string _rasterfolder;
        private double _cellSize;

        private string _dEMdata;
        private string _soildata;
        private string _imperviousdata;
        private string _landusedata;
        private string _streamdata;
        private string _roaddata;
        private string _mRLCdata;
        private string _wTdata;
        private string _soilTable;
        private string _mrlcTable;
        private string _landownerdata;
        private string _zUnit;



        public SitingToolSettings(string applicationPath)
		{
            _applicationPath = applicationPath;
            _zUnit = "Meter";
			_dataValid = false;
            _cellSize = 0;

            _workingfolder = "";
            _workingfolderParent = "";
            _rasterfolder = "";
            

            _dEMdata = "";
            _soildata = "";
            _imperviousdata = "";
            _landusedata = "";
            _streamdata = "";
            _roaddata = "";
            _mRLCdata = "";
            _wTdata = "";
            _soilTable = "";
            _mrlcTable = "";
            _landownerdata = "";

        }
        public SitingToolSettings()
        {
           
        }
		[XmlIgnore()]
		public string SitingToolSettingsFile
		{
			get
			{
				string fn = null;

                fn = Path.GetDirectoryName(ApplicationPath) + "\\" +  BMPSitingTool.Resource.SitingToolConfig + Resource.XMLFileExt;
				return fn;
			}
			set
			{
				// not used. 
			}
		}

        public string ApplicationPath
        {
            get { return _applicationPath; }
            set { _applicationPath = value; }
        }


        public bool DataValid
        {
            get { return _dataValid; }
            set { _dataValid = value; }
        }

        public string Workingfolder
        {
            get { return _workingfolder; }
            set { _workingfolder = value; }
        }


        public string WorkingfolderParent
        {
            get { return _workingfolderParent; }
            set { _workingfolderParent = value; }
        }

        public string Rasterfolder
        {
            get { return _rasterfolder; }
            set { _rasterfolder = value; }
        }



        public double CellSize
        {
            get { return _cellSize; }
            set { _cellSize = value; }
        }


        public string DEMdata
        {
            get { return _dEMdata; }
            set { _dEMdata = value; }
        }


        public string Soildata
        {
            get { return _soildata; }
            set { _soildata = value; }
        }


        public string Imperviousdata
        {
            get { return _imperviousdata; }
            set { _imperviousdata = value; }
        }


        public string Landusedata
        {
            get { return _landusedata; }
            set { _landusedata = value; }
        }


        public string Streamdata
        {
            get { return _streamdata; }
            set { _streamdata = value; }
        }


        public string Roaddata
        {
            get { return _roaddata; }
            set { _roaddata = value; }
        }


        public string RasterLanduseData
        {
            get { return _mRLCdata; }
            set { _mRLCdata = value; }
        }


        public string WTdata
        {
            get { return _wTdata; }
            set { _wTdata = value; }
        }


        public string SoilTable
        {
            get { return _soilTable; }
            set { _soilTable = value; }
        }


        public string RasterLanduseTable
        {
            get { return _mrlcTable; }
            set { _mrlcTable = value; }
        }


        public string Landownerdata
        {
            get { return _landownerdata; }
            set { _landownerdata = value; }
        }


        public string ZUnit
        {
            get { return _zUnit; }
            set { _zUnit = value; }
        }

		




		#endregion

		public void LogSettings()
		{


            Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "***********************************************************************");
		}


	}
}
