using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Diagnostics;
using System.Reflection;
using BMPSitingTool.Classes;

namespace BMPSitingTool.Common
{
	public class Logger
	{

		public static string GenerateProjectLogFileName(string projectFileName)
		{
			string fn = null;
			if (projectFileName == null)
			{
				fn = GenerateDefaultLogFileName("sitingtool");
			}
			else {
				fn = Path.GetDirectoryName(projectFileName) + "\\" + Path.GetFileNameWithoutExtension(projectFileName) + "_" + DateTime.Now.Month + "_" + DateTime.Now.Day + "_" + DateTime.Now.Year + ".log";
			}
			return fn;  
		}

		public static string GenerateDefaultLogFileName(string BaseFileName)
		{
			return   Path.GetDirectoryName(Assembly.GetAssembly(typeof(BMPSitingTool.Classes.BMPobj)).Location)  + "\\" + BaseFileName + "_" + DateTime.Now.Month + "_" + DateTime.Now.Day + "_" + DateTime.Now.Year + ".log";
		}

 

		/// <summary>

		/// Pass in the fully qualified name of the log file you want to write to

		/// and the message to write

		/// </summary>

		/// <param name="LogPath"></param>

		/// <param name="Message"></param>

		public static void WriteToLog(string LogPath, string Message)
		{
			try
			{
				using (StreamWriter s = File.AppendText(LogPath))
				{
					s.WriteLine(DateTime.Now + "\t" + Message);
				}
			}
			catch (Exception ex)
			{
				System.Diagnostics.Debug.WriteLine(ex.Message);
			}
		}





		/// <summary>

		/// Writes a message to the application event log

		/// /// </summary>

		/// <param name="Source">Source is the source of the message ususally you will want this to be the application name</param>

		/// <param name="Message">message to be written</param>

		/// <param name="EntryType">the entry type to use to categorize the message like for exmaple error or information</param>

		public static void WriteToEventLog(string Source, string Message, System.Diagnostics.EventLogEntryType EntryType)
		{
			try
			{

				if (!EventLog.SourceExists(Source))
				{
					EventLog.CreateEventSource(Source, "Application");
				}
				EventLog.WriteEntry(Source, Message, EntryType);
			}
			catch (Exception ex)
			{
				System.Diagnostics.Debug.WriteLine(ex.Message);
			}
		}
	}
}
