﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Collections;
using System.Runtime.InteropServices;
using BMPSitingTool.Utilities;
using BMPSitingTool.Common;
using BMPSitingTool.Classes;

using ESRI.ArcGIS.Framework;
using ESRI.ArcGIS.ADF.BaseClasses;
using ESRI.ArcGIS.ADF.CATIDs;
using ESRI.ArcGIS.ArcMapUI;
using ESRI.ArcGIS.SpatialAnalyst;
using ESRI.ArcGIS.Carto;
using ESRI.ArcGIS.CatalogUI;
using ESRI.ArcGIS.Catalog;
using ESRI.ArcGIS.ArcMap;
using ESRI.ArcGIS.Geodatabase;
using ESRI.ArcGIS.Display;
using ESRI.ArcGIS.Geometry;
using ESRI.ArcGIS.esriSystem;
using ESRI.ArcGIS.GeoDatabaseUI;
using ESRI.ArcGIS.Geoprocessor;
using ESRI.ArcGIS.Geoprocessing;
using ESRI.ArcGIS.DataManagementTools;
using ESRI.ArcGIS.AnalysisTools;

namespace BMPSitingTool.Forms
{
    public partial class FrmBMPSitingCriteria : Form
    {
        private FrmWeightCriteria m_frmWeightCriteria;
        private SitingToolSettings _settings;
        private BMPCriteria _bMPCriteria;
        private SelectedBMPType _selectedBMPType;
        private IApplication m_application;


        private string m_Prev_BMP;
        public string m_BMPType;
        private Dictionary<string, int> numProgressEachBMP;
        
        private string strResult;

        internal SelectedBMPType SelectedBMPType
        {
            get { return _selectedBMPType; }
            set { _selectedBMPType = value; }
        }


        internal BMPCriteria BMPCriteria
        {
            get { return _bMPCriteria; }
            set { _bMPCriteria = value; }
        }

        private List<string> selectedBMPTypeList;
        public Boolean OpenCriteriaWeight_DS_Visible
        {
            get { return this.BOpenCriteriaWeight_DS.Visible; }
            set { this.BOpenCriteriaWeight_DS.Visible = value; }
        }
        public Boolean OpenCriteriaWeight_HG_Visible
        {
            get { return this.BOpenCriteriaWeight_HG.Visible; }
            set { this.BOpenCriteriaWeight_HG.Visible = value; }
        }

        public Boolean CriteriaStored_DS_Visible
        {
            get { return this.BCriteriaStored_DS.Visible; }
            set { this.BCriteriaStored_DS.Visible = value; }
        }
        public Boolean CriteriaStored_HG_Visible
        {
            get { return this.BCriteriaStored_HG.Visible; }
            set { this.BCriteriaStored_HG.Visible = value; }
        }
        public IApplication ArcGISApplication
        {
            set
            {
                m_application = value;
            }
        }
        public SitingToolSettings Settings
        {
            get { return _settings; }
            set { _settings = value; }
        }
        public FrmBMPSitingCriteria()
        {
            InitializeComponent();
        }

        private void panel2_Paint(object sender, PaintEventArgs e)
        {

        }

        private void splitContainer1_Panel1_Paint(object sender, PaintEventArgs e)
        {

        }
        private void Initialize_Controls()
        {

            lblDC_BB.Text = "";
            lblDC_DA.Text = "";
            lblDC_DS.Text = "";
            lblDC_IMP.Text = "";
            lblDC_HG.Text = "";
            lblDC_RB.Text = "";
            lblDC_SB.Text = "";
            lblDC_WT.Text = "";

            cmbDC_LO.SelectedIndex = -1;

            chkBB.CheckState = CheckState.Checked;
            chkDA.CheckState = CheckState.Checked;
            chkDS.CheckState = CheckState.Checked;
            chkIMP.CheckState = CheckState.Checked;
            chkHG.CheckState = CheckState.Checked;
            chkRB.CheckState = CheckState.Checked;
            chkSB.CheckState = CheckState.Checked;
            chkWT.CheckState = CheckState.Checked;
            chkLO.CheckState = CheckState.Unchecked;
            chkRLU.CheckState = CheckState.Checked;

            chkBB.Enabled = false;
            chkDA.Enabled = false;
            chkDS.Enabled = false;
            chkIMP.Enabled = false;
            chkHG.Enabled = false;
            chkRB.Enabled = false;
            chkSB.Enabled = false;
            chkWT.Enabled = false;
            chkLO.Enabled = false;
            chkRLU.Enabled = false;

            if (chkDS.CheckState == CheckState.Checked)
            {
                lblDC_DS.Enabled = true;
                BOpenCriteriaWeight_DS.Enabled = true;
                BCriteriaStored_DS.Enabled = true;
            }
            else
            {
                lblDC_DS.Enabled = false;
                BOpenCriteriaWeight_DS.Enabled = false;
                BCriteriaStored_DS.Enabled = false;
            }

            if (chkHG.CheckState == CheckState.Checked)
            {
                lblDC_HG.Enabled = true;
                BOpenCriteriaWeight_HG.Enabled = true;
                BCriteriaStored_HG.Enabled = true;
            }
            else
            {
                lblDC_HG.Enabled = false;
                BOpenCriteriaWeight_HG.Enabled = false;
                BCriteriaStored_HG.Enabled = false;
            }
            return;


        }
        private void FrmBMPSitingCriteria_Load(object sender, EventArgs e)
        {
            sitingProgressBar.Hide();
            try
            {
                _bMPCriteria.LoadBMPCriteria(_bMPCriteria.SitingToolCriteriaFile);

                _selectedBMPType.LoadSelectedBMPList(_selectedBMPType.SelectBMPTypeFile);
                selectedBMPTypeList = _selectedBMPType.SelectedBMP;
                Settings.LoadSettings(Settings.SitingToolSettingsFile);

                cmbBMPType.Items.Clear();
            
                Initialize_Controls();

                // Populate the dropdown for BMP type
                IEnumerator keyEnumerator = _selectedBMPType.SelectedBMP.GetEnumerator();
                while (keyEnumerator.MoveNext())
                {
                    cmbBMPType.Items.Add(keyEnumerator.Current.ToString());
                }

                /// populate the dropdown for Landownership  
                int i, iLandOwner = 0;
                IMxDocument pMxD = (IMxDocument)m_application.Document;
                IMap pMap = pMxD.FocusMap;

            
                ILayer pLayer;
                if (!string.IsNullOrEmpty(Settings.Landownerdata))
                {
                    for (i = 0; i <= (pMap.LayerCount - 1); i++)
                    {
                        pLayer = pMap.Layer[i];
                        if (pLayer.Name == Settings.Landownerdata)
                        {
                            iLandOwner = i;
                        }
                    }


                    pLayer = pMap.Layer[iLandOwner];

                    IFeatureLayer pLandOwnerLayer2 = (IFeatureLayer)pLayer;
                    IFeatureClass pLandownerLayer = pLandOwnerLayer2.FeatureClass;


                    IFeatureCursor pFeatureCur = pLandownerLayer.Search(null, false);
                    IFeature pFeature = pFeatureCur.NextFeature();

                    Dictionary<string, int> DicLO = new Dictionary<string, int>();
                    cmbDC_LO.Items.Clear();
                    i = 0;
                    string strLO; 
                    while (!(pFeature == null))
                    {
                        strLO = pFeature.Value[pFeature.Fields.FindField("Ownership")];
                        if (!(DicLO.ContainsKey(strLO)))
                        {

                            cmbDC_LO.Items.Add(strLO);
                            DicLO.Add(strLO, i);
                            i = 1 + 1;
                        }
                        pFeature = pFeatureCur.NextFeature();
                    }

                    cmbDC_LO.SelectedIndex = 0;
                }
                cmbBMPType.SelectedIndex = 0;
                cmbDC_RLU.Items.Add("1");
                cmbDC_RLU.SelectedIndex = 0;
            }
            catch (Exception exception)
            {
                MessageBox.Show("Error at FrmBMPSitingCriteria_Load: " + exception.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at FrmBMPSitingCriteria_Load: " + exception.Message);
            }
        }
        
        private void tableLayoutPanel2_Paint(object sender, PaintEventArgs e)
        {

        }



        private void label2_Click(object sender, EventArgs e)
        {

        }

        private void label4_Click(object sender, EventArgs e)
        {

        }



        private void cmbBMPType_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {

                ToolTip toolTip1 = new ToolTip();

                /// Set up the delays for the ToolTip.
                toolTip1.AutoPopDelay = 5000;
                toolTip1.InitialDelay = 1000;
                toolTip1.ReshowDelay = 500;
                toolTip1.ShowAlways = true;


                BMPobj oDefaultBMP = null;
                BMPobj oBMP = null;
                if (!string.IsNullOrEmpty(m_Prev_BMP) & (_bMPCriteria != null))
                {

                    oBMP = _bMPCriteria.GetOneBMP(m_Prev_BMP);
                    if (oBMP != null)
                    /// Now Set the Properties for the form controls.....
                    {

                        oBMP.DC_DA = lblDC_DA.Text;
                        oBMP.DC_DS = lblDC_DS.Text;
                        oBMP.DC_HG = (lblDC_HG.Text).ToUpper();
                        oBMP.DC_IMP = lblDC_IMP.Text;
                        oBMP.DC_RB = lblDC_RB.Text;
                        oBMP.DC_SB = lblDC_SB.Text;
                        oBMP.DC_BB = lblDC_BB.Text;
                        oBMP.DC_WT = lblDC_WT.Text;
                        oBMP.DC_LO = Convert.ToString(cmbDC_LO.SelectedIndex);

                        ///States......
                        if (chkDA.CheckState == CheckState.Checked)
                        {
                            oBMP.DC_DA_State = "1";
                        }
                        else
                        {
                            oBMP.DC_DA_State = "0";
                        }


                        if (chkDS.CheckState == CheckState.Checked)
                        {
                            oBMP.DC_DS_State = "1";
                        }
                        else
                        {
                            oBMP.DC_DS_State = "0";
                        }


                        if (chkHG.CheckState == CheckState.Checked)
                        {
                            oBMP.DC_HG_State = "1";
                        }
                        else
                        {
                            oBMP.DC_HG_State = "0";
                        }


                        if (chkIMP.CheckState == CheckState.Checked)
                        {
                            oBMP.DC_IMP_State = "1";
                        }
                        else
                        {
                            oBMP.DC_IMP_State = "0";
                        }


                        if (chkRB.CheckState == CheckState.Checked)
                        {
                            oBMP.DC_RB_State = "1";
                        }
                        else
                        {
                            oBMP.DC_RB_State = "0";
                        }


                        if (chkSB.CheckState == CheckState.Checked)
                        {
                            oBMP.DC_SB_State = "1";
                        }
                        else
                        {
                            oBMP.DC_SB_State = "0";
                        }

                        if (chkBB.CheckState == CheckState.Checked)
                        {
                            oBMP.DC_BB_State = "1";
                        }
                        else
                        {
                            oBMP.DC_BB_State = "0";
                        }

                        if (chkWT.CheckState == CheckState.Checked)
                        {
                            oBMP.DC_WT_State = "1";
                        }
                        else
                        {
                            oBMP.DC_WT_State = "0";
                        }

                        if (chkLO.CheckState == CheckState.Checked)
                        {
                            oBMP.DC_LO_State = "1";
                        }
                        else
                        {
                            oBMP.DC_LO_State = "0";
                        }

                        if (chkRLU.CheckState == CheckState.Checked)
                        {
                            oBMP.DC_RLU_State = "1";
                        }
                        else
                        {
                            oBMP.DC_RLU_State = "0";
                        }
                        
                        _bMPCriteria.SetOneBMP(m_Prev_BMP, oBMP);
                    }
                  
                    
                }

                // Init.....
                Initialize_Controls();

                if ((_bMPCriteria != null))
                {
                    oBMP = _bMPCriteria.GetOneBMP(cmbBMPType.Text);
                }


                if (oBMP == null)
                    return;

                // Get the default criteria to set the tooltip
                BMPCriteria bMPCriteriaDefault = new BMPCriteria(Settings.ApplicationPath);

                bMPCriteriaDefault.LoadBMPCriteria("");
                oDefaultBMP = bMPCriteriaDefault.GetOneBMP(cmbBMPType.Text);

                lblDC_DA.Text = oBMP.DC_DA;
                toolTip1.SetToolTip(lblDC_DA, "Default criteria is " + oDefaultBMP.DC_DA);

                if (!string.IsNullOrEmpty(Settings.DEMdata))
                {
                    lblDC_DA.Enabled = true;
                    chkDA.Enabled = true;
                    if (oBMP.DC_DA_State == "1")
                    {
                        chkDA.CheckState = CheckState.Checked;
                    }
                    else
                    {
                        chkDA.CheckState = CheckState.Unchecked; ;
                    }

                }
                else
                {
                    lblDC_DA.Enabled = false;
                }


                lblDC_DS.Text = oBMP.DC_DS;
                toolTip1.SetToolTip(lblDC_DS, "Default criteria is " + oDefaultBMP.DC_DS);

                if (!string.IsNullOrEmpty(Settings.DEMdata))
                {
                    lblDC_DS.Enabled = true;
                    chkDS.Enabled = true;
                    if (oBMP.DC_DS_State == "1")
                    {
                        chkDS.CheckState = CheckState.Checked;
                    }
                    else
                    {
                        chkDS.CheckState = CheckState.Unchecked;
                    }
                }
                else
                {
                    lblDC_DS.Enabled = false;
                }

                lblDC_HG.Text = oBMP.DC_HG;
                toolTip1.SetToolTip(lblDC_HG, "Default criteria is " + oDefaultBMP.DC_HG);
                if (!string.IsNullOrEmpty(Settings.Soildata))
                {
                    lblDC_HG.Enabled = true;
                    chkHG.Enabled = true;
                    if (oBMP.DC_HG_State == "1")
                    {
                        chkHG.CheckState = CheckState.Checked;
                    }
                    else
                    {
                        chkHG.CheckState = CheckState.Unchecked;
                    }
                }
                else
                {
                    lblDC_HG.Enabled = false;
                }


                lblDC_IMP.Text = oBMP.DC_IMP;
                toolTip1.SetToolTip(lblDC_IMP, "Default criteria is " + oDefaultBMP.DC_IMP);
                if (!string.IsNullOrEmpty(Settings.Imperviousdata))
                {
                    lblDC_IMP.Enabled = true;
                    chkIMP.Enabled = true;
                    if (oBMP.DC_IMP_State == "1")
                    {
                        chkIMP.CheckState = CheckState.Checked;
                    }
                    else
                    {
                        chkIMP.CheckState = CheckState.Unchecked;
                    }
                }
                else
                {
                    lblDC_IMP.Enabled = false;
                }

                lblDC_RB.Text = oBMP.DC_RB;
                toolTip1.SetToolTip(lblDC_RB, "Default criteria is " + oDefaultBMP.DC_RB + ". Three options for values are <100 for buffering inside 100 ft, >100 for buffering outside 100ft, and 50-100 for a buffering between 50 to 100 ft.");
                if (!string.IsNullOrEmpty(Settings.Roaddata))
                {
                    lblDC_RB.Enabled = true;
                    chkRB.Enabled = true;
                    if (oBMP.DC_RB_State == "1")
                    {
                        chkRB.CheckState = CheckState.Checked;
                    }
                    else
                    {
                        chkRB.CheckState = CheckState.Unchecked;
                    }
                }
                else
                {
                    lblDC_RB.Enabled = false;
                }

                lblDC_SB.Text = oBMP.DC_SB;
                toolTip1.SetToolTip(lblDC_SB, "Default criteria is " + oDefaultBMP.DC_SB + ". Three options for values are <100 for buffering inside 100 ft, >100 for buffering outside 100ft, and 50-100 for a buffering between 50 to 100 ft.");
                if (!string.IsNullOrEmpty(Settings.Streamdata))
                {
                    lblDC_SB.Enabled = true;
                    chkSB.Enabled = true;
                    if (oBMP.DC_SB_State == "1")
                    {
                        chkSB.CheckState = CheckState.Checked;
                    }
                    else
                    {
                        chkSB.CheckState = CheckState.Unchecked;
                    }
                }
                else
                {
                    lblDC_SB.Enabled = false;
                }

                lblDC_BB.Text = oBMP.DC_BB;
                toolTip1.SetToolTip(lblDC_BB, "Default criteria is " + oDefaultBMP.DC_BB + ". Three options for values are <100 for buffering inside 100 ft, >100 for buffering outside 100ft, and 50-100 for a buffering between 50 to 100 ft.");
                if (!string.IsNullOrEmpty(Settings.Landusedata))
                {
                    lblDC_BB.Enabled = true;
                    chkBB.Enabled = true;
                    if (oBMP.DC_BB_State == "1")
                    {
                        chkBB.CheckState = CheckState.Checked;
                    }
                    else
                    {
                        chkBB.CheckState = CheckState.Unchecked;
                    }
                }
                else
                {
                    lblDC_BB.Enabled = false;
                }

                lblDC_WT.Text = oBMP.DC_WT;
                toolTip1.SetToolTip(lblDC_WT, "Default criteria is " + oDefaultBMP.DC_WT);
                if (!string.IsNullOrEmpty(Settings.WTdata))
                {
                    lblDC_WT.Enabled = true;
                    chkWT.Enabled = true;
                    if (oBMP.DC_WT_State == "1")
                    {
                        chkWT.CheckState = CheckState.Checked;
                    }
                    else
                    {
                        chkWT.CheckState = CheckState.Unchecked;
                    }
                }
                else
                {
                    lblDC_WT.Enabled = false;
                }

                if (!string.IsNullOrEmpty(Settings.Landownerdata))
                {
                    chkLO.Enabled = true;
                    cmbDC_LO.SelectedIndex = 0;
                    if (oBMP.DC_LO_State == "1")
                    {
                        chkLO.CheckState = CheckState.Checked;
                    }
                    else
                    {
                        chkLO.CheckState = CheckState.Unchecked;
                    }
                }
                else
                {
                    chkLO.Enabled = false;
                }
                if ((!string.IsNullOrEmpty(Settings.Landownerdata)) & (oBMP.DC_LO_State != "0"))
                {

                    chkLO.Enabled = true;
                    cmbDC_LO.Enabled = true;
                    cmbDC_LO.SelectedIndex = Convert.ToInt16(oBMP.DC_LO);

                }
                else
                {
                    cmbDC_LO.Enabled = false;
                }

                // Raster landuse
                if (!string.IsNullOrEmpty(Settings.RasterLanduseData))
                {
                    chkRLU.Enabled = true;
                    if (oBMP.DC_RLU_State == "1")
                    {
                        chkRLU.CheckState = CheckState.Checked;
                    }
                    else
                    {
                        chkRLU.CheckState = CheckState.Unchecked;
                    }
                }
                else
                {
                    chkRLU.Enabled = false;
                }
 
                if (oBMP.DC_DS_Weight_State == "1" & !string.IsNullOrEmpty(oBMP.DC_DS_Weight))
                {
                    BOpenCriteriaWeight_DS.Visible = false;
                    BCriteriaStored_DS.Visible = true;
                }
                else
                {
                    BOpenCriteriaWeight_DS.Visible = true;
                    BCriteriaStored_DS.Visible = false;
                }

                if (oBMP.DC_HG_Weight_State == "1" & !string.IsNullOrEmpty(oBMP.DC_HG_Weight))
                {
                    BOpenCriteriaWeight_HG.Visible = false;
                    BCriteriaStored_HG.Visible = true;
                }
                else
                {
                    BOpenCriteriaWeight_HG.Visible = true;
                    BCriteriaStored_HG.Visible = false;
                }

                if (cmbBMPType.Text.ToUpper() == "GREEN ROOF")
                {
                    initialize_GreenRoof();
                }
                if (cmbBMPType.Text.ToUpper() == "POROUS PAVEMENT")
                {
                    lblDC_BB.Text = "0";
                    lblDC_BB.Enabled = false;
                } 
                // Display the Image
                ImgBMP.Image = null;
                short iCnt = 0;
                string currentImgName;
                label1.Visible = true;
                for (iCnt = 0; iCnt <= Imglst.Images.Count - 1; iCnt++)
                {
                    currentImgName = Imglst.Images.Keys[iCnt].Substring(0, Imglst.Images.Keys[iCnt].IndexOf('.'));
                    if (currentImgName.ToUpper() == (oBMP.BMPName).ToUpper())
                    {
                        ImgBMP.Image = Imglst.Images[iCnt];
                        label1.Visible = false;
                        break; 
                    }
                }

                //Store the Previous BMP......
                m_Prev_BMP = cmbBMPType.Text;

            }
            catch (Exception exception)
            {
                MessageBox.Show(this, "Error at FrmBMPSitingCriteria, cmbBMPType_SelectedIndexChanged: " + exception.Message, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(SitingToolBar.LOGFILE, "Error at FrmBMPSitingCriteria, cmbBMPType_SelectedIndexChanged: " + exception.Message);
            }
        }
        private void initialize_GreenRoof()
        {
            chkDA.CheckState = CheckState.Unchecked;
            chkDA.Enabled = false;
            lblDC_DA.Text = "";
            lblDC_DA.Enabled = false;

            chkDS.CheckState = CheckState.Unchecked;
            chkDS.Enabled = false;
            lblDC_DS.Text = "";
            lblDC_DS.Enabled = false;

            chkHG.CheckState = CheckState.Unchecked;
            chkHG.Enabled = false;
            lblDC_HG.Text = "";
            lblDC_HG.Enabled = false;

            chkIMP.CheckState = CheckState.Unchecked;
            chkIMP.Enabled = false;
            lblDC_IMP.Text = "";
            lblDC_IMP.Enabled = false;

            chkRB.CheckState = CheckState.Unchecked;
            chkRB.Enabled = false;
            lblDC_RB.Text = "";
            lblDC_RB.Enabled = false;

            chkSB.CheckState = CheckState.Unchecked;
            chkSB.Enabled = false;
            lblDC_SB.Text = "";
            lblDC_SB.Enabled = false;

            chkWT.CheckState = CheckState.Unchecked;
            chkWT.Enabled = false;
            lblDC_WT.Text = "";
            lblDC_WT.Enabled = false;

            lblDC_BB.Text = "0";
            lblDC_BB.Enabled = false;
        }

        private void lblDC_DA_TextChanged(object sender, EventArgs e)
        {

        }

        private void BOpenCriteriaWeight_DS_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(cmbBMPType.Text))
            {
                MessageBox.Show(this, "Please select a BMP type first.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            if (!SitingToolUtilities.CheckMapDocumentSavedStatus_ST(m_application))
            {
                return;
            }

            if (m_frmWeightCriteria == null || m_frmWeightCriteria.IsDisposed)
            {
                
                m_frmWeightCriteria = new FrmWeightCriteria(this);

                m_frmWeightCriteria.Icon = this.Icon;
                
                m_frmWeightCriteria.BMPCriteria = _bMPCriteria;
                m_frmWeightCriteria.IsHSG = false;
                m_frmWeightCriteria.BMPType = cmbBMPType.Text;
                m_frmWeightCriteria.TopMost = true;
                if (!m_frmWeightCriteria.Visible)
                    m_frmWeightCriteria.Show();
                return;
            }
        }

        private void BCriteriaStored_DS_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(cmbBMPType.Text))
            {
                MessageBox.Show(this, "Please select a BMP type first.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            if (!SitingToolUtilities.CheckMapDocumentSavedStatus_ST(m_application))
            {
                return;
            }

            if (m_frmWeightCriteria == null || m_frmWeightCriteria.IsDisposed)
            {
                m_frmWeightCriteria = new FrmWeightCriteria(this);
                m_frmWeightCriteria.Icon = this.Icon;

                m_frmWeightCriteria.BMPCriteria = _bMPCriteria;
                m_frmWeightCriteria.IsHSG = false;
                m_frmWeightCriteria.BMPType = cmbBMPType.Text;
                m_frmWeightCriteria.TopMost = true;
                if (!m_frmWeightCriteria.Visible)
                    m_frmWeightCriteria.Show();
                return;
            }
        }

        private void BOpenCriteriaWeight_HG_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(cmbBMPType.Text))
            {
                MessageBox.Show(this, "Please select a BMP type first.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            if (!SitingToolUtilities.CheckMapDocumentSavedStatus_ST(m_application))
            {
                return;
            }

            if (m_frmWeightCriteria == null || m_frmWeightCriteria.IsDisposed)
            {
                m_frmWeightCriteria = new FrmWeightCriteria(this);
                m_frmWeightCriteria.Icon = this.Icon;

                m_frmWeightCriteria.BMPCriteria = _bMPCriteria;
                m_frmWeightCriteria.IsHSG = true;
                m_frmWeightCriteria.BMPType = cmbBMPType.Text;
                m_frmWeightCriteria.TopMost = true;
                if (!m_frmWeightCriteria.Visible)
                    m_frmWeightCriteria.Show();
                return;
            }
        }

        private void BCriteriaStored_HG_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(cmbBMPType.Text))
            {
                MessageBox.Show(this, "Please select a BMP type first.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            if (!SitingToolUtilities.CheckMapDocumentSavedStatus_ST(m_application))
            {
                return;
            }

            if (m_frmWeightCriteria == null || m_frmWeightCriteria.IsDisposed)
            {
                m_frmWeightCriteria = new FrmWeightCriteria(this);
                m_frmWeightCriteria.Icon = this.Icon;

                m_frmWeightCriteria.BMPCriteria = _bMPCriteria;
                m_frmWeightCriteria.IsHSG = true;
                m_frmWeightCriteria.BMPType = cmbBMPType.Text;
                m_frmWeightCriteria.TopMost = true;
                if (!m_frmWeightCriteria.Visible)
                    m_frmWeightCriteria.Show();
                return;
            }
        }

        private void cmdClose_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void cmdSave_Click(object sender, EventArgs e)
        {
            try
            {
                // to save the current BMPType in the combobox
                cmbBMPType_SelectedIndexChanged(sender, e);
              
                _bMPCriteria.SaveBMPCriteria(_bMPCriteria.SitingToolCriteriaFile);
            }
            catch (Exception exception)
            {
                MessageBox.Show(this, "Error at FrmBMPSitingCriteria, cmdSave_Click: " + exception.Message, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(SitingToolBar.LOGFILE, "Error at FrmBMPSitingCriteria, cmdSave_Click: " + exception.Message);
            }
        }

        private int ComputeProgressCount()
        {
            int totalProgress = 0;
            numProgressEachBMP = new Dictionary<string, int>();
            IEnumerator resultEnumerator = _selectedBMPType.SelectedBMP.GetEnumerator();
            try
            {
                int currentBMPProgress = 0;
                while (resultEnumerator.MoveNext())
                {
                    currentBMPProgress = 0;
                    BMPobj oBMP = _bMPCriteria.GetOneBMP(resultEnumerator.Current.ToString());

                    ///Road
                    if (oBMP.DC_RB_State == "1" & (!string.IsNullOrEmpty(Settings.Roaddata)))
                    {
                        totalProgress++;
                        currentBMPProgress++;
                    }
                    ///Stream
                    if (oBMP.DC_SB_State == "1" & (!string.IsNullOrEmpty(Settings.Streamdata)))
                    {
                        totalProgress++;
                        currentBMPProgress++;
                    }
                    ///WaterTable
                    if (oBMP.DC_WT_State == "1" & (!string.IsNullOrEmpty(Settings.WTdata)))
                    {
                        totalProgress++;
                        currentBMPProgress++;
                    }
                    ///Land Ownership
                    if (oBMP.DC_LO_State == "1" & (!string.IsNullOrEmpty(Settings.Landownerdata)))
                    {
                        totalProgress++;
                        currentBMPProgress++;
                    }
                    ///HSG
                    if (oBMP.DC_HG_State == "1" & (!string.IsNullOrEmpty(Settings.Soildata)))
                    {
                        totalProgress++;
                        currentBMPProgress++;
                    }
                    ///Land Use Raster
                    if (oBMP.DC_RLU_State == "1" & (!string.IsNullOrEmpty(Settings.RasterLanduseData)))
                    {
                        totalProgress++;
                        currentBMPProgress++;
                    }
                

                    /// In the original version, if BMP is  "GREEN ROOF", "RAIN BARREL","CISTERN" or "POROUS PAVEMENT" then only Landuse will be used, 
                    ///Landusedata
                    if ((oBMP.DC_BB_State == "1" & (!string.IsNullOrEmpty(Settings.Landusedata))))
                    {
                        totalProgress++;
                        currentBMPProgress++;
                    }
                    ///impervious
                    if (oBMP.DC_IMP_State == "1" & (!string.IsNullOrEmpty(Settings.Imperviousdata)))
                    {
                        totalProgress++;
                        currentBMPProgress++;
                    }
                    /// DEM drainage criteria
                    if ((oBMP.DC_DA_State == "1") & (!string.IsNullOrEmpty(Settings.DEMdata)))
                    {
                        totalProgress++;
                        currentBMPProgress++;
                    }
                    /// DEM slope criteria
                    if ((oBMP.DC_DS_State == "1") & (!string.IsNullOrEmpty(Settings.DEMdata)))
                    {
                        totalProgress++;
                        currentBMPProgress++;
                    }
                    numProgressEachBMP.Add(resultEnumerator.Current.ToString(), totalProgress);
                }
                totalProgress++;
            }
            catch (Exception exception)
            {
                MessageBox.Show("Error at ComputeProgressCount: " + exception.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at ComputeProgressCount: " + exception.Message);
            }
            return totalProgress;
        }

        private void UpdateProgressBar()
        {
                sitingProgressBar.PerformStep();
                int percent = (int)(((double)sitingProgressBar.Value / (double)sitingProgressBar.Maximum) * 100);
                sitingProgressBar.CreateGraphics().DrawString(percent.ToString() + " % ", new Font("Arial", (float)7.25, FontStyle.Regular), Brushes.Black, new PointF(sitingProgressBar.Width / 2 - 10, sitingProgressBar.Height / 2 - 7));

        }
        private void AdjustProgressBar(int progressValue)
        {
            sitingProgressBar.Value = progressValue;
            int percent = (int)(((double)sitingProgressBar.Value / (double)sitingProgressBar.Maximum) * 100);
            sitingProgressBar.CreateGraphics().DrawString(percent.ToString() + " % ", new Font("Arial", (float)7.25, FontStyle.Regular), Brushes.Black, new PointF(sitingProgressBar.Width / 2 - 10, sitingProgressBar.Height / 2 - 7));

        }
        private void cmdStart_Click(object sender, EventArgs e)
        {
            //save the current BMP
            cmbBMPType_SelectedIndexChanged(sender, e);
            _bMPCriteria.SaveBMPCriteria(_bMPCriteria.SitingToolCriteriaFile);

            if (cmbBMPType.Items.Count == 0)
            {
                MessageBox.Show(this, "Please select at least one BMP type to proceed.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                return;
            }
          
            string pAppPath = null;
            pAppPath = SitingToolUtilities.DefineApplicationPath_ST(m_application);
            SitingToolGlobal.appCount = SitingToolGlobal.appCount + 1;

            RasterUtilities.Delete_Raster("dSlope", _settings);
            RasterUtilities.Delete_Raster("dirFLOW", _settings);

            string message = "";
            string caption = Resource.BMPSitingTitle;
            var result = DialogResult;
            ArrayList pcolResult = new ArrayList();


                
            if (SitingToolGlobal.appCount == 1)
            {

                SitingToolUtilities.SetDataDirectory_ResultFolder(m_application, _settings);

                if (Directory.Exists(pAppPath + "Cache"))
                {
                    message = "Do you want to reset cache folder? (If you are using new data source, it's recommened to click Yes.)";
                    result = MessageBox.Show(this, message, caption,
                             MessageBoxButtons.YesNo,
                             MessageBoxIcon.Question);

                    if (result == DialogResult.Yes)
                    {
                        try
                        {
                            Directory.Delete(pAppPath + "Cache", true);
                        }
                        catch (Exception exception)
                        {
                            MessageBox.Show(this, "Program cannot delete the folder: " + pAppPath + "Cache" + ". Please delete it mannually. " + exception.Message, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                            Logger.WriteToLog(SitingToolBar.LOGFILE, "Program cannot delete the folder: " + pAppPath + "Cache" + ". Please delete it mannually. " + exception.Message);
                            SitingToolGlobal.appCount = 0;
                            return;
                        }

                    }

                }
            }

            Generate_Selected_BMPs(ref pcolResult);

        }

        private void cmbDC_LO_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void chkLO_CheckedChanged(object sender, EventArgs e)
        {
            if (chkLO.CheckState == CheckState.Checked)
            {
                cmbDC_LO.Enabled = true;
            }
            else
            {
                cmbDC_LO.Enabled = false;
            }
        
        }

        private void chkRB_CheckedChanged(object sender, EventArgs e)
        {
            if (chkRB.CheckState == CheckState.Checked)
            {
                lblDC_RB.Enabled = true;
            }
            else
            {
                lblDC_RB.Enabled = false;
            }
        }

        private void chkBB_CheckedChanged(object sender, EventArgs e)
        {
            if (chkBB.CheckState == CheckState.Checked)
            {
                lblDC_BB.Enabled = true;
            }
            else
            {
                lblDC_BB.Enabled = false;
            }
            if ((cmbBMPType.Text.ToUpper() == "GREEN ROOF") | (cmbBMPType.Text.ToUpper() == "POROUS PAVEMENT"))
            {
                lblDC_BB.Enabled = false;
            }
        }

        private void chkSB_CheckedChanged(object sender, EventArgs e)
        {
            if (chkSB.CheckState == CheckState.Checked)
            {
                lblDC_SB.Enabled = true;
            }
            else
            {
                lblDC_SB.Enabled = false;
            }
        }

        private void chkWT_CheckedChanged(object sender, EventArgs e)
        {
            if (chkWT.CheckState == CheckState.Checked)
            {
                lblDC_WT.Enabled = true;
            }
            else
            {
                lblDC_WT.Enabled = false;
            }
        }

        private void chkHG_CheckedChanged(object sender, EventArgs e)
        {
            if (chkHG.CheckState == CheckState.Checked)
            {
                lblDC_HG.Enabled = true;
                BOpenCriteriaWeight_HG.Enabled = true;
                BCriteriaStored_HG.Enabled = true;
            }
            else
            {
                lblDC_HG.Enabled = false;
                BOpenCriteriaWeight_HG.Enabled = false;
                BCriteriaStored_HG.Enabled = false;
            }
            if (m_Prev_BMP != null)
            {
                BMPobj oBMP = _bMPCriteria.GetOneBMP(m_Prev_BMP);
                if (oBMP.DC_HG_Weight_State == "1")
                {
                    BOpenCriteriaWeight_HG.Visible = false;
                    BCriteriaStored_HG.Visible = true;
                }
                else
                {
                    BOpenCriteriaWeight_HG.Visible = true;
                    BCriteriaStored_HG.Visible = false;
                }
            }
           
        }

        private void chkIMP_CheckedChanged(object sender, EventArgs e)
        {
            if (chkIMP.CheckState == CheckState.Checked)
            {
                lblDC_IMP.Enabled = true;
            }
            else
            {
                lblDC_IMP.Enabled = false;
            }
        }

        private void chkDS_CheckedChanged(object sender, EventArgs e)
        {
            if (chkDS.CheckState == CheckState.Checked)
            {
                lblDC_DS.Enabled = true;
                BOpenCriteriaWeight_DS.Enabled = true;
                BCriteriaStored_DS.Enabled = true;
            }
            else
            {
                lblDC_DS.Enabled = false;
                BOpenCriteriaWeight_DS.Enabled = false;
                BCriteriaStored_DS.Enabled = false;
            }

            if (m_Prev_BMP != null)
            {
                BMPobj oBMP = _bMPCriteria.GetOneBMP(m_Prev_BMP);
                if (oBMP.DC_DS_Weight_State == "1")
                {
                    BOpenCriteriaWeight_DS.Visible = false;
                    BCriteriaStored_DS.Visible = true;
                }
                else
                {
                    BOpenCriteriaWeight_DS.Visible = true;
                    BCriteriaStored_DS.Visible = false;
                }
            }
            
        }

        private void chkDA_CheckedChanged(object sender, EventArgs e)
        {
            if (chkDA.CheckState == CheckState.Checked)
            {
                lblDC_DA.Enabled = true;
            }
            else
            {
                lblDC_DA.Enabled = false;
            }
        }

        private string GetBMPLayerNameFromTypeName(string strOriBMPType)
        {
            string strBMPLayerName = "";
            strBMPLayerName = strOriBMPType.Replace(" ", "_");
            strBMPLayerName = strBMPLayerName.Replace("-", "");
            strBMPLayerName = strBMPLayerName.Replace("(", "_");
            strBMPLayerName = strBMPLayerName.Replace(")", "_");
            return strBMPLayerName;
        }

        private bool CreateWorkfolder()
        {
            bool returnValue = true;
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;

            try
            {
                if (!Directory.Exists(_settings.WorkingfolderParent))
                {
                    Directory.CreateDirectory(_settings.WorkingfolderParent);
                }


                /////////////////////////////////////////////////////
                /// Create a Cache Folder to store the Raster output.
                /////////////////////////////////////////////////////
                if (!Directory.Exists(_settings.Rasterfolder))
                {
                    Directory.CreateDirectory(_settings.Rasterfolder);
                }
                else
                {
                    Copy_from_Cache();
                }

                IWorkspace pWkspace = null;
                pWkspace = SitingToolUtilities.GetWorkspace(_settings.WorkingfolderParent);
                ///copy standalone data table
                IWorkspace2 pWS2 = (IWorkspace2)pWkspace;
                ITable pTable = null;

                pTable = SitingToolUtilities.GetInputTable(_settings.SoilTable, pMap);
                if ((pTable != null))
                {
                    if (!pWS2.get_NameExists(esriDatasetType.esriDTTable, _settings.SoilTable))
                        Copy_Table_Data(pTable, _settings.SoilTable, pWkspace);
                }

                pTable = SitingToolUtilities.GetInputTable(_settings.RasterLanduseTable, pMap);
                if ((pTable != null))
                {
                    if (!pWS2.get_NameExists(esriDatasetType.esriDTTable, _settings.RasterLanduseTable))
                        Copy_Table_Data(pTable, _settings.RasterLanduseTable, pWkspace);
                }
            }
            catch (Exception exception)
            {
                returnValue = false;
                MessageBox.Show(this, "Error at CreateWorkfolder: " + exception.Message, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(SitingToolBar.LOGFILE, "Error at CreateWorkfolder: " + exception.Message);

            }
            return returnValue;

        }
        private double Get_Scale_Factor(ESRI.ArcGIS.esriSystem.esriUnits UnitName)
        {
            double returnValue = 0;
            try
            {
                switch (UnitName)
                {

                    case ESRI.ArcGIS.esriSystem.esriUnits.esriFeet:
                        returnValue = 1;
                        break;
                    case ESRI.ArcGIS.esriSystem.esriUnits.esriMeters:
                        returnValue = 0.3048;
                        break;
                    case ESRI.ArcGIS.esriSystem.esriUnits.esriInches:
                        returnValue = 12;
                        break;
                    case ESRI.ArcGIS.esriSystem.esriUnits.esriCentimeters:
                        returnValue = 30.48;
                        break;
                    case ESRI.ArcGIS.esriSystem.esriUnits.esriKilometers:
                        returnValue = 0.0003048009;
                        break;
                    case ESRI.ArcGIS.esriSystem.esriUnits.esriMiles:
                        returnValue = 0.0001893939;
                        break;
                    case ESRI.ArcGIS.esriSystem.esriUnits.esriMillimeters:
                        returnValue = 304.8;
                        break;
                    case ESRI.ArcGIS.esriSystem.esriUnits.esriUnknownUnits:
                        returnValue = 1;
                        break;

                }
            }
            catch (Exception exception)
            {
                MessageBox.Show(this, "Error at Get_Scale_Factor: " + exception.Message, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(SitingToolBar.LOGFILE, "Error at Get_Scale_Factor: " + exception.Message);
            }
            return returnValue;

        }
        private bool Copy_FeatureData_toWorkfolder(string strFeatureToBeCopied)
        {

            bool returnValue = true;
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
            IFeatureClass pFeatClass = null;
            IFeatureClass pFeatClassExsistence = null;
            IFeatureSelection pFeatSel = null;
            IDataset pDataset = null;
            IFeatureLayer pFeatLayer = null;

            try
            {

                IWorkspace pWkspace = SitingToolUtilities.GetWorkspace(_settings.WorkingfolderParent);

                pFeatLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strFeatureToBeCopied, pMap);
                if ((pFeatLayer != null))
                {
                    if (IsGeodatabaseFClass((IDataLayer2)pFeatLayer))
                    {
                        pFeatClassExsistence = SitingToolUtilities.OpenShapeFile(_settings.WorkingfolderParent, strFeatureToBeCopied);
                        if (pFeatClassExsistence == null)
                        {
                            pFeatSel = (IFeatureSelection)pFeatLayer;
                            pFeatSel.SelectFeatures(null, esriSelectionResultEnum.esriSelectionResultNew, false);
                            pFeatClass = Get_ExportedShapefile((IFeatureLayer)pFeatLayer, strFeatureToBeCopied, false);
                        }
                    }
                    else
                    {
                        pFeatClass = pFeatLayer.FeatureClass;
                        pDataset = (IDataset)pFeatClass;
                        if (pDataset.CanCopy())
                        {
                            pDataset.Copy(strFeatureToBeCopied, pWkspace);
                        }
                    }
                }
                returnValue = true;


            }
            catch (Exception exception)
            {
                returnValue = false;
                MessageBox.Show(this, "Error at Copy_FeatureData_toWorkfolder: " + exception.Message, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(SitingToolBar.LOGFILE, "Error at Copy_FeatureData_toWorkfolder: " + exception.Message);

            }
            finally
            {

                if (pFeatLayer != null)
                {
                    Marshal.FinalReleaseComObject(pFeatLayer);
                }
                if (pFeatClass != null)
                {
                    Marshal.FinalReleaseComObject(pFeatClass);
                }
            }

            return returnValue;

        }

        private void Copy_SoilFeatureData_toWorkfolder(string strFeatureToBeCopied, string strTableToJoin, string strFieldInLayer, string strFieldInTable, ref string strOutput)
        {
            IStandaloneTable pStTab = null;
            IFeatureLayer pFLayer = null;
            IDisplayTable pDispTable = null;
            IDisplayTable pDispTable2 = null;
            ITable pReltable = null;
            ITable pTable = null;
            try
            {
                Copy_FeatureData_toWorkfolder(strFeatureToBeCopied);
                if (strTableToJoin.Length > 0)
                {

                    pStTab = SitingToolUtilities.GetDataTable(_settings.WorkingfolderParent, strTableToJoin);
                    if ((pStTab != null))
                    {
                        pFLayer = (IFeatureLayer)SitingToolUtilities.GetFeatureLayer(_settings.WorkingfolderParent, strFeatureToBeCopied);
                        /// Get the Layer from Working folder....
                        if ((pFLayer != null))
                        {
                            pDispTable = (IDisplayTable)pFLayer;
                            pTable = pDispTable.DisplayTable;

                            pDispTable2 = (IDisplayTable)pStTab;
                            pReltable = pDispTable2.DisplayTable;

                            strOutput = RasterUtilities.Create_Join(pFLayer, pTable, strFieldInLayer, pReltable, strFieldInTable, _settings);
                        }
                    }
                }
            }
            catch (Exception exception)
            {
                MessageBox.Show(this, "Error at Copy_SoilFeatureData_toWorkfolder: " + exception.Message, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(SitingToolBar.LOGFILE, "Error at Copy_SoilFeatureData_toWorkfolder: " + exception.Message);

            }

        }
        private bool IsGeodatabaseFClass(IDataLayer2 pDLayer)
        {
            bool returnValue = false;
            IDatasetName pDSName = (IDatasetName)pDLayer.DataSourceName;

            if (pDSName.Category == "Personal Geodatabase Feature Class" | pDSName.Category == "File Geodatabase Feature Class")
            {
                returnValue = true;
            }
            return returnValue;

        }
        private IFeatureClass Get_ExportedShapefile(IFeatureLayer pFLayer, string strExportName, bool pDissolve)
        {
            IFeatureClass returnValue = null;

            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;

            IFeatureClass pfc = pFLayer.FeatureClass;

            ///Get the FcName from the featureclass
            IDataset pDataset = (IDataset)pfc;

            IFeatureClassName pINFeatureClassName = (IFeatureClassName)pDataset.FullName;
            IDatasetName pInDsName = null;

            ///Get the selection set
            IFeatureSelection pFSel = (IFeatureSelection)pFLayer;

            ISelectionSet pSelset = pFSel.SelectionSet;

            ///Create a new feature class name
            /// Define the output feature class name
            IFeatureClassName pFeatureClassName = (IFeatureClassName)new FeatureClassName();

            IDatasetName pOutDatasetName = (IDatasetName)pFeatureClassName;

            IWorkspaceName pWorkspaceName = (IWorkspaceName)new WorkspaceName();
            IExportOperation pExportOp = null;
            IFeatureLayer pLayer = null;
            IFeatureClass pFeatClass = null;

            pWorkspaceName.PathName = _settings.WorkingfolderParent;
            pWorkspaceName.WorkspaceFactoryProgID = "esriDataSourcesFile.shapefileworkspacefactory.1";
            pOutDatasetName.WorkspaceName = pWorkspaceName;


            /// Check if the Feature Class Exists....
            pFeatClass = SitingToolUtilities.OpenShapeFile(_settings.WorkingfolderParent, strExportName);
            ///Get an available shapefile name
            if ((pFeatClass != null))
            {
                strExportName = Get_Available_name(strExportName);
            }

            pFeatureClassName.FeatureType = esriFeatureType.esriFTSimple;
            pFeatureClassName.ShapeType = esriGeometryType.esriGeometryAny;
            pFeatureClassName.ShapeFieldName = "Shape";
            pOutDatasetName.Name = strExportName;

            //Export
            try
            {
                pExportOp = new ExportOperation();
                pInDsName = (IDatasetName)pINFeatureClassName;
                pExportOp.ExportFeatureClass((IDatasetName)pInDsName, null, pSelset, null, (IFeatureClassName)pOutDatasetName, 0);
            }
            catch (Exception exception)
            {
                MessageBox.Show(this, "Error at Get_ExportedShapefile: in exporting " + pInDsName.Name + ", saving as " + strExportName + ". " + exception.Message, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(SitingToolBar.LOGFILE, "Error at Get_ExportedShapefile: in exporting " + pInDsName.Name + ", saving as " +strExportName + ". " + exception.Message);
            }

            try
            {
                if (pDissolve)
                {
                    ///////////////////////////////////////////////////
                    /// Dissolve the Features to make one feature....
                    ///////////////////////////////////////////////////

                    ///geoprocessing
                    Geoprocessor GP = new Geoprocessor();
                    Dissolve pDissolveFClass = new Dissolve();
                    pDissolveFClass.in_features = _settings.WorkingfolderParent + "\\" + strExportName + Resource.ShapeFileExt;
                    pDissolveFClass.out_feature_class = _settings.WorkingfolderParent + "\\" + strExportName + Resource.Dis + "_" + Convert.ToString(SitingToolGlobal.appCount) + "_" + Convert.ToString(SitingToolGlobal.createdSoilCount) + Resource.ShapeFileExt;
                    pDissolveFClass.multi_part = Resource.multiPART;
                    GP.Execute(pDissolveFClass, null);

                    /// Delete the undissolved Shapefile......
                    pDataset = (IDataset)SitingToolUtilities.OpenShapeFile(_settings.WorkingfolderParent, strExportName);
                    if (pDataset.CanDelete())
                        pDataset.Delete();

                    /// Rename the dissolved dataset........
                    pDataset = (IDataset)SitingToolUtilities.OpenShapeFile(_settings.WorkingfolderParent, strExportName + Resource.Dis + "_" + Convert.ToString(SitingToolGlobal.appCount) + "_" + Convert.ToString(SitingToolGlobal.createdSoilCount));
                    if (pDataset.CanRename())
                        pDataset.Rename(strExportName);

                    /// Delete the renamed Layer form the Map.......
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strExportName + Resource.Dis + "_" + Convert.ToString(SitingToolGlobal.appCount) + "_" + Convert.ToString(SitingToolGlobal.createdSoilCount), pMap);

                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                }

                ///Return the exported shape file.....
                returnValue = SitingToolUtilities.OpenShapeFile(_settings.WorkingfolderParent, strExportName);

            }
            catch (Exception exception)
            {

                MessageBox.Show(this, "Error at Get_ExportedShapefile: when using " + strExportName + ". " + exception.Message, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(SitingToolBar.LOGFILE, "Error at Get_ExportedShapefile: when using " + strExportName + ". " + exception.Message);

            }
            finally
            {
                //if (pDataset != null)
                //    Marshal.FinalReleaseComObject(pDataset); // cannot be released because it is holding returnValue
                if (pExportOp != null)
                    Marshal.FinalReleaseComObject(pExportOp);
                if (pfc != null)
                    Marshal.FinalReleaseComObject(pfc);
                if (pFeatClass != null)
                    Marshal.FinalReleaseComObject(pFeatClass);
                if (pFeatureClassName != null)
                    Marshal.FinalReleaseComObject(pFeatureClassName);
                //if (pFSel != null)
                //    Marshal.FinalReleaseComObject(pFSel); // cannot be released
                if (pInDsName != null)
                    Marshal.FinalReleaseComObject(pInDsName);
                if (pINFeatureClassName != null)
                    Marshal.FinalReleaseComObject(pINFeatureClassName);
                if (pLayer != null)
                    Marshal.FinalReleaseComObject(pLayer);
                if (pOutDatasetName != null)
                    Marshal.FinalReleaseComObject(pOutDatasetName);
                if (pWorkspaceName != null)
                    Marshal.FinalReleaseComObject(pWorkspaceName);
            }
            return returnValue;


        }
        private IFeatureClass Get_CopySelectedShapefile(string strSourceName, string strExportName, string whereClause, bool pDissolve)
        {
            IFeatureClass returnValue = null;

            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;

            IFeatureLayer pLayer = null;

            IDataset pDataset = null;

            try
            {

                Geoprocessor GP = new Geoprocessor();
                GP.OverwriteOutput = true;
                GP.SetEnvironmentValue("workspace", Settings.WorkingfolderParent);

                Copy pCopy = new Copy();
                pCopy.in_data = Settings.WorkingfolderParent + "\\" + strSourceName + Resource.ShapeFileExt;
                pCopy.out_data = Settings.WorkingfolderParent + "\\" + strExportName;
                GP.Execute(pCopy, null);

                MakeFeatureLayer pMakeFeatureLayer = new MakeFeatureLayer();
                pMakeFeatureLayer.in_features = Settings.WorkingfolderParent + "\\" + strExportName + Resource.ShapeFileExt;
                pMakeFeatureLayer.out_layer = Resource.TempLayer;
                GP.Execute(pMakeFeatureLayer, null);

                SelectLayerByAttribute pSelectLayerByAttribute = new SelectLayerByAttribute();
                pSelectLayerByAttribute.in_layer_or_view = Resource.TempLayer;
                pSelectLayerByAttribute.out_layer_or_view = strExportName;
                pSelectLayerByAttribute.where_clause = whereClause;
                GP.Execute(pSelectLayerByAttribute, null);

                DeleteFeatures pDeleteFeatures = new DeleteFeatures();
                pDeleteFeatures.in_features = Resource.TempLayer;
                GP.Execute(pDeleteFeatures, null);

                if (pDissolve)
                {
                    ///////////////////////////////////////////////////
                    /// Dissolve the Features to make one feature....
                    ///////////////////////////////////////////////////

                    ///geoprocessing
                    Dissolve pDissolveFClass = new Dissolve();
                    pDissolveFClass.in_features = _settings.WorkingfolderParent + "\\" + strExportName + Resource.ShapeFileExt;
                    pDissolveFClass.out_feature_class = _settings.WorkingfolderParent + "\\" + strExportName + Resource.Dis + "_" + Convert.ToString(SitingToolGlobal.appCount) + "_" + Convert.ToString(SitingToolGlobal.createdSoilCount) + Resource.ShapeFileExt;
                    pDissolveFClass.multi_part = Resource.multiPART;
                    GP.Execute(pDissolveFClass, null);

                    /// Delete the undissolved Shapefile......
                    pDataset = (IDataset)SitingToolUtilities.OpenShapeFile(_settings.WorkingfolderParent, strExportName);
                    if (pDataset.CanDelete())
                        pDataset.Delete();

                    /// Rename the dissolved dataset........
                    pDataset = (IDataset)SitingToolUtilities.OpenShapeFile(_settings.WorkingfolderParent, strExportName + Resource.Dis + "_" + Convert.ToString(SitingToolGlobal.appCount) + "_" + Convert.ToString(SitingToolGlobal.createdSoilCount));
                    if (pDataset.CanRename())
                        pDataset.Rename(strExportName);

                    /// Delete the renamed Layer form the Map.......
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strExportName + Resource.Dis + "_" + Convert.ToString(SitingToolGlobal.appCount) + "_" + Convert.ToString(SitingToolGlobal.createdSoilCount), pMap);

                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                }
                ///Return the exported shape file.....
                returnValue = SitingToolUtilities.OpenShapeFile(_settings.WorkingfolderParent, strExportName);

            }
            catch (Exception exception)
            {
                MessageBox.Show(this, "Error at Get_CopySelectedShapefile: when exporting " + strExportName + ". " + exception.Message, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(SitingToolBar.LOGFILE, "Error at Get_CopySelectedShapefile: when exporting " + strExportName + ". " + exception.Message);
            }
            finally
            {

            }
            return returnValue;


        }
        private string Get_Available_name(string strName)
        {
            string returnValue = null;

            string strTmp = strName;
            int iCnt = 0;
            try
            {
                IWorkspaceFactory pWsFact = new ESRI.ArcGIS.DataSourcesFile.ShapefileWorkspaceFactory();
                IPropertySet ConnectionProperties = null;
                ConnectionProperties = new PropertySet();
                ConnectionProperties.SetProperty("DATABASE", _settings.WorkingfolderParent);
                IFeatureWorkspace pShapeWS = (IFeatureWorkspace)pWsFact.Open(ConnectionProperties, 0);
                IWorkspace2 pWS2 = (IWorkspace2)pShapeWS;
                     
                while (pWS2.get_NameExists(esriDatasetType.esriDTFeatureClass, strTmp))
                {
                    iCnt = iCnt + 1;
                    strTmp = strName + "_" + iCnt;
                }
                returnValue = strTmp;
            }
            catch (Exception exception)
            {

                MessageBox.Show(this, "Error at Get_Available_name: " + exception.Message, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(SitingToolBar.LOGFILE, "Error at Get_Available_name: " + exception.Message);
            }


            return returnValue;

        }
        private void Copy_from_Cache()
        {

            IFeatureClass pFeatClass1 = null;
            IFeatureClass pFeatClass2 = null;
            IDataset pDataset = null;
            try
            {
                pFeatClass1 = SitingToolUtilities.OpenShapeFile(_settings.Rasterfolder, Resource.SLOPERas);
                pFeatClass2 = SitingToolUtilities.OpenShapeFile(_settings.Rasterfolder, Resource.FLOWRas);
                RasterUtilities.Delete_Dataset_ST(_settings.WorkingfolderParent, Resource.SLOPERas);
                RasterUtilities.Delete_Dataset_ST(_settings.WorkingfolderParent, Resource.FLOWRas);

                IWorkspace pWkspace = SitingToolUtilities.GetWorkspace(_settings.WorkingfolderParent);

                ///Copy Slope Data
                if ((pFeatClass1 != null))
                {
                    pDataset = (IDataset)pFeatClass1;
                    if (pDataset.CanCopy())
                    {
                        pDataset.Copy(Resource.SLOPERas, pWkspace);
                    }
                }

                //Copy Flow Data
                if ((pFeatClass2 != null))
                {
                    pDataset = (IDataset)pFeatClass2;
                    if (pDataset.CanCopy())
                    {
                        pDataset.Copy(Resource.FLOWRas, pWkspace);
                    }
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at Copy_from_Cache: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at Copy_from_Cache: " + e.Message);
            }
            finally
            {
                if (pFeatClass1 != null)
                    Marshal.FinalReleaseComObject(pFeatClass1);
                if (pFeatClass2 != null)
                    Marshal.FinalReleaseComObject(pFeatClass2);
                if (pDataset != null)
                    Marshal.FinalReleaseComObject(pDataset);
            }
            return;


        }
        private void Copy_Table_Data(ITable pTable, string pTableName,IWorkspace pWkspace)
        {


            //Get the Table Name and pass it to Dataset Name
            IDataset pDataset = (IDataset)pTable;

            ITableName pInTableName = (ITableName)pDataset.FullName;

            IDatasetName pInDsName = (IDatasetName)pInTableName;

            // create a new output table name and pass it to dataset name
            ITableName pOutTableName = (ITableName)new TableName();

            IDatasetName pOutDSName = (IDatasetName)pOutTableName;
            pOutDSName.Name = pTableName;
            // Define the name

            try
            {
                IWorkspaceName pWorkspaceName = (IWorkspaceName)new WorkspaceName();

                pWorkspaceName.PathName = pWkspace.PathName;
                pWorkspaceName.WorkspaceFactoryProgID = "esriCore.shapefileworkspacefactory.1";

                pOutDSName.WorkspaceName = pWorkspaceName;

                IExportOperation pExportOp = new ExportOperation();

                pExportOp.ExportTable(pInDsName, null, null, pOutDSName, 0);
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at Copy_Table_Data: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at Copy_Table_Data: " + e.Message);
            }
            return;

        }
        private void PrepareBufferFeature(string strExp, string strWorkspace, string InFlayerName)
        {

            int bufferMin = 0;
            int bufferMax = 0;
            double dScalefac = 0;
            // Get the Map units....
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
            dScalefac = Get_Scale_Factor(pMap.MapUnits);

            ///parse strExp
            ///check >min
            if (strExp.Contains('>'))
            {
                bufferMin = Convert.ToInt16(Convert.ToDouble(strExp.Substring(strExp.IndexOf('>') + 1)) * dScalefac);
                bufferMax = -1;
            }

            ///check <max
            if (strExp.Contains('<'))
            {
                bufferMax = Convert.ToInt16(Convert.ToDouble(strExp.Substring(strExp.IndexOf('<') + 1)) * dScalefac);
                bufferMin = -1;
            }

            ///check min-max
            if (strExp.Contains('-'))
            {
                bufferMin = Convert.ToInt16(Convert.ToDouble(strExp.Substring(0, strExp.IndexOf('-'))) * dScalefac);
                bufferMax = Convert.ToInt16(Convert.ToDouble(strExp.Substring(strExp.IndexOf('-') + 1)) * dScalefac);
            }

            CreateSingleBufferFeature(bufferMin, bufferMax, strWorkspace, InFlayerName);
        }
        private void CreateSingleBufferFeature(int bufferMin, int bufferMax, string strWorkspacePath, string InFlayerName)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
            try
            {
                string strWorkspace = null;
                string bufferIndex = Convert.ToString(SitingToolGlobal.createdSoilCount);
                string appIndex = Convert.ToString(SitingToolGlobal.appCount);


                ///if workspace path has no \ at end, add it
                if (strWorkspacePath.Substring(strWorkspacePath.Length - 2, 2) != "\\")
                {
                    strWorkspace = strWorkspacePath + "\\";
                }
                string nameBufferMax = InFlayerName + Resource.BufMax + bufferIndex + "_" + appIndex;
                string nameBufferMin = InFlayerName + Resource.BufMin + bufferIndex + "_" + appIndex;

                string nameDissMax = InFlayerName + Resource.DisMax + bufferIndex + "_" + appIndex;
                string nameDissMin = InFlayerName + Resource.DisMin + bufferIndex + "_" + appIndex;

                string nameBuffer = InFlayerName + Resource.Buf + bufferIndex + "_" + appIndex;

                IFeatureLayer pInlayer = null;
                //possible to be polyline layer or polygon layer
                pInlayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(InFlayerName, pMap);
                IEnvelope pEnv = null;

                ///geoprocessing
                Geoprocessor GP = new Geoprocessor();
                ESRI.ArcGIS.AnalysisTools.Buffer pBuffer = new ESRI.ArcGIS.AnalysisTools.Buffer();
                Dissolve pDissolve = new Dissolve();
                Union pUnion = new Union();

                ///no min value or min=0, format: <max
                if (bufferMin <= 0)
                {
                    ///polygon
                    if (pInlayer.FeatureClass.ShapeType == ESRI.ArcGIS.Geometry.esriGeometryType.esriGeometryPolygon)
                    {

                        ///buffer max
                        pBuffer.in_features = strWorkspace + InFlayerName + Resource.ShapeFileExt;
                        pBuffer.out_feature_class = strWorkspace + nameBufferMax + Resource.ShapeFileExt;
                        pBuffer.buffer_distance_or_field = bufferMax;
                        GP.Execute(pBuffer, null);

                        ///dissolve max
                        pDissolve.in_features = strWorkspace + nameBufferMax + Resource.ShapeFileExt;
                        pDissolve.out_feature_class = strWorkspace + nameDissMax + Resource.ShapeFileExt;
                        pDissolve.multi_part = Resource.multiPART;
                        GP.Execute(pDissolve, null);

                        ///dissolve self as min
                        pDissolve.in_features = strWorkspace + InFlayerName + Resource.ShapeFileExt;
                        pDissolve.out_feature_class = strWorkspace + nameDissMin + Resource.ShapeFileExt;
                        pDissolve.multi_part = Resource.multiPART;
                        GP.Execute(pDissolve, null);

                        ///union & remove
                        pUnion.in_features = strWorkspace + InFlayerName + Resource.ShapeFileExt + ";" + strWorkspace + nameDissMax + Resource.ShapeFileExt;
                        pUnion.out_feature_class = strWorkspace + nameBuffer + Resource.ShapeFileExt;
                        pUnion.gaps = Resource.GAPS;
                        pUnion.join_attributes = Resource.onlyFID;
                        GP.Execute(pUnion, null);

                        RemoveOverlap(nameBuffer);

                    }
                    else///polyline
                    {
                        ///buffer max
                        pBuffer.in_features = strWorkspace + InFlayerName + Resource.ShapeFileExt;
                        pBuffer.out_feature_class = strWorkspace + nameBufferMax + Resource.ShapeFileExt;
                        pBuffer.buffer_distance_or_field = bufferMax;
                        GP.Execute(pBuffer, null);

                        ///dissolve max
                        pDissolve.in_features = strWorkspace + nameBufferMax + Resource.ShapeFileExt;
                        pDissolve.out_feature_class = strWorkspace + nameBuffer + Resource.ShapeFileExt;
                        pDissolve.multi_part = Resource.multiPART;
                        GP.Execute(pDissolve, null);
                    }
                }
                else if (bufferMax <= 0) //no max value, then max is assumed to be full extent, format: >min
                {
                    ///same for polygon and polyline
                    ///buffer min
                    pBuffer.in_features = strWorkspace + InFlayerName + Resource.ShapeFileExt;
                    pBuffer.out_feature_class = strWorkspace + nameBufferMin + Resource.ShapeFileExt;
                    pBuffer.buffer_distance_or_field = bufferMin;
                    GP.Execute(pBuffer, null);

                    ///dissolve min
                    pDissolve.in_features = strWorkspace + nameBufferMin + Resource.ShapeFileExt;
                    pDissolve.out_feature_class = strWorkspace + nameDissMin + Resource.ShapeFileExt;
                    pDissolve.multi_part = Resource.multiPART;
                    GP.Execute(pDissolve, null);

                    ///create max as full extent
                    pMxD = (IMxDocument)m_application.Document;
                    pEnv = pMxD.ActiveView.FullExtent;
                    GenerateLayerWholeExtent(strWorkspacePath, nameBufferMax);

                    //union and remove
                    pUnion.in_features = strWorkspace + nameBufferMin + Resource.ShapeFileExt + ";" + strWorkspace + nameBufferMax + Resource.ShapeFileExt;
                    pUnion.out_feature_class = strWorkspace + nameBuffer + Resource.ShapeFileExt;
                    pUnion.join_attributes = Resource.onlyFID;
                    pUnion.gaps = Resource.GAPS;
                    GP.Execute(pUnion, null);

                    RemoveOverlap(nameBuffer);
                }
                else///format min-max
                {

                    ///buffer max
                    pBuffer.in_features = strWorkspace + InFlayerName + Resource.ShapeFileExt;
                    pBuffer.out_feature_class = strWorkspace + nameBufferMax + Resource.ShapeFileExt;
                    pBuffer.buffer_distance_or_field = bufferMax;
                    GP.Execute(pBuffer, null);

                    ///buffer min
                    pBuffer.in_features = strWorkspace + InFlayerName + Resource.ShapeFileExt;
                    pBuffer.out_feature_class = strWorkspace + nameBufferMin + Resource.ShapeFileExt;
                    pBuffer.buffer_distance_or_field = bufferMin;
                    GP.Execute(pBuffer, null);

                    ///dissolve max
                    pDissolve.in_features = strWorkspace + nameBufferMax + Resource.ShapeFileExt;
                    pDissolve.out_feature_class = strWorkspace + nameDissMax + Resource.ShapeFileExt;
                    pDissolve.multi_part = Resource.multiPART;
                    GP.Execute(pDissolve, null);

                    ///dissolve min
                    pDissolve.in_features = strWorkspace + nameBufferMin + Resource.ShapeFileExt;
                    pDissolve.out_feature_class = strWorkspace + nameDissMin + Resource.ShapeFileExt;
                    pDissolve.multi_part = Resource.multiPART;
                    GP.Execute(pDissolve, null);

                    ///union and remove
                    pUnion.in_features = strWorkspace + nameDissMin + Resource.ShapeFileExt + ";" + strWorkspace + nameDissMax + Resource.ShapeFileExt;
                    pUnion.out_feature_class = strWorkspace + nameBuffer + Resource.ShapeFileExt;
                    pUnion.join_attributes = Resource.onlyFID;
                    pUnion.gaps = Resource.GAPS;
                    GP.Execute(pUnion, null);

                    RemoveOverlap(nameBuffer);

                }
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at CreateSingleBufferFeature: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at CreateSingleBufferFeature: " + e.Message);
            }
            finally
            {
            }
            return;

        }
        private void CreateSingleBufferFeature_inMemory(int bufferMin, int bufferMax, string strWorkspacePath, string InFlayerName)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;

            Geoprocessor GP = new Geoprocessor();
            ESRI.ArcGIS.AnalysisTools.Buffer pBuffer = new ESRI.ArcGIS.AnalysisTools.Buffer();
            Dissolve pDissolve = new Dissolve();
            Union pUnion = new Union();

            try
            {
                string strWorkspace = null;
                string bufferIndex = Convert.ToString(SitingToolGlobal.createdSoilCount);
                string appIndex = Convert.ToString(SitingToolGlobal.appCount);
            

                ///if workspace path has no \ at end, add it
                if (strWorkspacePath.Substring(strWorkspacePath.Length - 2, 2) != "\\")
                {
                    strWorkspace = strWorkspacePath + "\\";
                }
                string nameBufferMax = InFlayerName + Resource.BufMax + bufferIndex + "_" + appIndex;
                string nameBufferMin = InFlayerName + Resource.BufMin + bufferIndex + "_" + appIndex;

                string nameDissMax = InFlayerName + Resource.DisMax + bufferIndex + "_" + appIndex;
                string nameDissMin = InFlayerName + Resource.DisMin + bufferIndex + "_" + appIndex;
                                
                string nameBuffer = InFlayerName + Resource.Buf + bufferIndex + "_" + appIndex;

                IFeatureLayer pInlayer = null;
                //possible to be polyline layer or polygon layer
                pInlayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(InFlayerName, pMap);
                IEnvelope pEnv = null;

                ///geoprocessing
           
                ///no min value or min=0, format: <max
                if (bufferMin <= 0)
                {
                    ///polygon
                    if (pInlayer.FeatureClass.ShapeType == ESRI.ArcGIS.Geometry.esriGeometryType.esriGeometryPolygon)
                    {

                        ///buffer max
                        ///in memory
                        pBuffer.in_features = strWorkspace + InFlayerName + Resource.ShapeFileExt;
                        //pBuffer.out_feature_class = strWorkspace + nameBufferMax + Resource.ShapeFileExt;
                        pBuffer.out_feature_class = Resource.InMemory + "\\" + nameBufferMax;
                        pBuffer.buffer_distance_or_field = bufferMax;
                        GP.Execute(pBuffer, null);

                        ///dissolve max
                        //pDissolve.in_features = strWorkspace + nameBufferMax + Resource.ShapeFileExt;
                        pDissolve.in_features = Resource.InMemory + "\\" + nameBufferMax;
                        //pDissolve.out_feature_class = strWorkspace + nameDissMax + Resource.ShapeFileExt;
                        pDissolve.out_feature_class = Resource.InMemory + "\\" + nameDissMax;
                        pDissolve.multi_part = Resource.multiPART;
                        GP.Execute(pDissolve, null);

                        ///dissolve self as min
                        pDissolve.in_features = strWorkspace + InFlayerName + Resource.ShapeFileExt;
                        //pDissolve.out_feature_class = strWorkspace + nameDissMin + Resource.ShapeFileExt;
                        pDissolve.out_feature_class = Resource.InMemory + "\\" + nameDissMin;
                        pDissolve.multi_part = Resource.multiPART;
                        GP.Execute(pDissolve, null);

                        ///union & remove
                        //pUnion.in_features = strWorkspace + InFlayerName + Resource.ShapeFileExt + ";" + strWorkspace + nameDissMax + Resource.ShapeFileExt;
                        pUnion.in_features = Resource.InMemory + "\\" + nameDissMin + ";" + Resource.InMemory + "\\" + nameDissMax;
                        pUnion.out_feature_class = strWorkspace + nameBuffer + Resource.ShapeFileExt;
                        pUnion.gaps = Resource.GAPS;
                        pUnion.join_attributes = Resource.onlyFID;
                        GP.Execute(pUnion, null);

                        RemoveOverlap(nameBuffer);
                    
                    }
                    else///polyline
                    {
                        ///buffer max
                        pBuffer.in_features = strWorkspace + InFlayerName + Resource.ShapeFileExt;
                        //pBuffer.out_feature_class = strWorkspace + nameBufferMax + Resource.ShapeFileExt;
                        pBuffer.out_feature_class = Resource.InMemory + "\\" + nameBufferMax;
                        pBuffer.buffer_distance_or_field = bufferMax;
                        GP.Execute(pBuffer, null);

                        ///dissolve max
                        //pDissolve.in_features = strWorkspace + nameBufferMax + Resource.ShapeFileExt;
                        pDissolve.in_features = Resource.InMemory + "\\" + nameBufferMax;
                        pDissolve.out_feature_class = strWorkspace + nameBuffer + Resource.ShapeFileExt;
                        pDissolve.multi_part = Resource.multiPART;
                        GP.Execute(pDissolve, null);
                    }
                }
                else if (bufferMax <= 0) //no max value, then max is assumed to be full extent, format: >min
                {
                    ///same for polygon and polyline
                    ///buffer min
                    pBuffer.in_features = strWorkspace + InFlayerName + Resource.ShapeFileExt;
                    //pBuffer.out_feature_class = strWorkspace + nameBufferMin + Resource.ShapeFileExt;
                    pBuffer.out_feature_class = Resource.InMemory + "\\" + nameBufferMin;
                    pBuffer.buffer_distance_or_field = bufferMin;
                    GP.Execute(pBuffer, null);

                    /////dissolve min
                    ////pDissolve.in_features = strWorkspace + nameBufferMin + Resource.ShapeFileExt;
                    //pDissolve.in_features = Resource.InMemory + "\\" + nameBufferMin;
                    //pDissolve.out_feature_class = strWorkspace + nameDissMin + Resource.ShapeFileExt;
                    //pDissolve.multi_part = Resource.multiPART;
                    //GP.Execute(pDissolve, null);

                    ///create max as full extent
                    pMxD = (IMxDocument)m_application.Document;
                    pEnv = pMxD.ActiveView.FullExtent;
                    GenerateLayerWholeExtent(strWorkspacePath, nameBufferMax);

                    //union and remove
                    //pUnion.in_features = strWorkspace + nameBufferMin + Resource.ShapeFileExt + ";" + strWorkspace + nameBufferMax + Resource.ShapeFileExt;
                    pUnion.in_features = Resource.InMemory + "\\" + nameBufferMin + ";" + strWorkspace + nameBufferMax + Resource.ShapeFileExt;
                    pUnion.out_feature_class = strWorkspace + nameBuffer + Resource.ShapeFileExt;
                    pUnion.join_attributes = Resource.onlyFID;
                    pUnion.gaps = Resource.GAPS;
                    GP.Execute(pUnion, null);

                    RemoveOverlap(nameBuffer);
                }
                else///format min-max
                {

                    ///buffer max
                    pBuffer.in_features = strWorkspace + InFlayerName + Resource.ShapeFileExt;
                    //pBuffer.out_feature_class = strWorkspace + nameBufferMax + Resource.ShapeFileExt;
                    pBuffer.out_feature_class = Resource.InMemory + "\\" + nameBufferMax;
                    pBuffer.buffer_distance_or_field = bufferMax;
                    GP.Execute(pBuffer, null);

                    ///buffer min
                    pBuffer.in_features = strWorkspace + InFlayerName + Resource.ShapeFileExt;
                    //pBuffer.out_feature_class = strWorkspace + nameBufferMin + Resource.ShapeFileExt;
                    pBuffer.out_feature_class = Resource.InMemory + "\\" + nameBufferMin;
                    pBuffer.buffer_distance_or_field = bufferMin;
                    GP.Execute(pBuffer, null);

                    ///dissolve max
                    //pDissolve.in_features = strWorkspace + nameBufferMax + Resource.ShapeFileExt;
                    pDissolve.in_features = Resource.InMemory + "\\" + nameBufferMax;
                    //pDissolve.out_feature_class = strWorkspace + nameDissMax + Resource.ShapeFileExt;
                    pDissolve.out_feature_class = Resource.InMemory + "\\" + nameDissMax;
                    pDissolve.multi_part = Resource.multiPART;
                    GP.Execute(pDissolve, null);

                    ///dissolve min
                    //pDissolve.in_features = strWorkspace + nameBufferMin + Resource.ShapeFileExt;
                    pDissolve.in_features = Resource.InMemory + "\\" + nameBufferMin;
                    //pDissolve.out_feature_class = strWorkspace + nameDissMin + Resource.ShapeFileExt;
                    pDissolve.out_feature_class = Resource.InMemory + "\\" + nameDissMin;
                    pDissolve.multi_part = Resource.multiPART;
                    GP.Execute(pDissolve, null);

                    ///union and remove
                    //pUnion.in_features = strWorkspace + nameDissMin + Resource.ShapeFileExt + ";" + strWorkspace + nameDissMax + Resource.ShapeFileExt;
                    pUnion.in_features = Resource.InMemory + "\\" + nameDissMin + ";" + Resource.InMemory + "\\" + nameDissMax;
                    pUnion.out_feature_class = strWorkspace + nameBuffer + Resource.ShapeFileExt;
                    pUnion.join_attributes = Resource.onlyFID;
                    pUnion.gaps = Resource.GAPS;
                    GP.Execute(pUnion, null);

                    RemoveOverlap(nameBuffer);

                }
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at CreateSingleBufferFeature: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at CreateSingleBufferFeature: " + e.Message);
            }
            finally
            {
                //Marshal.FinalReleaseComObject(GP);
                GP = null;
                //Marshal.FinalReleaseComObject(pBuffer);
                pBuffer = null;
                //Marshal.FinalReleaseComObject(pDissolve);
                pDissolve = null;
                //Marshal.FinalReleaseComObject(pUnion);
                pUnion = null;
                GC.Collect();
                GC.WaitForPendingFinalizers();
                
            }
            return;

        }
    
        private IFeatureLayer GenerateLayerWholeExtent(string strWorkspacePath, string CreatedFlayerName)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;

            ILayer pLayer = null;
            ISpatialReference pSpatialReference = null;
            IFeatureLayer pInlayer = null;
            try
            {
                pLayer = pMap.Layer[0];
                for (int i = 0; i < pMap.LayerCount; i++)
                {
                    pLayer = pMap.Layer[i];
                    if (pLayer.Valid == true)
                        break;
                }

                pSpatialReference = SitingToolUtilities.GetSpatialReferenceForLayer(pLayer);

                string strWorkspace = null;
                ///if workspace path has no \ at end, add it
                if (strWorkspacePath.Substring(strWorkspacePath.Length - 2, 2) != "\\")
                {
                    strWorkspace = strWorkspacePath + "\\";
                }

                IEnvelope pEnv = null;
                IFeature pExtentFeature = null;
                IFeatureCursor pFeatCursor = null;

                IPolygon pPolygon = null;
                IPoint pPointLL = null;
                IPoint pPointTL = null;
                IPoint pPointTR = null;
                IPoint pPointLR = null;
                IPointCollection pPointCollection = null;

                ///geoprocessing
                Geoprocessor GP = new Geoprocessor();

                ///create max as full extent
                pEnv = pMxD.ActiveView.FullExtent;

                ///Process:  Create a feature class to update
                CreateFeatureclass pCreateFeatureclass = new CreateFeatureclass();
                pCreateFeatureclass.out_path = strWorkspace;
                pCreateFeatureclass.out_name = CreatedFlayerName + Resource.ShapeFileExt;
                pCreateFeatureclass.geometry_type = "POLYGON";
                pCreateFeatureclass.spatial_reference = pSpatialReference;
                GP.Execute(pCreateFeatureclass, null);

                ///create a polygon which covers the full extent
                pPointLL = new ESRI.ArcGIS.Geometry.Point();
                pPointLL.X = pEnv.XMin;
                pPointLL.Y = pEnv.YMin;

                pPointTL = new ESRI.ArcGIS.Geometry.Point();
                pPointTL.X = pEnv.XMin;
                pPointTL.Y = pEnv.YMax;

                pPointTR = new ESRI.ArcGIS.Geometry.Point();
                pPointTR.X = pEnv.XMax;
                pPointTR.Y = pEnv.YMax;

                pPointLR = new ESRI.ArcGIS.Geometry.Point();
                pPointLR.X = pEnv.XMax;
                pPointLR.Y = pEnv.YMin;

                pPolygon = (IPolygon)new ESRI.ArcGIS.Geometry.Polygon();
                pPointCollection = (IPointCollection)pPolygon;
                pPointCollection.AddPoint(pPointLL);
                pPointCollection.AddPoint(pPointTL);
                pPointCollection.AddPoint(pPointTR);
                pPointCollection.AddPoint(pPointLR);
                pPolygon.Close();

                ///create the feature in buf_max, assign the polygon
                pInlayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(CreatedFlayerName, pMap);
                pFeatCursor = pInlayer.FeatureClass.Update(null, false);
                pExtentFeature = pInlayer.FeatureClass.CreateFeature();
                pExtentFeature.Shape = pPolygon;
                pExtentFeature.Store();
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at GenerateLayerWholeExtent: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at GenerateLayerWholeExtent: " + e.Message);
            }
            return pInlayer;
        }

        private void RemoveOverlap(string fileName)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;

            IFeatureLayer swslayer = null;
            try
            {
                string toRemoveFile = null;
                swslayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(fileName, pMap);
                if (swslayer == null)
                {
                    MessageBox.Show(this, "Shapefile " + fileName  + " is not generated", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Shapefile " + fileName + " is not generated");
                    return;
                }
                toRemoveFile = "FID_" + swslayer.Name;
                if (toRemoveFile.Length > 10)
                {
                    toRemoveFile = toRemoveFile.Substring(0, 10);
                }
            
                IQueryFilter pQueryFilter = new QueryFilter();
                ESRI.ArcGIS.Geodatabase.ITable pTable = null;
                if ((swslayer != null))
                {
                    pTable = (ITable)swslayer.FeatureClass;
                    pQueryFilter.WhereClause = " " + toRemoveFile + " <> -1 ";
                    pTable.DeleteSearchedRows(pQueryFilter);
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at RemoveOverlap: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at RemoveOverlap: " + e.Message);
            }
            finally
            {
            }
            return;

        }
        private IFeatureLayer GenerateRoadLayer(BMPobj oBMP)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
            IFeatureLayer pRoadLayer = null;

            try
            {
                if (!Copy_FeatureData_toWorkfolder(Settings.Roaddata))
                {
                    MessageBox.Show(this, "The Road layer could not be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return null;
                }

                PrepareBufferFeature((oBMP.DC_RB), Settings.WorkingfolderParent, Settings.Roaddata);

                pRoadLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Roaddata + Resource.Buf + Convert.ToString(SitingToolGlobal.createdSoilCount) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at GenerateRoadLayer: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at GenerateRoadLayer: " + e.Message);
            }
            return pRoadLayer;

        }
        private IFeatureLayer GenerateStreamLayer(BMPobj oBMP)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
            IFeatureLayer pStreamLayer = null;
            try
            {
                if (!Copy_FeatureData_toWorkfolder(Settings.Streamdata))
                {
                    MessageBox.Show(this, "The Stream layer could not be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return null;
                }

                PrepareBufferFeature((oBMP.DC_SB), Settings.WorkingfolderParent, Settings.Streamdata);

                pStreamLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Streamdata + Resource.Buf + Convert.ToString(SitingToolGlobal.createdSoilCount) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at GenerateStreamLayer: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at GenerateStreamLayer: " + e.Message);
            }
            return pStreamLayer;

        }
        private IFeatureLayer GenerateWTLayer(BMPobj oBMP)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
            IFeatureLayer pWTLayer = null;
            IFeatureLayer pWTLayer2 = null;
            try
            {
                if (!Copy_FeatureData_toWorkfolder(Settings.WTdata))
                {
                    MessageBox.Show(this, "The Groundwater depth layer could not be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return null;
                }

                pWTLayer = (IFeatureLayer)SitingToolUtilities.GetFeatureLayer(Settings.WorkingfolderParent, Settings.WTdata);

                /// Select the Features from the water table Data.....
                IQueryFilter pQueryFilter;
                pQueryFilter = new QueryFilter();
                pQueryFilter.WhereClause = "GWdep_ft " + oBMP.DC_WT;

                ///Select all features of the feature class
                IFeatureSelection pFeatureSelection = (IFeatureSelection)pWTLayer;
                pFeatureSelection.SelectFeatures(pQueryFilter, esriSelectionResultEnum.esriSelectionResultAdd, false);
                ISelectionSet pSelectionSet = pFeatureSelection.SelectionSet;
                if (pSelectionSet.Count > 0)
                {
                    /// Export the Selected features to a new Shapefile.....
                    IFeatureClass pExportFclass = Get_ExportedShapefile(pWTLayer, strResult + "WT_Filter", true);
                    pMap.ClearSelection();

                    /// Add the new Layer to map.........
                    pWTLayer2 = new FeatureLayer();
                    pWTLayer2.FeatureClass = pExportFclass;
                    pWTLayer2.Visible = true;
                    pWTLayer2.Name = pExportFclass.AliasName;
                    pMap.AddLayer(pWTLayer2);
                }
                else
                {
                    Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "No features satisfy watertable depth criteria for " + oBMP.BMPName + ".");
                    //MessageBox.Show(this, "No features satisfy watertable depth criteria for " + oBMP.BMPName + ".", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    pWTLayer2 = null;
 
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at GenerateWTLayer: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at GenerateWTLayer: " + e.Message);
            }
            finally
            {

                if (pWTLayer != null)
                {
                    Marshal.FinalReleaseComObject(pWTLayer);
                }
            }
            return pWTLayer2;

        }
        private IFeatureLayer GenerateLanduseLayer(BMPobj oBMP)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
            IFeatureLayer pLanduseLayer = null;
            IFeatureLayer pLanduseLayer2 = null;
            try
            {
                if (!Copy_FeatureData_toWorkfolder(Settings.Landusedata))
                {
                    return null;
                }

                pLanduseLayer = (IFeatureLayer)SitingToolUtilities.GetFeatureLayer(Settings.WorkingfolderParent, Settings.Landusedata);
                if (pLanduseLayer == null)
                {
                    MessageBox.Show(this, "The Land use layer could not be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return null;
                }
                /// Select the Features from the water table Data.....
                IQueryFilter pQueryFilter = new QueryFilter();
                if (oBMP.BMPName == "Porous Pavement")
                {
                    pQueryFilter.WhereClause = "LU_DESC Like '%Roadway%' or LU_DESC Like '%Parking%' or LU_DESC Like '%Roadways%'";
                }
                else
                {
                    pQueryFilter.WhereClause = "LU_DESC = 'Buildings' or LU_DESC = 'Building'";
                }
                ///Select all features of the feature class
                IFeatureSelection pFeatureSelection = (IFeatureSelection)pLanduseLayer;
                IFeatureClass pExportFclass = null;
                pFeatureSelection.SelectFeatures(pQueryFilter, esriSelectionResultEnum.esriSelectionResultAdd, false);
                ISelectionSet pSelectionSet = pFeatureSelection.SelectionSet;
                if (pSelectionSet.Count > 0)
                {
                    /// Export the Selected features to a new Shapefile.....
                    if (oBMP.DC_BB_State != "1" & (pLanduseLayer != null))
                    {
                        pExportFclass = Get_ExportedShapefile(pLanduseLayer, strResult + Resource.BB_Filter, true);
                    }
                    else
                    {
                        pExportFclass = Get_ExportedShapefile(pLanduseLayer, strResult + Resource.BB_Filter, false);
                    }
                    pMap.ClearSelection();

                    /// Add the new Layer to map.........
                    pLanduseLayer2 = new FeatureLayer();
                    pLanduseLayer2.FeatureClass = pExportFclass;
                    pLanduseLayer2.Visible = true;
                    pLanduseLayer2.Name = pExportFclass.AliasName;
                    pMap.AddLayer(pLanduseLayer2);
                }
                else
                {
                    pLanduseLayer = null;
                    pLanduseLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strResult + "BB_Area", pMap);
                    if ((pLanduseLayer != null))
                        pMap.DeleteLayer(pLanduseLayer);
                    Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "No features satisfy land use vector data criteria for " + oBMP.BMPName + ".");
                    //MessageBox.Show(this, "No features satisfy land use vector data criteria for " + oBMP.BMPName + ".", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return null;
                }

                ///buffer
                
                if ((oBMP.BMPName.ToUpper() == "GREEN ROOF") | (oBMP.BMPName.ToUpper() == "POROUS PAVEMENT"))
                {
                    return pLanduseLayer2; // do not buffer for "Green roof" or "POROUS PAVEMENT"
                }

                IFeatureLayer ptmpLayer = pLanduseLayer2;
                IDataset pTmpDataset = (IDataset)ptmpLayer;
                PrepareBufferFeature(oBMP.DC_BB, pTmpDataset.Workspace.PathName, pTmpDataset.BrowseName);

                pLanduseLayer2 = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(pLanduseLayer2.Name + Resource.Buf + Convert.ToString(SitingToolGlobal.createdSoilCount) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at GenerateLanduseLayer: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at GenerateLanduseLayer: " + e.Message);
            }
            finally
            {
                if (pLanduseLayer != null)
                {
                    Marshal.FinalReleaseComObject(pLanduseLayer);
                }
            }
            return pLanduseLayer2;

        }
        private IFeatureLayer GenerateLandownerLayer(BMPobj oBMP)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
            IFeatureLayer pLandownerLayer = null;
            IFeatureLayer pLandownerLayer2 = null;
            try
            {
                if (!Copy_FeatureData_toWorkfolder(Settings.Landownerdata))
                {
                    return null;
                }

                pLandownerLayer = (IFeatureLayer)SitingToolUtilities.GetFeatureLayer(Settings.WorkingfolderParent, Settings.Landownerdata);
                if (pLandownerLayer == null)
                {
                    MessageBox.Show(this, "The Landowner layer could not be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return null;
                }
                IQueryFilter pQueryFilter = new QueryFilter();
                string strLandowner = cmbDC_LO.Items[Convert.ToInt16(oBMP.DC_LO)].ToString();
                pQueryFilter.WhereClause = "Ownership = '" + strLandowner + "'";
                ///Select all features of the feature class
                IFeatureSelection pFeatureSelection = (IFeatureSelection)pLandownerLayer;
                pFeatureSelection.SelectFeatures(pQueryFilter, esriSelectionResultEnum.esriSelectionResultNew, false);
                ISelectionSet pSelectionSet = pFeatureSelection.SelectionSet;
                IFeatureClass pExportFclass = null;
                if (pSelectionSet.Count > 0)
                {
                    // Export the Selected features to a new Shapefile.....
                    pExportFclass = Get_ExportedShapefile(pLandownerLayer, strResult + Resource.LO_Filter, false);
                    pMap.ClearSelection();
                    // Clear the Selection.....
                    // Add the new Layer to map.........
                    pLandownerLayer2 = new FeatureLayer();
                    pLandownerLayer2.FeatureClass = pExportFclass;
                    pLandownerLayer2.Visible = true;
                    pLandownerLayer2.Name = pExportFclass.AliasName;
                    pMap.AddLayer(pLandownerLayer2);
                }
                else
                {
                    Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "No features satisfy land ownership criteria for " + oBMP.BMPName + ".");
                    //MessageBox.Show(this, "No features satisfy land ownership criteria for " + oBMP.BMPName + ".", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    pLandownerLayer2 = null;
                
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at GenerateLandownerLayer: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at GenerateLandownerLayer: " + e.Message);
            }
            finally
            {

                if (pLandownerLayer != null)
                {
                    Marshal.FinalReleaseComObject(pLandownerLayer);
                }
            }
            return pLandownerLayer2;

        }
        private ArrayList Get_Soil_Groups(string strSoilRange, string strDelim)
        {
            ArrayList returnValue = null;

            try
            {
                ArrayList Group_Range = new ArrayList();
                Group_Range.Add("A");
                Group_Range.Add("B");
                Group_Range.Add("C");
                Group_Range.Add("D");
                Group_Range.Add("E");
                Group_Range.Add("F");
                Group_Range.Add("G");
                Group_Range.Add("H");
                Group_Range.Add("I");
                Group_Range.Add("J");
                Group_Range.Add("K");
                Group_Range.Add("L");
                Group_Range.Add("M");
                Group_Range.Add("N");
                Group_Range.Add("O");
                Group_Range.Add("P");
                Group_Range.Add("Q");
                Group_Range.Add("R");
                Group_Range.Add("S");
                Group_Range.Add("T");
                Group_Range.Add("U");
                Group_Range.Add("V");
                Group_Range.Add("W");
                Group_Range.Add("X");
                Group_Range.Add("Y");
                Group_Range.Add("Z");

                bool AddFlag = false;
                int iCnt = 0;
                string strSoilRange1 = "";
                string strSoilRange2 = "";
                string[] pVals = null;
                returnValue = new ArrayList();
                pVals = strSoilRange.Split('-');
                strSoilRange1 = pVals[0];
                strSoilRange2 = pVals[1];
                string strCompare = "";
                for (iCnt = 0; iCnt <= Group_Range.Count - 1; iCnt++)
                {
                    strCompare = Group_Range[iCnt].ToString();
                    if (strCompare == strSoilRange1)
                        AddFlag = true;
                    if (AddFlag)
                        returnValue.Add(Group_Range[iCnt]);
                    if ((strCompare == strSoilRange2) | string.IsNullOrEmpty(strSoilRange2))
                        AddFlag = false;
                }

                ///////////////////////////////////////////////////
                // Now Handle the "/" in the attribute Table.........
                ///////////////////////////////////////////////////
                ArrayList tmpCol = null;
                tmpCol = new ArrayList();
                for (iCnt = 0; iCnt <= returnValue.Count - 1; iCnt++)
                {
                    tmpCol.Add(returnValue[iCnt]);
                }

                while (tmpCol.Count > 1)
                {
                    for (iCnt = 0; iCnt <= tmpCol.Count - 1; iCnt++)
                    {
                        returnValue.Add(tmpCol[0] + "/" + tmpCol[iCnt]);
                    }
                    tmpCol.RemoveAt(0);
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at Get_Soil_Groups: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at Get_Soil_Groups: " + e.Message);
            }
            finally
            {
            }
            return returnValue;
        }
        private void addWeightCriteriaColumnDC_HG(IFeatureLayer pFeatureLayer, string origColumnName, string newColumnName, BMPobj oBMP)
        {


            IFeatureClass pFeatClass = null;
            try
            {
                pFeatClass = pFeatureLayer.FeatureClass;

                /// Now add the Field.....
                IField pField = null;
                pField = new Field();
                IFieldEdit pFieldEdit = (IFieldEdit)pField;
                pFieldEdit.Name_2 = newColumnName;
                pFieldEdit.AliasName_2 = newColumnName;
                pFieldEdit.Type_2 = esriFieldType.esriFieldTypeInteger;
                pFeatClass.AddField(pField);
            
                string pBMPCriteria = null;
                string[] criteriaItems = null;
                string[] criteriaItem = null;
                int itemLen = 0;


                pBMPCriteria = oBMP.DC_HG_Weight;

                criteriaItems = pBMPCriteria.Split(';');
                itemLen = criteriaItems.Count();
                short iIndex = 0;

                IFeatureCursor pFeatureCursor = null;
                pFeatureCursor = pFeatClass.Search(null, true);
                IFeature pFeature = null;
                pFeature = pFeatureCursor.NextFeature();
                int Output = 0;
                while ((pFeature != null))
                {

                    Output = 0;
                    if (oBMP.DC_HG_Weight_State == "1")
                    {
                        for (iIndex = 0; iIndex <= itemLen - 1; iIndex++)
                        {
                            criteriaItem = criteriaItems[iIndex].Split(':');
                            if (criteriaItem[0].Contains(pFeature.Value[pFeature.Fields.FindField("HYDGRP")]))
                            {
                                Output = Output + Convert.ToInt16(criteriaItem[1]);
                            }
                        }
                    }
                    pFeature.Value[pFeature.Fields.FindField(newColumnName)] = Output;
                    pFeature.Store();
                    pFeature = pFeatureCursor.NextFeature();
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at addWeightCriteriaColumnDC_HG: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at addWeightCriteriaColumnDC_HG: " + e.Message);
            }
            finally
            {
            }
            return;

        }
        private IFeatureLayer GenerateHSGLayer(BMPobj oBMP)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
            string strNewSoilName = null;
            IFeatureLayer pTempResultLayer = null;
            IFeatureLayer pTempResultLayer2 = null;
            try
            {
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Soildata + "_Join");
                
                Copy_SoilFeatureData_toWorkfolder(Settings.Soildata, Settings.SoilTable, "MUKEY", "MUKEY", ref strNewSoilName);

                //Settings.Soildata = strNewSoilName;
                //pTempResultLayer = (IFeatureLayer)SitingToolUtilities.GetFeatureLayer(Settings.WorkingfolderParent, Settings.Soildata);
                pTempResultLayer = (IFeatureLayer)SitingToolUtilities.GetFeatureLayer(Settings.WorkingfolderParent, strNewSoilName);
                if (pTempResultLayer == null)
                {
                    MessageBox.Show(this, "The Soil layer could not be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return null;
                }
                string strWhereClause = "HYDGRP In (";
                string strSoilCriteria = oBMP.DC_HG;
                if (strSoilCriteria.Length == 1)
                {
                    strSoilCriteria = strSoilCriteria + "-" + strSoilCriteria;
                }

                ArrayList pValues = Get_Soil_Groups(strSoilCriteria, "-");
                for (int iCnt = 0; iCnt <= pValues.Count - 1; iCnt++)
                {
                    strWhereClause = strWhereClause + "'" + pValues[iCnt] + "',";
                }

                strWhereClause = SitingToolUtilities.Generic_Trim(strWhereClause, ',') + ")";

                /// Select the Features from the soil data.....
                IQueryFilter pQueryFilter = new QueryFilter();
                pQueryFilter.WhereClause = strWhereClause;
                ///Select all features of the feature class
                IFeatureSelection pFeatureSelection = (IFeatureSelection)pTempResultLayer;
                pFeatureSelection.SelectFeatures(pQueryFilter, esriSelectionResultEnum.esriSelectionResultNew, false);
                ISelectionSet pSelectionSet = pFeatureSelection.SelectionSet;
                if (pSelectionSet.Count == 0)
                {
                    Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "No features satisfy HSG criteria for " + oBMP.BMPName + ".");
                    //MessageBox.Show(this, "No features satisfy HSG criteria for " + oBMP.BMPName + ".", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    pTempResultLayer = null;
                    return null;
                }

                /// Export the Selected features to a new Shapefile, replace the name Soil_Filter with Result_Filter
                IFeatureClass pExportFclass = null;
                pExportFclass = Get_ExportedShapefile(pTempResultLayer, strResult + "Result_Filter", false);
           
                pMap.ClearSelection();

                pTempResultLayer2 = (IFeatureLayer)SitingToolUtilities.GetFeatureLayer(Settings.WorkingfolderParent, pExportFclass.AliasName);

                ///add a column recording weight number according to weight criteria
                addWeightCriteriaColumnDC_HG(pTempResultLayer2, "HYDGRP", "HYDGRP_W", oBMP);

                if ((pTempResultLayer2 != null))
                {
                    pMap.AddLayer(pTempResultLayer2);
                    pTempResultLayer2.Visible = true;
                    return pTempResultLayer2;
                }
                else
                {
                    return null;
                }
                
                ///// Filter the HSG Layer.....,
                //if (!string.IsNullOrEmpty(oBMP.DC_HG_Weight) & oBMP.DC_HG_Weight_State == "1")
                //{
                //    pQueryFilter.WhereClause = "HYDGRP_W>0";
                //    pFeatureSelection = (IFeatureSelection)pTempResultLayer;
                //    pFeatureSelection.SelectFeatures(pQueryFilter, esriSelectionResultEnum.esriSelectionResultNew, false);
                //    pSelectionSet = pFeatureSelection.SelectionSet;
                //    if (pSelectionSet.Count == 0)
                //    {
                //        MessageBox.Show(this, "No features satisfy HSG criteria for " + oBMP.BMPName + ".", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                //        return null;
                //    }

                //    /// Export the Selected features to a new Shapefile.....
                //    pExportFclass = Get_ExportedShapefile(pTempResultLayer, "HSG_Filter", false);
                //    pMap.ClearSelection();

                //    /// Add the new Layer to map.........
                //    IFeatureLayer pTempResultLayer2 = new FeatureLayer();
                //    pTempResultLayer2.FeatureClass = pExportFclass;
                //    pTempResultLayer2.Visible = true;
                //    pTempResultLayer2.Name = pExportFclass.AliasName;
                //    pMap.AddLayer(pTempResultLayer2);
                //    pMap.DeleteLayer(pTempResultLayer);

                //    return pTempResultLayer2;
                //}
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at GenerateHSGLayer: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at GenerateHSGLayer: " + e.Message);
            }
            finally
            {

                if (pTempResultLayer != null)
                {
                    Marshal.FinalReleaseComObject(pTempResultLayer);
                }
            }
            return pTempResultLayer2;

        }
        private IFeatureLayer GenerateRasterLanduseLayer(BMPobj oBMP)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
            IFeatureLayer pInmrlcLayer = null;
            IFeatureLayer pInmrlcLayer2 = null;
            try
            {

                pInmrlcLayer = (IFeatureLayer)SitingToolUtilities.GetFeatureLayer(Settings.WorkingfolderParent, Settings.RasterLanduseData);

                if ((pInmrlcLayer != null))
                {
                    /// Build the Query String from joined Table......
                    IQueryFilter pQueryFilter = new QueryFilter();
                    ITable pTable = (ITable)pInmrlcLayer;

                    pQueryFilter.WhereClause = "SUITABLE = 1";
                    ICursor pCursor = pTable.Search(pQueryFilter, false);
                    IRow pRow = pCursor.NextRow();
                    string strQry = "";
                    while ((pRow != null))
                    {
                        strQry = strQry + "," + pRow.Value[pRow.Fields.FindField("LUCODE")];
                        pRow = pCursor.NextRow();
                    }

                    if (string.IsNullOrEmpty(strQry))
                    {
                        Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "No features satisfy land use raster data criteria for " + oBMP.BMPName + ".");
                        //MessageBox.Show(this, "No features satisfy land use raster data criteria for " + oBMP.BMPName + ".", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                        return null;
                    }

                    strQry = strQry.Substring(1);
                    // Filter the Slope Layer.....
                    pQueryFilter.WhereClause = "GRIDCODE In (" + strQry + ")";
                    IFeatureSelection pFeatureSelection = (IFeatureSelection)pInmrlcLayer;
                    pFeatureSelection.SelectFeatures(pQueryFilter, ESRI.ArcGIS.Carto.esriSelectionResultEnum.esriSelectionResultAdd, false);
                    ISelectionSet pSelectionSet = pFeatureSelection.SelectionSet;
                    if (pSelectionSet.Count == 0)
                    {
                        Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "No features satisfy land use raster data criteria for " + oBMP.BMPName + ".");
                        //MessageBox.Show(this, "No features satisfy land use raster data criteria for " + oBMP.BMPName + ".", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                        return null;
                    }

                    /// Export the Selected features to a new Shapefile.....

                    IFeatureClass pExportFclass = Get_ExportedShapefile(pInmrlcLayer, strResult + "Landuse_Filter", true);
                    // Clear the Selection.....
                    pMap.ClearSelection();

                    // Add the new Layer to map.........
                    pInmrlcLayer2 = new FeatureLayer();
                    pInmrlcLayer2.FeatureClass = pExportFclass;
                    pInmrlcLayer2.Visible = true;
                    pInmrlcLayer2.Name = pExportFclass.AliasName;
                    pMap.AddLayer(pInmrlcLayer2);
                }
                else
                {
                    MessageBox.Show(this, "The Raster Land use layer could not be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return null;
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at GenerateRasterLanduseLayer: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at GenerateRasterLanduseLayer: " + e.Message);
            }
            finally
            {
                if (pInmrlcLayer != null)
                {
                    Marshal.FinalReleaseComObject(pInmrlcLayer);
                }
            }
            return pInmrlcLayer2;

        }
        private IFeatureLayer GenerateImperviousLayer(BMPobj oBMP)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
            IFeatureLayer pInImpLayer = null;
            IFeatureLayer pInImpLayer2 = null;
            try
            {
                if (!SitingToolUtilities.Copy_RasterData_toCachefolder(Settings.Imperviousdata, Settings, pMap))
                {
                    MessageBox.Show(this, "The Impervious layer could not be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return null;
                }

                /// Check if the Impervious GRID is already cerated.....
                /// If Created then Use it......
                pInImpLayer = (IFeatureLayer)SitingToolUtilities.GetFeatureLayer(Settings.WorkingfolderParent, Settings.Imperviousdata + "_Ras");
                if (pInImpLayer == null)
                {
                    pInImpLayer = new FeatureLayer();
                    IFeatureClass pInShp_IMP = RasterUtilities.ConvertRastertoFeature(Settings.Rasterfolder, Settings.Imperviousdata, false, false, oBMP.BMPName, Settings, _bMPCriteria, pMap);
                    pInImpLayer.FeatureClass = pInShp_IMP;
                }

                /// Select the Features 
                IQueryFilter pQueryFilter = new QueryFilter();
                pQueryFilter.WhereClause = "GRIDCODE " + oBMP.DC_IMP;

                IFeatureSelection pFeatureSelection = (IFeatureSelection)pInImpLayer;
                pFeatureSelection.SelectFeatures(pQueryFilter, esriSelectionResultEnum.esriSelectionResultAdd, false);
                ISelectionSet pSelectionSet = pFeatureSelection.SelectionSet;
                if (pSelectionSet.Count == 0)
                {
                    Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "No features satisfy impervious criteria for " + oBMP.BMPName + ".");
                    //MessageBox.Show(this, "No features satisfy impervious criteria for " + oBMP.BMPName + ".", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return null;
                }


                /// Export the Selected features to a new Shapefile.....
                IFeatureClass pExportFclass = Get_ExportedShapefile(pInImpLayer, strResult + "IMP_Filter", true);
                
                pMap.ClearSelection();

                /// Add the new Layer to map.........
                pInImpLayer2 = new FeatureLayer();
                pInImpLayer2.FeatureClass = pExportFclass;
                pInImpLayer2.Visible = true;
                pInImpLayer2.Name = pExportFclass.AliasName;
                pMap.AddLayer(pInImpLayer2);
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at GenerateImperviousLayer: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at GenerateImperviousLayer: " + e.Message);
            }
            finally
            {
                if (pInImpLayer != null)
                {
                    Marshal.FinalReleaseComObject(pInImpLayer);
                }
            }
            return pInImpLayer2;

        }

        private IFeatureLayer GenerateDEMSlopeLayer(BMPobj oBMP)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;


            IRaster pRaster = null;
            IFeatureClass pInShp_Slope = null;
            IFeatureLayer pTempResultLayer2 = null;
            IRasterLayer pInRasterLay = null;
            IFeatureLayer pInSlopeLayer = null;

            try
            {
                /// CHeck if the SLOPE GRID is already cerated.....
                /// If Created then Use it......
                pRaster = RasterUtilities.OpenRasterDatasetFromDisk(Resource.SLOPE, Settings);
                pInRasterLay = (IRasterLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.DEMdata, pMap);
                if (pInRasterLay == null)
                {
                    MessageBox.Show(this, "The Elevation grid layer could not be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return null;
                }


                if (pRaster == null)
                {
                    pInSlopeLayer = new FeatureLayer();

                    /// Calculate the Slope....
                
                    double dScalefac = Get_Scale_Factor(pMap.MapUnits);
                    RasterUtilities.Calculate_Slope(pInRasterLay, dScalefac, Settings, pMap);
                    ///convert raster to feature, and add weight column according to weight criteria
                    pInShp_Slope = RasterUtilities.ConvertRastertoFeature(Settings.Rasterfolder, Resource.SLOPE, true, false, oBMP.BMPName, Settings, _bMPCriteria, pMap);
                    pInSlopeLayer.FeatureClass = pInShp_Slope;
                }
                else
                {
                    pInSlopeLayer = new FeatureLayer();
                    pInShp_Slope = RasterUtilities.ConvertRastertoFeature(Settings.Rasterfolder, Resource.SLOPE, true, false, oBMP.BMPName, Settings, _bMPCriteria, pMap);
                    //pInSlopeLayer = (IFeatureLayer)SitingToolUtilities.GetFeatureLayer(Settings.WorkingfolderParent, Resource.SLOPERas);
                    pInSlopeLayer.FeatureClass = pInShp_Slope;
                }

                ///update the weight column name from GRIDCODE to Slope_W
                updateColumnName(pInSlopeLayer, "GRIDCODE", "Slope_W");
                IQueryFilter pQueryFilter = new QueryFilter();
                //pQueryFilter.WhereClause = "Slope_W>0";
                pQueryFilter.WhereClause = "Slope_W>-1";
                ///& gDACriteria '  GRIDCODE default field created when Converted Raster to Feature....
                IFeatureSelection pFeatureSelection = (IFeatureSelection)pInSlopeLayer;
                pFeatureSelection.SelectFeatures(pQueryFilter, esriSelectionResultEnum.esriSelectionResultNew, false);
                ISelectionSet pSelectionSet = pFeatureSelection.SelectionSet;
                if (pSelectionSet.Count == 0)
                {
                    Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "No features satisfy slope criteria for " + oBMP.BMPName + ".");
                    //MessageBox.Show(this, "No features satisfy slope criteria for " + oBMP.BMPName + ".", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return null;
                }

                /// Export the Selected features to a new Shapefile.....
                //IFeatureClass pExportFclass = Get_ExportedShapefile(pInSlopeLayer, "Slope_Filter_" + Convert.ToString(SitingToolGlobal.appCount) + "_" + Convert.ToString(SitingToolGlobal.slopeFilterCount), false);
                // Get_ExportedShapefile will sometimes generate the "Error exporting data" messages, so use following geoprocessing tool instead.
                IFeatureClass pExportFclass = Get_CopySelectedShapefile(pInShp_Slope.AliasName, "Slope_Filter_" + Convert.ToString(SitingToolGlobal.appCount) + "_" + Convert.ToString(SitingToolGlobal.slopeFilterCount), "Slope_W=-1", false);
                if (pExportFclass == null)
                {
                    MessageBox.Show(this, "DEM Slope Layer not generated for " + oBMP.BMPName + ". ", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "DEM Slope Layer not generated for " + oBMP.BMPName + ". ");
                    return null;
                }
                pMap.ClearSelection();

                // Add the new Layer to map.........
                pTempResultLayer2 = new FeatureLayer();
                pTempResultLayer2.FeatureClass = pExportFclass;
                pTempResultLayer2.Visible = true;
                pTempResultLayer2.Name = pExportFclass.AliasName;
                pMap.AddLayer(pTempResultLayer2);
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at GenerateDEMSlopeLayer: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at GenerateDEMSlopeLayer: " + e.Message);
            }
            finally
            {
                if (pInRasterLay != null)
                {
                    Marshal.FinalReleaseComObject(pInRasterLay);
                }
                if (pInSlopeLayer != null)
                {
                    Marshal.FinalReleaseComObject(pInSlopeLayer);
                }
            }

            return pTempResultLayer2;
        }

        private IFeatureLayer GenerateDEMDrainageLayer(BMPobj oBMP)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;

            IFeatureLayer pTempResultLayer2 = null;
            IRasterLayer pInRasterLay = null;
            IFeatureLayer pInFlowLayer = null;

            try
            {
                /// CHeck if the FLOW GRID is already cerated.....
                /// If Created then Use it......
                IRaster pRaster = RasterUtilities.OpenRasterDatasetFromDisk(Resource.FLOW, Settings);
                pInRasterLay = (IRasterLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.DEMdata, pMap);
                if (pInRasterLay == null)
                {
                    MessageBox.Show(this, "The Elevation grid layer could not be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return null;
                }

                if (pRaster == null)
                {
                    pInFlowLayer = new FeatureLayer();
                    /// Calculate the Flow....
                    RasterUtilities.Create_FlowDirectionandAccumulation(pInRasterLay.Raster, Settings, pMap);
                    /// Pass the DEM grid......
                    pInFlowLayer.FeatureClass = RasterUtilities.ConvertRastertoFeature(Settings.Rasterfolder, Resource.FLOW, true, true, oBMP.BMPName, Settings, _bMPCriteria, pMap);
                }
                else
                {
                    RasterUtilities.ConvertRastertoFeature(Settings.Rasterfolder, Resource.FLOW, true, true, oBMP.BMPName, Settings, _bMPCriteria, pMap);
                    pInFlowLayer = (IFeatureLayer)SitingToolUtilities.GetFeatureLayer(Settings.WorkingfolderParent, Resource.FLOWRas);
                }

                IQueryFilter pQueryFilter = new QueryFilter();

                pQueryFilter.WhereClause = "GRIDCODE=1";
                ///& Parse_Expression(gDACriteria)
                IFeatureSelection pFeatureSelection = (IFeatureSelection)pInFlowLayer;
                pFeatureSelection.SelectFeatures(pQueryFilter, esriSelectionResultEnum.esriSelectionResultAdd, false);
                ISelectionSet pSelectionSet = pFeatureSelection.SelectionSet;
                if (pSelectionSet.Count == 0)
                {
                    Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "No features satisfy drainage area criteria for " + oBMP.BMPName + ".");
                    //MessageBox.Show(this, "No features satisfy drainage area criteria for " + oBMP.BMPName + ".", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return null;
                }

                /// Export the Selected features to a new Shapefile.....
                //IFeatureClass pExportFclass = Get_ExportedShapefile(pInFlowLayer, "Flow_Filter", true);
                IFeatureClass pExportFclass = Get_CopySelectedShapefile(pInFlowLayer.FeatureClass.AliasName, "Flow_Filter", "GRIDCODE<>1", true);

                pMap.ClearSelection();

                /// Add the new Layer to map.........
                pTempResultLayer2 = new FeatureLayer();
                pTempResultLayer2.FeatureClass = pExportFclass;
                pTempResultLayer2.Visible = true;
                pTempResultLayer2.Name = pExportFclass.AliasName;
                pMap.AddLayer(pTempResultLayer2);
                pMap.DeleteLayer(pInFlowLayer);

            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at GenerateDEMDrainageLayer: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at GenerateDEMDrainageLayer: " + e.Message);
            }
            finally
            {
                if (pInRasterLay != null)
                {
                    Marshal.FinalReleaseComObject(pInRasterLay);
                }

                if (pInFlowLayer != null)
                {
                    Marshal.FinalReleaseComObject(pInFlowLayer);
                }
            }
            return pTempResultLayer2;


        }
        private IFeatureLayer Get_Intersect_FeatureLayer(IFeatureLayer pInputFeatLayer, IFeatureLayer pOverlayLayer, string strResultName)
        {
            IFeatureLayer returnValue = null;
            if ((pInputFeatLayer == null) | (pOverlayLayer == null))
            {
                return null;
            }
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;

            IFeatureClass pOutputFeatClass = null;
            IFeatureLayer pOutputFeatLayer = null;

            try
            {
                /// Get a valid name.....
                strResultName = Get_Available_name(strResultName);

                ///geoprocessing
                ///not in memory
                Geoprocessor GP = new Geoprocessor();
                Intersect pIntersect = new Intersect();
                pIntersect.in_features = pInputFeatLayer.Name + ";" + pOverlayLayer.Name;
                pIntersect.out_feature_class = Settings.WorkingfolderParent + "\\" + strResultName + Resource.ShapeFileExt;
                //pIntersect.out_feature_class = Resource.InMemory + "\\" + strResultName;
                pIntersect.join_attributes = Resource.ALL;
                GP.Execute(pIntersect, null);


                //// Intialize the MakeFeatureLayer tool
                //MakeFeatureLayer makefeaturelayer = new MakeFeatureLayer();

                //// Set up the GP tool parameters and run the tool
                //makefeaturelayer.in_features = Resource.InMemory + "\\" + strResultName;
                //makefeaturelayer.out_layer = strResultName + "test";
                //IGeoProcessorResult result = (IGeoProcessorResult)GP.Execute(makefeaturelayer, null);
                //IFeatureClass fc;
                //IQueryFilter qf = null;
                //IGPUtilities gpUtils = new GPUtilities();
                //gpUtils.DecodeFeatureLayer(result.GetOutput(0), out fc, out qf);
                //pOutputFeatLayer = new FeatureLayer();
                //pOutputFeatLayer.FeatureClass = fc;

                pOutputFeatLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strResultName, pMap);
                pOutputFeatClass = pOutputFeatLayer.FeatureClass;
                //pOutputFeatLayer = (IFeatureLayer)SitingToolUtilities.OpenInMemory(strResultName);
                ///replace output layer with strResultName
                pOutputFeatLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strResultName, pMap);
                pOutputFeatClass = pOutputFeatLayer.FeatureClass;
                if (pOutputFeatClass.FeatureCount(null) == 0)
                {
                    pMap.DeleteLayer(pOutputFeatLayer);
                    pOutputFeatLayer = null;
                }

                returnValue = pOutputFeatLayer;
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at Get_Intersect_FeatureLayer: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at Get_Intersect_FeatureLayer: " + e.Message);
            }
            finally
            {

            }
            return returnValue;
        }

        private void CleanupLayers(IRasterLayer pInRasterLay, IFeatureLayer pInImpLayer, IFeatureLayer pWTLayer, IFeatureLayer pLanduseLayer, IFeatureLayer pInFlowLayer, IFeatureLayer pInmrlcLayer, IFeatureLayer pInSlopeLayer)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
            try
            {
                /// Clean any layers....

                if (pInRasterLay != null)
                {
                    pMap.DeleteLayer(pInRasterLay);
                    Marshal.FinalReleaseComObject(pInRasterLay);
                }
                if (pInImpLayer != null)
                {
                    pMap.DeleteLayer(pInImpLayer);
                    Marshal.FinalReleaseComObject(pInImpLayer);
                }
                SitingToolUtilities.Delete_Dataset_ST(Settings.Rasterfolder, Resource.RasterCon);
                IFeatureLayer pRoadLayer, pStreamLayer;
                pRoadLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Roaddata + Resource.Dis + "_" + Convert.ToString(SitingToolGlobal.appCount) + "_" + Convert.ToString(SitingToolGlobal.createdSoilCount), pMap);
                pStreamLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Streamdata + Resource.Dis + "_" + Convert.ToString(SitingToolGlobal.appCount) + "_" + Convert.ToString(SitingToolGlobal.createdSoilCount), pMap);
                if ((pWTLayer != null))
                {
                    pMap.DeleteLayer(pWTLayer);
                    Marshal.FinalReleaseComObject(pWTLayer);
                }
                if ((pRoadLayer != null))
                {
                    pMap.DeleteLayer(pRoadLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pRoadLayer.Name);
                    Marshal.FinalReleaseComObject(pRoadLayer);
                }
                if ((pStreamLayer != null))
                {
                    pMap.DeleteLayer(pStreamLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pStreamLayer.Name);
                    Marshal.FinalReleaseComObject(pStreamLayer);
                }
                if ((pLanduseLayer != null))
                {
                    pMap.DeleteLayer(pLanduseLayer);
                    Marshal.FinalReleaseComObject(pLanduseLayer);
                }
                if ((pInFlowLayer != null))
                {
                    pMap.DeleteLayer(pInFlowLayer);
                    Marshal.FinalReleaseComObject(pInFlowLayer);
                }

                if ((pInmrlcLayer != null))
                {
                    pMap.DeleteLayer(pInmrlcLayer);
                    Marshal.FinalReleaseComObject(pInmrlcLayer);
                }
                if ((pInSlopeLayer != null))
                {
                    pMap.DeleteLayer(pInSlopeLayer);
                    Marshal.FinalReleaseComObject(pInSlopeLayer);
                }
                IFeatureLayer pLayer = null;
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Roaddata + Resource.BufMax, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Roaddata + Resource.BufMin, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Roaddata + Resource.DisMax, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Roaddata + Resource.DisMin, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Roaddata + Resource.Buf, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                short ii = 0;
                for (ii = 0; ii <= SitingToolGlobal.createdSoilCount; ii++)
                {
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Roaddata + Resource.Buf + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Roaddata + Resource.Buf + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);

                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Roaddata + Resource.BufMax + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Roaddata + Resource.BufMin + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Roaddata + Resource.DisMax + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Roaddata + Resource.DisMin + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);

                }

                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Streamdata + Resource.BufMax, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Streamdata + Resource.BufMin, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Streamdata + Resource.DisMax, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Streamdata + Resource.DisMin, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Streamdata + Resource.Buf, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                for (ii = 0; ii <= SitingToolGlobal.createdSoilCount; ii++)
                {

                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Streamdata + Resource.Buf + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Streamdata + Resource.Buf + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);

                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Streamdata + Resource.BufMax + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Streamdata + Resource.BufMin + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Streamdata + Resource.DisMax + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Streamdata + Resource.DisMin + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);

                }

                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Landusedata + Resource.BufMax, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Landusedata + Resource.BufMin, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Landusedata + Resource.DisMax, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Landusedata + Resource.DisMin, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Landusedata + Resource.Buf, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                for (ii = 1; ii <= SitingToolGlobal.createdSoilCount; ii++)
                {
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Landusedata + Resource.Buf + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Landusedata + Resource.Buf + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Landusedata + Resource.BufMax + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Landusedata + Resource.BufMin + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Landusedata + Resource.DisMax + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Landusedata + Resource.DisMin + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);

                }

                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strResult + Resource.BB_Filter_DisMin, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strResult + Resource.BB_Filter_DisMax, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strResult + Resource.BB_Filter_BufMin, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strResult + Resource.BB_Filter_BufMax, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strResult + Resource.BB_Filter, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                for (ii = 0; ii <= SitingToolGlobal.createdSoilCount; ii++)
                {
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strResult + Resource.BB_Filter + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strResult + Resource.BB_Filter_Buf + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strResult + Resource.BB_Filter_BufMax + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strResult + Resource.BB_Filter_BufMin + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strResult + Resource.BB_Filter_DisMax + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strResult + Resource.BB_Filter_DisMin + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount), pMap);
                    if ((pLayer != null))
                        pMap.DeleteLayer(pLayer);

                }

                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Resource.LayerWholeExtent + "_" + Convert.ToString(SitingToolGlobal.appCount) + "_" + Convert.ToString(SitingToolGlobal.createdSoilCount), pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Resource.LayerWholeExtent + "_" + Convert.ToString(SitingToolGlobal.appCount) + "_" + Convert.ToString(SitingToolGlobal.createdSoilCount));

                pLayer = null;
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Roaddata + Resource.BufMax);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Roaddata + Resource.BufMin);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Roaddata + Resource.DisMax);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Roaddata + Resource.DisMin);
                for (ii = 0; ii <= SitingToolGlobal.createdSoilCount; ii++)
                {
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Roaddata + Resource.Buf + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Roaddata + Resource.Buf + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Roaddata + Resource.BufMax + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Roaddata + Resource.BufMin + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Roaddata + Resource.DisMax + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Roaddata + Resource.DisMin + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));

                }

                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Streamdata + Resource.BufMax);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Streamdata + Resource.BufMin);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Streamdata + Resource.DisMax);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Streamdata + Resource.DisMin);
                for (ii = 0; ii <= SitingToolGlobal.createdSoilCount; ii++)
                {
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Streamdata + Resource.Buf + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Streamdata + Resource.Buf + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Streamdata + Resource.BufMax + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Streamdata + Resource.BufMin + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Streamdata + Resource.DisMax + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Streamdata + Resource.DisMin + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));

                }

                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Landusedata + Resource.BufMax);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Landusedata + Resource.BufMin);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Landusedata + Resource.DisMax);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Landusedata + Resource.DisMin);

                for (ii = 0; ii <= SitingToolGlobal.createdSoilCount; ii++)
                {
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Landusedata + Resource.Buf + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Landusedata + Resource.Buf + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Landusedata + Resource.BufMax + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Landusedata + Resource.BufMin + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Landusedata + Resource.DisMax + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Landusedata + Resource.DisMin + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));

                }

                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, strResult + Resource.BB_Filter_DisMin);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, strResult + Resource.BB_Filter_DisMax);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, strResult + Resource.BB_Filter_BufMin);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, strResult + Resource.BB_Filter_BufMax);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, strResult + Resource.BB_Filter);
                for (ii = 0; ii <= SitingToolGlobal.createdSoilCount; ii++)
                {
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, strResult + Resource.BB_Filter + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, strResult + Resource.BB_Filter_Buf + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, strResult + Resource.BB_Filter_BufMax + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, strResult + Resource.BB_Filter_BufMin + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, strResult + Resource.BB_Filter_DisMax + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, strResult + Resource.BB_Filter_DisMin + Convert.ToString(ii) + "_" + Convert.ToString(SitingToolGlobal.appCount));

                }
                for (ii = 0; ii <= SitingToolGlobal.slopeFilterCount; ii++)
                {
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, "Slope_Filter_" + Convert.ToString(SitingToolGlobal.appCount) + "_" + Convert.ToString(ii));
                }

                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strResult + Resource.LO_Filter, pMap);
                if ((pLayer != null))
                    pMap.DeleteLayer(pLayer);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, strResult + Resource.LO_Filter);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, strResult + "_Slope_" + Convert.ToString(SitingToolGlobal.appCount));
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, strResult + "_Landuse_" + Convert.ToString(SitingToolGlobal.appCount));
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, strResult + "_LO_" + Convert.ToString(SitingToolGlobal.appCount));
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Imperviousdata + "_Ras");
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Imperviousdata + "_Ras_Join");
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.RasterLanduseData + "_Ras");
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.RasterLanduseData + "_Ras_Join");

            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at CleanupLayers: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at CleanupLayers: " + e.Message);
            }
        }
        private void FinalCleanupLayers()
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
            try
            {

                SitingToolUtilities.Delete_Table(Settings.WorkingfolderParent, Settings.SoilTable);
                SitingToolUtilities.Delete_Table(Settings.WorkingfolderParent, Settings.RasterLanduseTable);

                /// Clean any layers....
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, "SLOPE_Ras");
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Soildata + "_Join");


                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Roaddata);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Streamdata);

                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.WTdata);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Landusedata);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Landownerdata);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Soildata);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.RasterLanduseData);
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Imperviousdata);

                int ii = 0;
                for (ii = 0; ii <= _selectedBMPType.SelectedBMP.Count; ii++)
                {
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.WTdata + "_" + Convert.ToString(ii));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Landusedata + "_" + Convert.ToString(ii));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Landownerdata + "_" + Convert.ToString(ii));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Soildata + "_" + Convert.ToString(ii));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.RasterLanduseData + "_" + Convert.ToString(ii));
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Settings.Imperviousdata + "_" + Convert.ToString(ii));
                }

            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at FinalCleanupLayers: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at FinalCleanupLayers: " + e.Message);
            }
        }
        private IFeatureLayer Clean_Layer(IFeatureLayer pLayer)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;

            IFeatureLayer returnValue = null;
            IFeatureClass pFeatClass = null;
            try
            {
                pFeatClass = pLayer.FeatureClass;

                ///Delete the layer
                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pLayer.Name);

                /// Copy the result Featureclass and Clean the featureClass.......
                IDataset pDataset = null;
                pDataset = (IDataset)pFeatClass;
                IWorkspace pWkspace = null;

                if (pDataset.CanCopy())
                {
                    pWkspace = SitingToolUtilities.GetWorkspace(Settings.WorkingfolderParent);
                    //pDataset.Copy(strResult, pWkspace);
                    pDataset.Copy(strResult + Convert.ToString(SitingToolGlobal.appCount), pWkspace);
                    pWkspace = null;
                }

                //in memory
                //pFeatClass = SitingToolUtilities.OpenShapeFile(Settings.WorkingfolderParent, strResult + Convert.ToString(SitingToolGlobal.appCount));
                pFeatClass = SitingToolUtilities.OpenShapeFile(Settings.WorkingfolderParent, strResult + Convert.ToString(SitingToolGlobal.appCount));

                /// Now add the Field.....
                IField pField = null;
                IFieldEdit pFieldEdit = null;
                pField = new Field();
                pFieldEdit = (IFieldEdit)pField;
                pFieldEdit.Name_2 = Resource.BMP;
                pFieldEdit.AliasName_2 = Resource.BMP;
                pFieldEdit.Type_2 = esriFieldType.esriFieldTypeString;
                pFieldEdit.Length_2 = 50;
                pFeatClass.AddField(pField);


                IFeatureCursor pFeatureCursor = null;
                pFeatureCursor = pFeatClass.Search(null, true);
                IFeature pFeature = null;
                pFeature = pFeatureCursor.NextFeature();
                while ((pFeature != null))
                {

                    pFeature.Value[pFeature.Fields.FindField(Resource.BMP)] = strResult;
                    pFeature.Store();
                    pFeature = pFeatureCursor.NextFeature();
                }

                /// Delete all fields from the featureClass......
                IFields pFields = null;
                int l = 0;
                pFields = pFeatClass.Fields;
                for (l = pFields.FieldCount - 1; l >= 0; l += -1)
                {
                    ///keep the sumWeight column as well
                    if (pFields.Field[l].Type != esriFieldType.esriFieldTypeOID & pFields.Field[l].Type != esriFieldType.esriFieldTypeGeometry & pFields.Field[l].Name != Resource.BMP & pFields.Field[l].Name != Resource.SumWeight)
                    {
                        pFeatClass.DeleteField(pFields.Field[l]);
                    }
                }

                /// Remove the old Layer.....
                pMap.DeleteLayer(pLayer);
                pLayer = new FeatureLayer();
                pLayer.FeatureClass = pFeatClass;
                //pLayer.Name = strResult;
                pLayer.Name = strResult + Convert.ToString(SitingToolGlobal.appCount);
                pLayer.Visible = true;
                ///Add the New Layer....
                pMap.AddLayer(pLayer);
                ChangeStyle(pLayer);

                returnValue = pLayer;
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at Clean_Layer: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at Clean_Layer: " + e.Message);
            }
            finally
            {
            }
            return returnValue;


        }
        private void DisplayResults(IFeatureLayer pTempResultLayer, string strBMPType)
        {

            try
            {
                ///////////////////////////////////////////////////
                /// Clean the Final layer..............................
                /// Drop all fields and Add a result Field......
                ///////////////////////////////////////////////////
                //pTempResultLayer.Name = strResult;
                pTempResultLayer.Name = strResult + Convert.ToString(SitingToolGlobal.appCount);
                pTempResultLayer = Clean_Layer(pTempResultLayer);
                ChangeStyle(pTempResultLayer);

                IMxDocument pMxD = (IMxDocument)m_application.Document;
                IMap pMap = pMxD.FocusMap;
                IActiveView pActiveView = pMxD.ActiveView;  
         
                /// Display the result......
                pMap.ClearSelection();

                pActiveView.Refresh();
                pMxD.UpdateContents();
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at DisplayResults: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at DisplayResults: " + e.Message);
            }
        }

        private void Generate_One_BMP(string strOriBMPType, ref ArrayList pcolResult)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
            IActiveView pActiveView = (IActiveView)pMap;
            pActiveView.Refresh();
            pMxD.UpdateContents();

            IFeatureLayer pLayerDelete = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strOriBMPType + Convert.ToString(SitingToolGlobal.appCount), pMap);
            pMap.DeleteLayer(pLayerDelete);


            bool foundResult = true;
            BMPobj oBMP = null;

            oBMP = _bMPCriteria.GetOneBMP(strOriBMPType);
            string strBMPType = GetBMPLayerNameFromTypeName(strOriBMPType);
            strResult = strBMPType;
            //strResult = strBMPType + Convert.ToString(SitingToolGlobal.appCount);
            double dScalefac = 0;
            /// Get the Map units....
            dScalefac = Get_Scale_Factor(pMap.MapUnits);

            /// Declarations.........
            IFeatureLayer pResult = null;


            /// Get the Source Layers.........
            IFeatureLayer pRoadLayer = null;
            IFeatureLayer pStreamLayer = null;
            IFeatureLayer pTempResultLayer = null;
            IFeatureLayer pWTLayer = null;
            IFeatureLayer pLanduseLayer = null;
            IFeatureLayer pLandownerLayer = null;
            IFeatureLayer pHSGLayer = null;

            IFeatureLayer pInmrlcLayer = null;
            IRasterLayer pInRasterLay = null;
            IFeatureLayer pInImpLayer = null;
            IFeatureLayer pInSlopeLayer = null;
            IFeatureLayer pInFlowLayer = null;


            string strCreatedLayerWholeExtent = Resource.LayerWholeExtent;
            pTempResultLayer = GenerateLayerWholeExtent(Settings.WorkingfolderParent, strCreatedLayerWholeExtent + "_" + Convert.ToString(SitingToolGlobal.appCount) + "_" + Convert.ToString(SitingToolGlobal.createdSoilCount));

            ///Road
            if (oBMP.DC_RB_State == "1" & (!string.IsNullOrEmpty(Settings.Roaddata)))
            {
                UpdateProgressBar();
                pRoadLayer = GenerateRoadLayer(oBMP);
                pResult = Get_Intersect_FeatureLayer(pTempResultLayer, pRoadLayer, strResult + "_Road" + "_" + Convert.ToString(SitingToolGlobal.appCount));
                if (pTempResultLayer != null)
                {
                    pMap.DeleteLayer(pTempResultLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pTempResultLayer.Name);
                }
                if (pRoadLayer != null)
                {
                    pMap.DeleteLayer(pRoadLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pRoadLayer.Name);
                }
                if (pResult != null)
                {
                    pTempResultLayer = pResult;
                }
                else
                {
                    //MessageBox.Show(this, "No results found for " + strBMPType, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    foundResult = false;
                    CleanupLayers(pInRasterLay, pInImpLayer, pWTLayer, pLanduseLayer, pInFlowLayer, pInmrlcLayer, pInSlopeLayer);
                    AdjustProgressBar(numProgressEachBMP[strOriBMPType]);
                    return;
                }
            }

            ///Stream
            if (oBMP.DC_SB_State == "1" & (!string.IsNullOrEmpty(Settings.Streamdata)))
            {
                UpdateProgressBar();
                pStreamLayer = GenerateStreamLayer(oBMP);
                pResult = Get_Intersect_FeatureLayer(pTempResultLayer, pStreamLayer, strResult + "_Stream" + "_" + Convert.ToString(SitingToolGlobal.appCount));
                if (pTempResultLayer != null)
                {
                    pMap.DeleteLayer(pTempResultLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pTempResultLayer.Name);
                }
                if (pStreamLayer != null)
                {
                    pMap.DeleteLayer(pStreamLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pStreamLayer.Name);
                }
                if (pResult != null)
                {
                    pTempResultLayer = pResult;
                }
                else
                {
                    //MessageBox.Show(this, "No results found for " + strBMPType, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    foundResult = false;
                    CleanupLayers(pInRasterLay, pInImpLayer, pWTLayer, pLanduseLayer, pInFlowLayer, pInmrlcLayer, pInSlopeLayer);
                    AdjustProgressBar(numProgressEachBMP[strOriBMPType]);
                    return;
                }
            }

            ///WaterTable
            if (oBMP.DC_WT_State == "1" & (!string.IsNullOrEmpty(Settings.WTdata)))
            {
                UpdateProgressBar();
                pWTLayer = GenerateWTLayer(oBMP);
                pResult = Get_Intersect_FeatureLayer(pTempResultLayer, pWTLayer, strResult + "_WT" + "_" + Convert.ToString(SitingToolGlobal.appCount));
                if (pTempResultLayer != null)
                {
                    pMap.DeleteLayer(pTempResultLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pTempResultLayer.Name);
                }
                if (pWTLayer != null)
                {
                    pMap.DeleteLayer(pWTLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pWTLayer.Name);
                }
                if (pResult != null)
                {
                    pTempResultLayer = pResult;
                }
                else
                {
                    //MessageBox.Show(this, "No results found for " + strBMPType, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    foundResult = false;
                    CleanupLayers(pInRasterLay, pInImpLayer, pWTLayer, pLanduseLayer, pInFlowLayer, pInmrlcLayer, pInSlopeLayer);
                    AdjustProgressBar(numProgressEachBMP[strOriBMPType]);
                    return;
                }
            }



            ///HSG
            if ((oBMP.DC_HG_State == "1" & (!string.IsNullOrEmpty(Settings.Soildata))))
            {
                UpdateProgressBar();
                pHSGLayer = GenerateHSGLayer(oBMP);

                pResult = Get_Intersect_FeatureLayer(pTempResultLayer, pHSGLayer, strResult + "_HG" + "_" + Convert.ToString(SitingToolGlobal.appCount));
                if (pTempResultLayer != null)
                {
                    pMap.DeleteLayer(pTempResultLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pTempResultLayer.Name);
                }
                if (pHSGLayer != null)
                {
                    pMap.DeleteLayer(pHSGLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pHSGLayer.Name);
                }
                if (pResult != null)
                {
                    pTempResultLayer = pResult;
                }
                else
                {
                    //MessageBox.Show(this, "No results found for " + strBMPType, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    foundResult = false;
                    CleanupLayers(pInRasterLay, pInImpLayer, pWTLayer, pLanduseLayer, pInFlowLayer, pInmrlcLayer, pInSlopeLayer);
                    AdjustProgressBar(numProgressEachBMP[strOriBMPType]);
                    return;
                }
            }
            

            /// In the original version if BMP is "Green roof", "RAIN BARREL","CISTERN" or "POROUS PAVEMENT" then only Landuse will be used.
            ///Landusedata
            if ((oBMP.DC_BB_State == "1" & (!string.IsNullOrEmpty(Settings.Landusedata))))
            {
                UpdateProgressBar();
                pLanduseLayer = GenerateLanduseLayer(oBMP);
                pResult = Get_Intersect_FeatureLayer(pTempResultLayer, pLanduseLayer, strResult + "_BB" + "_" + Convert.ToString(SitingToolGlobal.appCount));
                if (pTempResultLayer != null)
                {
                    pMap.DeleteLayer(pTempResultLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pTempResultLayer.Name);
                }
                if (pLanduseLayer != null)
                {
                    pMap.DeleteLayer(pLanduseLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pLanduseLayer.Name);
                }
                if (pResult != null)
                {
                    pTempResultLayer = pResult;
                }
                else
                {
                    //MessageBox.Show(this, "No results found for " + strBMPType, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    foundResult = false;
                    CleanupLayers(pInRasterLay, pInImpLayer, pWTLayer, pLanduseLayer, pInFlowLayer, pInmrlcLayer, pInSlopeLayer);
                    AdjustProgressBar(numProgressEachBMP[strOriBMPType]);
                    return;
                }
            }

            ///Raster Land Use
            if (oBMP.DC_RLU_State == "1" & (!string.IsNullOrEmpty(Settings.RasterLanduseData)))
            {
                UpdateProgressBar();
                pInmrlcLayer = GenerateRasterLanduseLayer(oBMP);

                pResult = Get_Intersect_FeatureLayer(pTempResultLayer, pInmrlcLayer, strResult + "_Landuse" + "_" + Convert.ToString(SitingToolGlobal.appCount));
                if (pTempResultLayer != null)
                {
                    pMap.DeleteLayer(pTempResultLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pTempResultLayer.Name);
                }
                if (pInmrlcLayer != null)
                {
                    pMap.DeleteLayer(pInmrlcLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pInmrlcLayer.Name);
                }
                if (pResult != null)
                {
                    pTempResultLayer = pResult;
                }
                else
                {
                    //MessageBox.Show(this, "No results found for " + strBMPType, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    foundResult = false;
                    CleanupLayers(pInRasterLay, pInImpLayer, pWTLayer, pLanduseLayer, pInFlowLayer, pInmrlcLayer, pInSlopeLayer);
                    AdjustProgressBar(numProgressEachBMP[strOriBMPType]);
                    return;
                }
            }

            ///Land Ownership
            if ((oBMP.DC_LO_State == "1" & (!string.IsNullOrEmpty(Settings.Landownerdata))))
            {
                UpdateProgressBar();
                pLandownerLayer = GenerateLandownerLayer(oBMP);
                pResult = Get_Intersect_FeatureLayer(pTempResultLayer, pLandownerLayer, strResult + "_LO" + "_" + Convert.ToString(SitingToolGlobal.appCount));
                if (pTempResultLayer != null)
                {
                    pMap.DeleteLayer(pTempResultLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pTempResultLayer.Name);
                }
                if (pLandownerLayer != null)
                {
                    pMap.DeleteLayer(pLandownerLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pLandownerLayer.Name);
                }
                if (pResult != null)
                {
                    pTempResultLayer = pResult;
                }
                else
                {
                    //MessageBox.Show(this, "No results found for " + strBMPType, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    foundResult = false;
                    CleanupLayers(pInRasterLay, pInImpLayer, pWTLayer, pLanduseLayer, pInFlowLayer, pInmrlcLayer, pInSlopeLayer);
                    AdjustProgressBar(numProgressEachBMP[strOriBMPType]);
                    return;
                }
            }
            ///impervious
            if (oBMP.DC_IMP_State == "1" & (!string.IsNullOrEmpty(Settings.Imperviousdata)))
            {
                UpdateProgressBar();
                pInImpLayer = GenerateImperviousLayer(oBMP);
                pResult = Get_Intersect_FeatureLayer(pTempResultLayer, pInImpLayer, strResult + "_IMP" + "_" + Convert.ToString(SitingToolGlobal.appCount));
                if (pTempResultLayer != null)
                {
                    pMap.DeleteLayer(pTempResultLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pTempResultLayer.Name);
                }
                if (pInImpLayer != null)
                {
                    pMap.DeleteLayer(pInImpLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pInImpLayer.Name);
                }
                if (pResult != null)
                {
                    pTempResultLayer = pResult;
                }
                else
                {
                    //MessageBox.Show(this, "No results found for " + strBMPType, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    foundResult = false;
                    CleanupLayers(pInRasterLay, pInImpLayer, pWTLayer, pLanduseLayer, pInFlowLayer, pInmrlcLayer, pInSlopeLayer);
                    AdjustProgressBar(numProgressEachBMP[strOriBMPType]);
                    return;
                }
            }


            ///export the dem data when DS or DA is checked
            if (((oBMP.DC_DS_State == "1") | (oBMP.DC_DA_State == "1")) & (!string.IsNullOrEmpty(Settings.DEMdata)))
            {
                SitingToolUtilities.Copy_RasterData_toCachefolder(Settings.DEMdata, Settings, pMap);
            }

            /// DEM drainage criteria
            if ((oBMP.DC_DA_State == "1") & (!string.IsNullOrEmpty(Settings.DEMdata)))
            {
                UpdateProgressBar();
                pInFlowLayer = GenerateDEMDrainageLayer(oBMP);
                pResult = Get_Intersect_FeatureLayer(pTempResultLayer, pInFlowLayer, strResult + "_Flow" + "_" + Convert.ToString(SitingToolGlobal.appCount));
                if (pTempResultLayer != null)
                {
                    pMap.DeleteLayer(pTempResultLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pTempResultLayer.Name);
                }
                if (pInFlowLayer != null)
                {
                    pMap.DeleteLayer(pInFlowLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pInFlowLayer.Name);
                }
                if (pResult != null)
                {
                    pTempResultLayer = pResult;
                }
                else
                {
                    //MessageBox.Show(this, "No results found for " + strBMPType, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    foundResult = false;
                    CleanupLayers(pInRasterLay, pInImpLayer, pWTLayer, pLanduseLayer, pInFlowLayer, pInmrlcLayer, pInSlopeLayer);
                    AdjustProgressBar(numProgressEachBMP[strOriBMPType]);
                    return;
                }
            }

            /// DEM slope criteria
            if ((oBMP.DC_DS_State == "1") & (!string.IsNullOrEmpty(Settings.DEMdata)))
            {
                UpdateProgressBar();
                pInSlopeLayer = GenerateDEMSlopeLayer(oBMP);
                pResult = Get_Intersect_FeatureLayer(pTempResultLayer, pInSlopeLayer, strResult + "_Slope" + "_" + Convert.ToString(SitingToolGlobal.appCount));
                if (pTempResultLayer != null)
                {
                    pMap.DeleteLayer(pTempResultLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pTempResultLayer.Name);
                }
                if (pInSlopeLayer != null)
                {
                    pMap.DeleteLayer(pInSlopeLayer);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, pInSlopeLayer.Name);
                }
                if (pResult != null)
                {
                    pTempResultLayer = pResult;
                }
                else
                {
                    //MessageBox.Show(this, "No results found for " + strBMPType, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    foundResult = false;
                    CleanupLayers(pInRasterLay, pInImpLayer, pWTLayer, pLanduseLayer, pInFlowLayer, pInmrlcLayer, pInSlopeLayer);
                    AdjustProgressBar(numProgressEachBMP[strOriBMPType]);
                    return;
                }
            }


            ////////////////////////////////////////////////////////////////////////////////
            /// Summarize weights into a new column
            ////////////////////////////////////////////////////////////////////////////////
            string[] colNames = new string[2];
            colNames[0] = "HYDGRP_W";
            colNames[1] = "Slope_W";
            if ((pTempResultLayer != null))
            {
                summarizeWeights(pTempResultLayer, colNames);
            }

            
            if (foundResult)
            {
                DisplayResults(pTempResultLayer, strOriBMPType);
                pcolResult.Add(strBMPType);
            }

            ///cleanup the layers
            CleanupLayers(pInRasterLay, pInImpLayer, pWTLayer, pLanduseLayer, pInFlowLayer, pInmrlcLayer, pInSlopeLayer);
            UpdateProgressBar();
            return;
       }

        /// <summary>
        ///  Checks the availablility of all the datalayers that are used for Analysis.......
        /// </summary>

        public bool CheckData_Availability()
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;

            ITable pTable = null;
            ILayer pLayer = null;

            try
            {
                IEnumerator resultEnumerator = _selectedBMPType.SelectedBMP.GetEnumerator();
                bool bRoadDataUsed = false;
                bool bStreamDataUsed = false;
                bool bDEMDataUsed = false;
                bool bSoilDataUsed = false;
                bool bImpDataUsed = false;
                bool bLanduseVectorDataUsed = false;
                bool bWTDataUsed = false;
                bool bLandownerDataUsed = false;
                bool bLanduseRasterDataUsed = false;

                while (resultEnumerator.MoveNext())
                {
                    BMPobj oBMP = BMPCriteria.GetOneBMP(resultEnumerator.Current.ToString());
                    if (oBMP.DC_RB_State == "1")
                    {
                        bRoadDataUsed = true;
                    }
                    if (oBMP.DC_SB_State == "1")
                    {
                        bStreamDataUsed = true;
                    }
                    if ((oBMP.DC_DA_State == "1") | (oBMP.DC_DS_State == "1"))
                    {
                        bDEMDataUsed = true;
                    }
                    if (oBMP.DC_HG_State == "1")
                    {
                        bSoilDataUsed = true;
                    }

                    if (oBMP.DC_IMP_State == "1")
                    {
                        bImpDataUsed = true;
                    }
                    if (oBMP.DC_BB_State == "1")
                    {
                        bLanduseVectorDataUsed = true;
                    }
                    if (oBMP.DC_WT_State == "1")
                    {
                        bWTDataUsed = true;
                    }
                    if (oBMP.DC_LO_State == "1")
                    {
                        bLandownerDataUsed = true;
                    }
                    if (oBMP.DC_RLU_State == "1")
                    {
                        bLanduseRasterDataUsed = true;
                    }
                }

                if (bRoadDataUsed & chkRB.Enabled)
                {
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Roaddata, pMap);
                    if ((pLayer == null))
                    {
                        MessageBox.Show(this, "Road Layer cannot be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                        return false;
                    }
                }
                if (bStreamDataUsed & chkSB.Enabled)
                {
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Streamdata, pMap);
                    if ((pLayer == null))
                    {
                        MessageBox.Show(this, "Stream Layer cannot be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                        return false;
                    }
                }
                if (bDEMDataUsed & (chkDA.Enabled | chkDS.Enabled))
                {
                    pLayer = SitingToolUtilities.GetInputRasterLayer(Settings.DEMdata, pMap);
                    if ((pLayer == null))
                    {
                        MessageBox.Show(this, "DEM Layer cannot be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                        return false;
                    }
                }
                if (bSoilDataUsed & chkHG.Enabled)
                {
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Soildata, pMap);
                    if ((pLayer == null))
                    {
                        MessageBox.Show(this, "Soil Layer cannot be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                        return false;
                    }
                    pTable = SitingToolUtilities.GetInputTable(Settings.SoilTable, pMap);
                    if ((pTable == null))
                    {
                        MessageBox.Show(this, "Soil Table cannot be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                        return false;
                    }
                }
                if (bImpDataUsed & chkIMP.Enabled)
                {
                    pLayer = SitingToolUtilities.GetInputRasterLayer(Settings.Imperviousdata, pMap);
                    if ((pLayer == null))
                    {
                        MessageBox.Show(this, "Impervious Layer cannot be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                        return false;
                    }
                }
                if (bLanduseVectorDataUsed & chkBB.Enabled)
                {
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Landusedata, pMap);
                    if ((pLayer == null))
                    {
                        MessageBox.Show(this, "Landuse Layer cannot be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                        return false;
                    }
                }
                if (bWTDataUsed & chkWT.Enabled)
                {
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.WTdata, pMap);
                    if ((pLayer == null))
                    {
                        MessageBox.Show(this, "Water Table Layer cannot be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                        return false;
                    }
                }

                if (bLandownerDataUsed & chkLO.Enabled)
                {
                    pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.Landownerdata, pMap);
                    if ((pLayer == null))
                    {
                        MessageBox.Show(this, "Land ownership Layer cannot be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                        return false;
                    }
                }

                if (bLanduseRasterDataUsed & chkRLU.Enabled)
                {
                    pLayer = SitingToolUtilities.GetInputRasterLayer(Settings.RasterLanduseData, pMap);
                    if ((pLayer == null))
                    {
                        MessageBox.Show(this, "Raster land use Layer cannot be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                        return false;
                    }
                    pTable = SitingToolUtilities.GetInputTable(Settings.RasterLanduseTable, pMap);
                    if ((pTable == null))
                    {
                        MessageBox.Show(this, "Raster land use Table cannot be found.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                        return false;
                    }
                }
            }
            catch (Exception e)
            {
                MessageBox.Show("Error at CheckData_Availability: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at CheckData_Availability: " + e.Message);
            }
            finally
            {
                if (pTable != null)
                    Marshal.FinalReleaseComObject(pTable);
                if (pLayer != null)
                    Marshal.FinalReleaseComObject(pLayer);
            }

            return true;

        }

        private void Generate_Selected_BMPs(ref ArrayList pcolResult)
        {


            //timer1.Enabled = true;
            int progressCount = ComputeProgressCount();
            sitingProgressBar.Minimum = 0;
            sitingProgressBar.Maximum = progressCount;
            sitingProgressBar.Step = 1;
            AdjustProgressBar(0);

            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
            bool m_PassFlag = true;

            Settings.LoadSettings(Settings.SitingToolSettingsFile);

            ///First check to see if there is analysis layer on the map

            IFeatureLayer pLayer = null;
            string strBMPType = "";
            IEnumerator resultEnumerator = _selectedBMPType.SelectedBMP.GetEnumerator();
            while (resultEnumerator.MoveNext())
            {
                strBMPType = GetBMPLayerNameFromTypeName(resultEnumerator.Current.ToString());

                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strBMPType, pMap);
                if ((pLayer != null))
                {
                    MessageBox.Show(this, "Please delete the analysis layer \"" + pLayer.Name + "\" and proceed.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return;
                }
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Resource.Composite, pMap);
                if ((pLayer != null))
                {
                    MessageBox.Show(this, "Please delete the analysis layer \"" + pLayer.Name + "\" and proceed.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return;
                }
            }

            ///Check Data Layer availability
            if (!CheckData_Availability())
            {
                m_PassFlag = false;
                return;
            }

            if (!CreateWorkfolder()) { m_PassFlag = false; return; }

            //////////////////////////////////////////////////////////////
            /// Validate the Datasets and then Proceed..........
            //////////////////////////////////////////////////////////////

            pMxD = (IMxDocument)m_application.Document;
            pMap = pMxD.FocusMap;
            m_PassFlag = SitingToolUtilities.ValidateDatasets_ST(true, pMap, Settings);
            if (!m_PassFlag)
                return;

            //////////////////////////////////////////////////////////////
            /// Check Criteria .....
            //////////////////////////////////////////////////////////////
            resultEnumerator = _selectedBMPType.SelectedBMP.GetEnumerator();
            while (resultEnumerator.MoveNext())
            {
                SitingToolGlobal.createdSoilCount = SitingToolGlobal.createdSoilCount + 1;
                if (!Check_Criteria(resultEnumerator.Current.ToString()))
                {
                    m_PassFlag = false;
                    return;
                }
            }

 
            //////////////////////////////////////////////////////////////
            /// Now Loop through the BMPs in the list and process each BMP...
            //////////////////////////////////////////////////////////////
            sitingProgressBar.Show();
            SitingToolGlobal.createdSoilCount = 0;
            SitingToolGlobal.slopeFilterCount = 0;
            resultEnumerator = _selectedBMPType.SelectedBMP.GetEnumerator();

            pMxD = (IMxDocument)m_application.Document;
            pMap = pMxD.FocusMap;
            while (resultEnumerator.MoveNext())
            {
                SitingToolGlobal.createdSoilCount = SitingToolGlobal.createdSoilCount + 1;
                SitingToolGlobal.slopeFilterCount = SitingToolGlobal.slopeFilterCount + 1;
                strBMPType = GetBMPLayerNameFromTypeName(resultEnumerator.Current.ToString());
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strBMPType, pMap);

                Generate_One_BMP(resultEnumerator.Current.ToString(), ref pcolResult);

            }

            ////////////////////////////////////////////////////////////////
            /// Now Create a Composite Layer if selected BMPs are multiple ....
            ////////////////////////////////////////////////////////////////
            if (pcolResult.Count > 1)
            {

                Create_Composite_Layer(pcolResult);
                /// Add the Composite Layer....
                pcolResult.Add(Resource.Composite);
            }


            resultEnumerator = _selectedBMPType.SelectedBMP.GetEnumerator();
            while (resultEnumerator.MoveNext())
            {
                strBMPType = GetBMPLayerNameFromTypeName(resultEnumerator.Current.ToString());

                ///added to convert multipart to single part
                //pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strBMPType, pMap);
                pLayer = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(strBMPType + Convert.ToString(SitingToolGlobal.appCount), pMap);
                if ((pLayer != null))
                {
                    Multipart_to_SinglePart((pLayer.Name));
                }

            }

            AdjustProgressBar(progressCount);
            FinalCleanupLayers();
            if (m_PassFlag)
            {
                /// Turn off layers....
                Turn_Off_Layers(pcolResult);
                resultEnumerator.Reset(); ;
                string BMPwithNoResult = "";
                while (resultEnumerator.MoveNext())
                {
                    strBMPType = GetBMPLayerNameFromTypeName(resultEnumerator.Current.ToString());
                    if (!pcolResult.Contains(strBMPType))
                    {
                        BMPwithNoResult = BMPwithNoResult + "\n" + resultEnumerator.Current.ToString();
                    }
                }
                if (BMPwithNoResult != "")
                {
                    MessageBox.Show(this, "No result generated for the following BMPs: " + BMPwithNoResult, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
                
                MessageBox.Show(this, "Analysis completed.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                sitingProgressBar.Hide();
            }
        }

        private void Create_Composite_Layer(ArrayList pcolResult)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;

            ///////////////////////////////////////////////////
            /// Union the Features to make one feature....
            ///////////////////////////////////////////////////

            IFeatureLayer pResult = null;
            string strLayers = null;

            IEnumerator resultEnumerator = pcolResult.GetEnumerator();

            try
            {
                string strResult = null;
                int iResult = 0;
                string strDissolve_Flds = null;

                /// InitialiZe the Stings...........
                strLayers = "''";
                strDissolve_Flds = Resource.BMP;
                /// Loop and build the Dissolve fields......
                while (resultEnumerator.MoveNext())
                {
                    strResult = resultEnumerator.Current.ToString();
                    if (iResult > 0)
                        strDissolve_Flds = strDissolve_Flds + ";" + Resource.BMPforComposite + "_" + iResult; 
                    iResult = iResult + 1;
                }

                /// Clean up the Map......
                IDataset pDataset = (IDataset)SitingToolUtilities.GetFeatureLayer(Settings.WorkingfolderParent, Resource.Union + "1");
                if ((pDataset != null))
                {
                    if (pDataset.CanDelete())
                        pDataset.Delete();
                }
                pDataset = (IDataset)SitingToolUtilities.GetFeatureLayer(Settings.WorkingfolderParent, Resource.Composite + Convert.ToSingle(SitingToolGlobal.appCount -1));
                if ((pDataset != null))
                {
                    if (pDataset.CanDelete())
                        pDataset.Delete();
                }

                resultEnumerator.Reset();
                resultEnumerator.MoveNext();


                //strLayers = strLayers + "; '" + Settings.WorkingfolderParent + "\\" + pcolResult[0] + Resource.ShapeFileExt + "' ''";
                strLayers = strLayers + "; '" + Settings.WorkingfolderParent + "\\" + pcolResult[0] + Convert.ToString(SitingToolGlobal.appCount) + Resource.ShapeFileExt + "' ''";
                if (pcolResult.Count > 1)
                {
                    //strLayers = strLayers + "; '" + Settings.WorkingfolderParent + "\\" + pcolResult[1] + Resource.ShapeFileExt + "' ''";
                    strLayers = strLayers + "; '" + Settings.WorkingfolderParent + "\\" + pcolResult[1] + Convert.ToString(SitingToolGlobal.appCount) + Resource.ShapeFileExt + "' ''";
                }
                strLayers = strLayers.Substring(4);

                ///geoprocessing
                Geoprocessor GP = new Geoprocessor();

                ///# Union 3 other feature classes, but specify some ranks for each since parcels has better spatial accuracy
                Union pUnion = new Union();
                pUnion.in_features = strLayers;
                //pUnion.out_feature_class = Settings.WorkingfolderParent + "\\" + Resource.Union + "1" + Resource.ShapeFileExt;
                pUnion.out_feature_class = Settings.WorkingfolderParent + "\\" + Resource.Union + Convert.ToString(SitingToolGlobal.appCount) + Resource.ShapeFileExt;
                pUnion.gaps = Resource.GAPS;
                pUnion.join_attributes = Resource.ALL;
                GP.Execute(pUnion, null);

                /// Loop and Merge all results......
                strLayers = "''";

                int indexColResult = 2;
                //iResult = 2;
                iResult = SitingToolGlobal.appCount + 1;
                if (pcolResult.Count >= 2)
                {
                    resultEnumerator.MoveNext();
                }
                while (resultEnumerator.MoveNext())
                {

                    strLayers = "'" + Settings.WorkingfolderParent + "\\" + Resource.Union + Convert.ToString(iResult - 1) + Resource.ShapeFileExt + "' ''; '" + Settings.WorkingfolderParent + "\\" + Convert.ToString(pcolResult[indexColResult]) + Convert.ToString(SitingToolGlobal.appCount) + Resource.ShapeFileExt + "' ''";
                    ///# Union 3 other feature classes, but specify some ranks for each since parcels has better spatial accuracy
                    pUnion.in_features = strLayers;
                    pUnion.out_feature_class = Settings.WorkingfolderParent + "\\" + Resource.Union + iResult + Resource.ShapeFileExt;
                    pUnion.gaps = Resource.GAPS;
                    pUnion.join_attributes = Resource.ALL;
                    GP.Execute(pUnion, null);

                    /// Remove the Previous Union layer.....
                    pResult = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Resource.Union + Convert.ToString(iResult - 1), pMap);
                    if ((pResult != null))
                    {
                        pMxD = (IMxDocument)m_application.Document;
                        pMap = pMxD.FocusMap;
                        pMap.DeleteLayer(pResult);
                        SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Resource.Union + Convert.ToString(iResult - 1));
                    }
                    iResult++;
                    indexColResult++;
                }


                /// Delete any composite layer............
                pDataset = (IDataset)SitingToolUtilities.GetFeatureLayer(Settings.WorkingfolderParent, Resource.Composite + SitingToolGlobal.appCount);
                if ((pDataset != null))
                {
                    if (pDataset.CanDelete())
                        pDataset.Delete();
                }


                /// Update the columns
                IFeatureLayer pFeatureLayer = null;
                pFeatureLayer = (IFeatureLayer)SitingToolUtilities.GetFeatureLayer(Settings.WorkingfolderParent, Resource.Union + Convert.ToString(iResult - 1));
                IFields pFields = null;
                pFields = pFeatureLayer.FeatureClass.Fields;
                int iCnt = 0;
                int iFldCnt = 1;

                /// Rename the Fields.....
                for (iCnt = pFields.FieldCount - 1; iCnt >= 0; iCnt += -1)
                {
                    pFields = pFeatureLayer.FeatureClass.Fields;
                    if (pFields.Field[iCnt].Name.Contains(Resource.BMPforComposite))
                    {
                        updateColumnName(pFeatureLayer, (pFields.Field[iCnt].Name), Resource.BMPforComposite + "_" + Convert.ToString(iFldCnt));
                        /// Increment the Field flag....
                        iFldCnt = iFldCnt + 1;
                    }
                }

                /// # Dissolve the polygons to simplify.............
                Dissolve pDissolve = new Dissolve();
                pDissolve.in_features = Resource.Union + Convert.ToString(iResult - 1);
                pDissolve.out_feature_class = Settings.WorkingfolderParent + "\\" + Resource.Composite + SitingToolGlobal.appCount + Resource.ShapeFileExt;
                pDissolve.dissolve_field = strDissolve_Flds;
                pDissolve.multi_part = Resource.multiPART;
                GP.Execute(pDissolve, null);

                /// Delete the Combined Layer......
                pResult = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Resource.Union + Convert.ToString(iResult - 1), pMap);
                if ((pResult != null))
                {
                    pMap.DeleteLayer(pResult);
                    SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, Resource.Union + Convert.ToString(iResult - 1));
                }

                ///added to convert the Composite layer from multiput to singlepart
                ILayer pLayer = null;
                pLayer = SitingToolUtilities.GetInputFeatureLayer(Resource.Composite + SitingToolGlobal.appCount, pMap);
                if ((pLayer != null))
                {
                    pMap.DeleteLayer(pLayer);
                }

                Multipart_to_SinglePart(Resource.Composite + SitingToolGlobal.appCount);
                // Change Style of composite Layer.....
                pResult = (IFeatureLayer)SitingToolUtilities.GetInputFeatureLayer(Resource.Composite + SitingToolGlobal.appCount, pMap);
                SitingToolUtilities.RenderUniqueValueFillSymbol_ST(pResult, strDissolve_Flds, "Result");
                /// Refresh the TOC
                pMxD = (IMxDocument)m_application.Document;
                pMxD.ActiveView.ContentsChanged();
                pMxD.UpdateContents();

                /// Draw the map
                pMxD.ActiveView.Refresh();
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at Create_Composite_Layer: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at Create_Composite_Layer: " + e.Message);
            }
            finally
            {
                if (pResult != null)
                    Marshal.FinalReleaseComObject(pResult);
                //if (resultEnumerator != null)
                //    Marshal.FinalReleaseComObject(resultEnumerator);
            }
            return;

        }
        private void updateColumnName(IFeatureLayer pFeatureLayer, string oldColumnName, string newColumnName)
        {
            IFeatureClass pFeatClass = null;
            pFeatClass = pFeatureLayer.FeatureClass;

            IField pField = null;
            IField pOldField = null;
            IFieldEdit pFieldEdit = null;
            int pFieldIndex = 0;

            IFeatureCursor pFeatureCursor = null;
            IFeature pFeature = null;
            IFields pFields = null;

            try
            {
                pFieldIndex = pFeatClass.Fields.FindField(oldColumnName);
                if (pFieldIndex > 0)
                {

                    pOldField = pFeatClass.Fields.Field[pFieldIndex];
                    /// Now add the Field
                    pField = new Field();
                    pFieldEdit = (IFieldEdit)pField;
                    pFieldEdit.Name_2 = newColumnName;
                    pFieldEdit.AliasName_2 = newColumnName;
                    pFieldEdit.Type_2 = pOldField.Type;

                    pFeatClass.AddField(pField);

                    pFeatureCursor = pFeatClass.Search(null, true);
                    pFeature = pFeatureCursor.NextFeature();

                    while ((pFeature != null))
                    {

                        pFeature.Value[pFeature.Fields.FindField(newColumnName)] = pFeature.Value[pFeature.Fields.FindField(oldColumnName)];
                        pFeature.Store();
                        pFeature = pFeatureCursor.NextFeature();
                    }
                    /// Delete old field from the featureClass
                    pFields = pFeatClass.Fields;
                    pFeatClass.DeleteField(pFields.Field[pFieldIndex]);
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at updateColumnName: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at updateColumnName: " + e.Message);
            }
            finally
            {

                //if (pFeatClass != null)
                //    Marshal.FinalReleaseComObject(pFeatClass); // cannot be released
                if (pField != null)
                    Marshal.FinalReleaseComObject(pField);
                if (pOldField != null)
                    Marshal.FinalReleaseComObject(pOldField);
                if (pFieldEdit != null)
                    Marshal.FinalReleaseComObject(pFieldEdit);
                if (pFeatureCursor != null)
                    Marshal.FinalReleaseComObject(pFeatureCursor);
                if (pFeature != null)
                    Marshal.FinalReleaseComObject(pFeature);
                if (pFields != null)
                    Marshal.FinalReleaseComObject(pFields);
            }
            return;

        }
        private void summarizeWeights(IFeatureLayer pFeatureLayer, string[] colNames)
        {

            IFeatureClass pFeatClass = null;
            pFeatClass = pFeatureLayer.FeatureClass;
            IField pField = null;
            IFieldEdit pFieldEdit = null;
            int pFieldIndex = 0;

            try
            {
                /// Now add the Field.....
                pField = new Field();
                pFieldEdit = (IFieldEdit)pField;
                pFieldEdit.Name_2 = Resource.SumWeight;
                pFieldEdit.AliasName_2 = Resource.SumWeight;
                pFieldEdit.Type_2 = esriFieldType.esriFieldTypeInteger;
                pFeatClass.AddField(pField);

                ///get all number and sum to new field
                int itemLen = 0;
                int iIndex = 0;

                itemLen = colNames.Count();

                IFeatureCursor pFeatureCursor = null;
                pFeatureCursor = pFeatClass.Search(null, true);
                IFeature pFeature = null;
                pFeature = pFeatureCursor.NextFeature();

                int Output = 0;
                while ((pFeature != null))
                {
                    Output = 0;
                    for (iIndex = 0; iIndex <= itemLen - 1; iIndex++)
                    {
                        pFieldIndex = pFeatClass.Fields.FindField(colNames[iIndex]);
                        if (pFieldIndex >= 0)
                        {
                            Output = Output + Convert.ToInt16(pFeature.Value[pFeatClass.Fields.FindField(colNames[iIndex])]);
                        }
                    }

                    pFeature.Value[pFeature.Fields.FindField(Resource.SumWeight)] = Output;
                    pFeature.Store();
                    pFeature = pFeatureCursor.NextFeature();
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at summarizeWeights: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at summarizeWeights: " + e.Message);
            }
            finally
            {

                if (pFeatClass != null)
                    Marshal.FinalReleaseComObject(pFeatClass);
                if (pField != null)
                    Marshal.FinalReleaseComObject(pField);
                if (pFieldEdit != null)
                    Marshal.FinalReleaseComObject(pFieldEdit);
            }
            return;

        }
        private void Turn_Off_Layers(ArrayList pcolResult)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;

            short iCnt = 0;
            try
            {
                if (pcolResult == null)
                    return;

                for (iCnt = 0; iCnt <= pMap.LayerCount - 1; iCnt++)
                {
                    if (!pcolResult.Contains(pMap.Layer[iCnt].Name))
                    {
                        pMap.Layer[iCnt].Visible = false;
                    }
                }
                IActiveView pActView = null;
                pActView = (IActiveView)pMap;
                pActView.Refresh();
                pMxD.UpdateContents();
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at Turn_Off_Layers: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at Turn_Off_Layers: " + e.Message);
            }
            return;


        }
        private void Multipart_to_SinglePart(string strShapeFileName)
        {

            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
            IFeatureClass pFeatClass = null;
            ILayer pLayerDelete = null;
            IFeatureLayer pLayer = null;
            try
            {
                //geoprocessing
                Geoprocessor GP = new Geoprocessor();
                MultipartToSinglepart pMultipartToSinglepart = new MultipartToSinglepart();
                pMultipartToSinglepart.in_features = Settings.WorkingfolderParent + "/" + strShapeFileName + Resource.ShapeFileExt;
                pMultipartToSinglepart.out_feature_class = Settings.WorkingfolderParent + "/" + strShapeFileName + Resource.Single + Resource.ShapeFileExt;
            

                GP.Execute(pMultipartToSinglepart, null);
                pLayerDelete = SitingToolUtilities.GetInputFeatureLayer(strShapeFileName + Resource.Single, pMap);
                if ((pLayerDelete != null))
                    pMap.DeleteLayer(pLayerDelete);

                SitingToolUtilities.Delete_Dataset_ST(Settings.WorkingfolderParent, strShapeFileName);
                Rename pRename = new Rename();
            
                pRename.in_data = strShapeFileName + Resource.Single + Resource.ShapeFileExt;
                pRename.out_data = strShapeFileName + Resource.ShapeFileExt;
                GP.SetEnvironmentValue("workspace", Settings.WorkingfolderParent);
                GP.Execute(pRename, null);

                ///Remove the field "ORIG_FID"
                pFeatClass = SitingToolUtilities.OpenShapeFile(Settings.WorkingfolderParent, strShapeFileName);
                string strFieldDelete = null;
                strFieldDelete = "ORIG_FID";
                int iIndexField = 0;
                iIndexField = pFeatClass.Fields.FindField(strFieldDelete);
                if (iIndexField >= 0)
                {
                    pFeatClass.DeleteField(pFeatClass.Fields.Field[iIndexField]);
                }

                
                pLayer = new FeatureLayer();
                pLayer.FeatureClass = pFeatClass;
                pLayer.Name = strShapeFileName;
                pLayer.Visible = true;
                //Add the New Layer....
                pMap.AddLayer(pLayer);

                ChangeStyle(pLayer);
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at Multipart_to_SinglePart: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at Multipart_to_SinglePart: " + e.Message);
            }
            finally
            {

                if (pFeatClass != null)
                    Marshal.FinalReleaseComObject(pFeatClass);
                if (pLayerDelete != null)
                    Marshal.FinalReleaseComObject(pLayerDelete);
                if (pLayer != null)
                    Marshal.FinalReleaseComObject(pLayer);
            }

            return;
        }
        private void ChangeStyle(IFeatureLayer pFeatLyr)
        {
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;

            IRgbColor pColor = null;
            ISymbol pSym = null;
            ISimpleMarkerSymbol pMarkerSym = null;
            ISimpleLineSymbol pLineSymbol = null;
            ISimpleFillSymbol pFillSymbol = null;
            ISimpleLineSymbol pOutlineSymbol = null;
            try
            {
                pColor = new RgbColor();
                /// use red. it's a good color
                pColor.RGB = System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Black);
                
                pOutlineSymbol = new SimpleLineSymbol();
                pOutlineSymbol.Color = pColor;
                // Put the color R G B 
                pOutlineSymbol.Width = 0;

                // use Green.....
                pColor.RGB = System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Lime);

                // based on feature type, make proper symbol, then assign to pSym
                switch (pFeatLyr.FeatureClass.ShapeType)
                {
                    case esriGeometryType.esriGeometryPoint:
                        // set up a marker symbol
                        pMarkerSym = new SimpleMarkerSymbol();
                        {
                            pMarkerSym.Size = 12;
                            pMarkerSym.Color = pColor;
                            pMarkerSym.Style = esriSimpleMarkerStyle.esriSMSX;
                        }

                        pSym = (ISymbol)pMarkerSym;
                        break;

                    case esriGeometryType.esriGeometryPolyline:
                        // set up a line symbol
                        pLineSymbol = new SimpleLineSymbol();
                        {
                            pLineSymbol.Width = 1;
                            pLineSymbol.Color = pColor;
                            pLineSymbol.Style = esriSimpleLineStyle.esriSLSDashDotDot;
                        }

                        pSym = (ISymbol)pLineSymbol;
                        break;

                    case esriGeometryType.esriGeometryPolygon:
                        // setup a fill symbol
                        pFillSymbol = new SimpleFillSymbol();
                        {
                            pFillSymbol.Color = pColor;
                            pFillSymbol.Style = esriSimpleFillStyle.esriSFSSolid;
                            pFillSymbol.Outline = pOutlineSymbol;
                        }

                        pSym = (ISymbol)pFillSymbol;
                        break;

                    default:
                        return;

                }

                IFeatureRenderer pRend = null;
                pRend = (IFeatureRenderer)new SimpleRenderer();

                /// set symbol.
                ISimpleRenderer pSimpleRend = null;
                pSimpleRend = (ISimpleRenderer)pRend;
                pSimpleRend.Symbol = pSym;

                IGeoFeatureLayer pGeoFL = null;
                pGeoFL = (IGeoFeatureLayer)pFeatLyr;

                /// finally, set the new renderer to the layer and refresh the map
                pGeoFL.Renderer = pRend;
                ///Upate the TOC.....
                IMapFrame pMapFrame = null;
                pMapFrame = (IMapFrame)new MapFrame();
                pMapFrame.Map = pMap;
                pMxD.CurrentContentsView.Refresh(0);
                /// Zoom to Layer Extents....
                IActiveView pActiveView =  (IActiveView)pMap;
            
                pActiveView.Extent = pFeatLyr.AreaOfInterest;
                pActiveView.Refresh();
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at ChangeStyle: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at ChangeStyle: " + e.Message);
            }
            finally
            {
                if (pColor != null)
                    Marshal.FinalReleaseComObject(pColor);
                if (pSym != null)
                    Marshal.FinalReleaseComObject(pSym);
                if (pMarkerSym != null)
                    Marshal.FinalReleaseComObject(pMarkerSym);
                if (pLineSymbol != null)
                    Marshal.FinalReleaseComObject(pLineSymbol);
                if (pFillSymbol != null)
                    Marshal.FinalReleaseComObject(pFillSymbol);
                if (pOutlineSymbol != null)
                    Marshal.FinalReleaseComObject(pOutlineSymbol);
            }
            return;

        }
        private bool Check_Expression(string strExp, bool bCanBeRange)
        {
            bool returnValue = false;


            string strTmp = null;
            int iCnt = 0;
            string strTmp2 = null;
            try
            {
                iCnt = 1;
                strExp = strExp.Trim();
                ///check if it begins with >
                iCnt = strExp.Trim().IndexOf('>');
                if (iCnt >= 0)
                {

                    strTmp = strExp.Trim().Substring(iCnt + 1);
                
                    ///is number and is positive
                    if (SitingToolUtilities.IsNumeric(strTmp) & !strTmp.Contains("-"))
                    {
                        returnValue = true;
                    }
                }

                ///check if it begins with <
                iCnt = strExp.Trim().IndexOf('<');
                if (iCnt >= 0)
                {
                    strTmp = strExp.Trim().Substring(iCnt + 1);
                
                    ///is number and is positive
                    if (SitingToolUtilities.IsNumeric(strTmp) & !strTmp.Contains("-"))
                    {
                        returnValue = true;
                    }
                }

                ///check if its format is min-max
                if (bCanBeRange)
                {
                    iCnt = strExp.Trim().IndexOf('-');

                    if (iCnt >= 1)
                    {
                        strTmp = strExp.Substring(0, iCnt);

                        strTmp2 = strExp.Substring(iCnt + 1);
                        if (SitingToolUtilities.IsNumeric(strTmp) & !strTmp.Contains('-') & SitingToolUtilities.IsNumeric(strTmp2) & !strTmp2.Contains('-'))
                        {
                            returnValue = true;
                        }
                    }
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(this, "Error at Check_Expression: " + e.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at Check_Expression: " + e.Message);
            }
            return returnValue;

        }
        private bool Check_DC_HG(string strExp)
        {
            bool returnValue = false;
            
            int iCnt = 0;
            strExp = strExp.Trim();
            if (strExp.Trim().Length == 3)
            {
                iCnt = strExp.IndexOf('-');
                if (iCnt == 1)
                {
                    returnValue = true;
                }
            }

            if (strExp.Trim().Length == 1)
            {
                returnValue = true;
            }

            return returnValue;

        }
        private bool Check_Criteria(string strBMPType)
        {
            bool returnValue = false;

            BMPobj oBMP = BMPCriteria.GetOneBMP(strBMPType);

            /// Now Check if the Buffer distance is > 0.......................
            if (!string.IsNullOrEmpty(Settings.Roaddata) & !Check_Expression(oBMP.DC_RB, true) & oBMP.DC_RB_State == "1")
            {
                MessageBox.Show(this, "For type " + strBMPType + ", Road buffer should be in one of the following formats: " + "\n" + ">min, <max, min-max", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                return returnValue;
            }

            if (!string.IsNullOrEmpty(Settings.Streamdata) & !Check_Expression(oBMP.DC_SB, true) & oBMP.DC_SB_State == "1")
            {
                MessageBox.Show(this, "For type " + strBMPType + ", Stream buffer should be in one of the following formats: " + "\n" + ">min, <max, min-max", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                return returnValue;
            }
            if ((strBMPType.ToUpper() != "GREEN ROOF") & (strBMPType.ToUpper() != "POROUS PAVEMENT"))
            {

                if (!string.IsNullOrEmpty(Settings.Landusedata) & !Check_Expression(oBMP.DC_BB, true) & oBMP.DC_BB_State == "1")
                {
                    MessageBox.Show(this, "For type " + strBMPType + ", Building buffer should be in one of the following formats: " + "\n" + ">min, <max, min-max", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    return returnValue;
                }
            }

            ///Check for Green Roof
            if ((strBMPType.ToUpper() == "GREEN ROOF") & oBMP.DC_BB_State == "0")
            {
                MessageBox.Show(this, "For GREEN ROOF, please select the check box for Building Buffer to proceed. ", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                return returnValue;
            }

            if (!string.IsNullOrEmpty(Settings.Imperviousdata) & !Check_Expression(oBMP.DC_IMP, false) & oBMP.DC_IMP_State == "1")
            {
                MessageBox.Show(this, "For type " + strBMPType + ", Impervious should be in one of the following formats: " + "\n" + ">min, <max", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                return returnValue;
            }
            if (!string.IsNullOrEmpty(Settings.DEMdata) & !Check_Expression(oBMP.DC_DA, false) & oBMP.DC_DA_State == "1")
            {
                MessageBox.Show(this, "For type " + strBMPType + ", Drainage Area should be in one of the following formats: " + "\n" + ">min, <max", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);

                return returnValue;
            }
            if (!string.IsNullOrEmpty(Settings.DEMdata) & !Check_Expression(oBMP.DC_DS, false) & oBMP.DC_DS_State == "1")
            {
                MessageBox.Show(this, "For type " + strBMPType + ", Slope should be in one of the following formats: " + "\n" + ">min, <max", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                return returnValue;
            }
            if (!string.IsNullOrEmpty(Settings.WTdata) & !Check_Expression(oBMP.DC_WT, false) & oBMP.DC_WT_State == "1")
            {
                MessageBox.Show(this, "For type " + strBMPType + ", Water Depth should be in one of the following formats: " + "\n" + ">min, <max", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                return returnValue;
            }

            if (!string.IsNullOrEmpty(Settings.Soildata) & !Check_DC_HG(oBMP.DC_HG) & oBMP.DC_HG_State == "1")
            {
                MessageBox.Show(this, "For type " + strBMPType + ", Soil Group criteria should be in one of the following formats: " + "\n" + "A-D, A", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                return returnValue;
            }

            if ((!string.IsNullOrEmpty(Settings.Landusedata) & oBMP.DC_BB_State == "1") | (!string.IsNullOrEmpty(Settings.DEMdata) & oBMP.DC_DA_State == "1") | (!string.IsNullOrEmpty(Settings.DEMdata) & oBMP.DC_DS_State == "1") | (!string.IsNullOrEmpty(Settings.Soildata) & oBMP.DC_HG_State == "1") | (!string.IsNullOrEmpty(Settings.Imperviousdata) & oBMP.DC_IMP_State == "1") | (!string.IsNullOrEmpty(Settings.Roaddata) & oBMP.DC_RB_State == "1") | (!string.IsNullOrEmpty(Settings.Streamdata) & oBMP.DC_SB_State == "1") | (!string.IsNullOrEmpty(Settings.WTdata) & oBMP.DC_WT_State == "1") | (!string.IsNullOrEmpty(Settings.Landownerdata) & oBMP.DC_LO_State == "1") | (!string.IsNullOrEmpty(Settings.RasterLanduseData) & oBMP.DC_RLU_State == "1"))
            {
                 returnValue = true;
            }
            if (!returnValue)
                MessageBox.Show(this, "Please select at least one criterion for " + strBMPType, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);

            return returnValue;

        }

        private void ImgBMP_Click(object sender, EventArgs e)
        {

        }

        private void tableLayoutPanel2_Paint_1(object sender, PaintEventArgs e)
        {

        }
    }
}
