﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using BMPSitingTool.Utilities;
using BMPSitingTool.Common;
using BMPSitingTool.Classes;

using ESRI.ArcGIS.Framework;
using ESRI.ArcGIS.ADF.BaseClasses;
using ESRI.ArcGIS.ADF.CATIDs;
using ESRI.ArcGIS.ArcMapUI;
using ESRI.ArcGIS.SpatialAnalyst;
using ESRI.ArcGIS.Carto;
using ESRI.ArcGIS.CatalogUI;
using ESRI.ArcGIS.Catalog;
using ESRI.ArcGIS.ArcMap;
using ESRI.ArcGIS.Geodatabase;
using ESRI.ArcGIS.Geometry;
using ESRI.ArcGIS.DataSourcesRaster;


namespace BMPSitingTool.Forms
{
    public enum datasetType
    {
        dtRaster = 1,
        dtFeature = 2,
        dtTable = 3
    }
    public partial class FrmDataManagement : Form
    {


        private SitingToolSettings _settings;

        private Dictionary<String,object> m_LayerDict;
        private IApplication m_application;
  
        public IApplication ArcGISApplication
        {
            set
            {
                m_application = value;
            }
        }
        public SitingToolSettings Settings
        {
            get { return _settings; }
            set { _settings = value; }
        }

        public FrmDataManagement()
        {
            InitializeComponent();
        }


        private void FrmDataManagement_Load(object sender, EventArgs e)
        {

            /// Refresh Controls....
            Settings.LoadSettings(Settings.SitingToolSettingsFile);
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;

            Initialize_List();
           
            if (!string.IsNullOrEmpty(Settings.DEMdata))
            {
                if (m_LayerDict.ContainsKey(Settings.DEMdata) & (SitingToolUtilities.GetInputFeatureLayer(Settings.DEMdata, pMap) != null))
                {
                    cmbDEMpath.Text = Settings.DEMdata;
                }
            }
            if (!string.IsNullOrEmpty(Settings.ZUnit))
            {
                
                cmbZUnit.Text = Settings.ZUnit;
                
            }

            if (!string.IsNullOrEmpty(Settings.RasterLanduseData))
            {
                if (m_LayerDict.ContainsKey(Settings.RasterLanduseData) & (SitingToolUtilities.GetInputFeatureLayer(Settings.RasterLanduseData, pMap) != null))
                {
                    cmbMRLC.Text = Settings.RasterLanduseData;
                }
            }
            if (!string.IsNullOrEmpty(Settings.Landusedata))
            {
                if (m_LayerDict.ContainsKey(Settings.Landusedata) & (SitingToolUtilities.GetInputFeatureLayer(Settings.Landusedata, pMap) != null))
                {
                    cmbLandusepath.Text = Settings.Landusedata;
                }
            }
            if (!string.IsNullOrEmpty(Settings.Roaddata))
            {
                if (m_LayerDict.ContainsKey(Settings.Roaddata) & (SitingToolUtilities.GetInputFeatureLayer(Settings.Roaddata, pMap) != null))
                {
                    cmbRoadpath.Text = Settings.Roaddata;
                }
            }
            if (!string.IsNullOrEmpty(Settings.Soildata))
            {
                if (m_LayerDict.ContainsKey(Settings.Soildata) & (SitingToolUtilities.GetInputFeatureLayer(Settings.Soildata, pMap) != null))
                {
                    cmbSoilpath.Text = Settings.Soildata;
                }
            }
            if (!string.IsNullOrEmpty(Settings.Streamdata))
            {
                if (m_LayerDict.ContainsKey(Settings.Streamdata) & (SitingToolUtilities.GetInputFeatureLayer(Settings.Streamdata, pMap) != null))
                {
                    cmbStreampath.Text = Settings.Streamdata;
                }
            }
            if (!string.IsNullOrEmpty(Settings.Imperviousdata))
            {
                if (m_LayerDict.ContainsKey(Settings.Imperviousdata) & (SitingToolUtilities.GetInputFeatureLayer(Settings.Imperviousdata, pMap) != null))
                {
                    cmbImp.Text = Settings.Imperviousdata;
                }
            }
            if (!string.IsNullOrEmpty(Settings.WTdata))
            {
                if (m_LayerDict.ContainsKey(Settings.WTdata) & (SitingToolUtilities.GetInputFeatureLayer(Settings.WTdata, pMap) != null))
                {
                    cmbWTPath.Text = Settings.WTdata;
                }
            }
            if (!string.IsNullOrEmpty(Settings.SoilTable))
            {
                if (m_LayerDict.ContainsKey(Settings.SoilTable) & (SitingToolUtilities.GetInputTable(Settings.SoilTable, pMap) != null))
                {
                    cmbSoil_lk.Text = Settings.SoilTable;
                }
            }
            if (!string.IsNullOrEmpty(Settings.RasterLanduseTable))
            {
                if (m_LayerDict.ContainsKey(Settings.RasterLanduseTable) & (SitingToolUtilities.GetInputTable(Settings.RasterLanduseTable, pMap) != null))
                {
                    cmbMrlc_lk.Text = Settings.RasterLanduseTable;
                }
            }
            if (!string.IsNullOrEmpty(Settings.Landownerdata))
            {
                if (m_LayerDict.ContainsKey(Settings.Landownerdata) & (SitingToolUtilities.GetInputFeatureLayer(Settings.Landownerdata, pMap) != null))
                {
                    cmbLandownerpath.Text = Settings.Landownerdata;

                }
            }
        }
        private void Initialize_List()
		{

			IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
			m_LayerDict = new Dictionary<string, object>();
			
			// add a blank item to all combos....
			cmbLandusepath.Items.Add("");
			cmbRoadpath.Items.Add("");
			cmbSoilpath.Items.Add("");
			cmbStreampath.Items.Add("");
			cmbDEMpath.Items.Add("");
			cmbMRLC.Items.Add("");
			cmbImp.Items.Add("");
			cmbWTPath.Items.Add("");
			cmbSoil_lk.Items.Add("");
			cmbMrlc_lk.Items.Add("");
			cmbLandownerpath.Items.Add("");
			short i = 0;
			ILayer pLayer = null;
			IFeatureLayer pFeatureLayer = null;
			string shapeFieldName = null;
			IFields pFields = null;
			short lngIndex = 0;
			IField pField = null;
			IGeometryDef geomDef = null;
			esriGeometryType geometryType = 0;
			cmbZUnit.Visible = true;
			cmbZUnit.Items.Add("Meter");
			cmbZUnit.Items.Add("Feet");


			for (i = 0; i <= (pMap.LayerCount - 1); i++) 
            {
				pLayer = pMap.Layer[i];

				if (pLayer is IFeatureLayer) 
                {

					pFeatureLayer = (IFeatureLayer)pLayer;
                    if (pFeatureLayer.Valid == true)
                    {
					    cmbRoadpath.Items.Add(pLayer.Name);
					    cmbStreampath.Items.Add(pLayer.Name);
					    cmbRoadpath.Visible = true;
					    cmbStreampath.Visible = true;
                        shapeFieldName = pFeatureLayer.FeatureClass.ShapeFieldName;
                        pFields = pFeatureLayer.FeatureClass.Fields;
                        lngIndex = (short)pFields.FindField(shapeFieldName);
                        pField = pFields.Field[lngIndex];
                        geomDef = pField.GeometryDef;
                        geometryType = geomDef.GeometryType;
                        if ((esriGeometryType)geometryType == esriGeometryType.esriGeometryPolygon)
                        {
                            cmbLandusepath.Items.Add(pLayer.Name);
                            cmbSoilpath.Items.Add(pLayer.Name);
                            cmbLandownerpath.Items.Add(pLayer.Name);
                            cmbWTPath.Items.Add(pLayer.Name);
                            cmbLandusepath.Visible = true;
                            cmbSoilpath.Visible = true;
                            cmbLandownerpath.Visible = true;
                            cmbWTPath.Visible = true;
                        }
                    }
				} 
                else if (pLayer is IRasterLayer) 
                {
					cmbDEMpath.Items.Add(pLayer.Name);
					cmbDEMpath.Visible = true;
					cmbMRLC.Items.Add(pLayer.Name);
					cmbMRLC.Visible = true;
					cmbImp.Items.Add(pLayer.Name);
					cmbImp.Visible = true;
				}
				if (!m_LayerDict.ContainsKey(pLayer.Name)) 
                {
					m_LayerDict.Add(pLayer.Name, pLayer);
				}

			}

			// Now add the Standalone tables......
			IStandaloneTableCollection pStandCol = null;
			pStandCol = (IStandaloneTableCollection)pMap;
			for (i = 0; i <= pStandCol.StandaloneTableCount - 1; i++) {
				if (!m_LayerDict.ContainsKey(pStandCol.StandaloneTable[i].Name)) {
					cmbSoil_lk.Items.Add(pStandCol.StandaloneTable[i].Name);
					cmbMrlc_lk.Items.Add(pStandCol.StandaloneTable[i].Name);
                    if (!m_LayerDict.ContainsKey(pStandCol.StandaloneTable[i].Name))
                    {
						m_LayerDict.Add(pStandCol.StandaloneTable[i].Name, pStandCol.StandaloneTable[i].Table);
					}
				}
			}

			return;

		}


        private void cmdBrowseDEM_Click(object sender, EventArgs e)
        {

            if (Browse_Dataset((datasetType)datasetType.dtRaster, ref cmbDEMpath, m_application))
            {
                return;
            }
        }

        private void cmbDEMpath_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cmbDEMpath.Text == cmbImp.Text | cmbDEMpath.Text == cmbMRLC.Text)
            {
                MessageBox.Show("This layer has been used as other data layer, so it cannot be selected again.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                cmbDEMpath.SelectedIndex = -1;
            }

            _settings.DEMdata = cmbDEMpath.Text;
        }
        public bool Browse_Dataset(datasetType pdatasetType, ref ComboBox pControl, IApplication m_application)
        {
            
            bool returnValue;
            GxDialog pDlg = new GxDialog();
            
            IEnumGxObject pGXSelect;
           
            IGxObject pGxObject;
            IGxDataset pGXDataset;
            IFeatureClass pFeatCls;
            
            IFeatureLayer pFeatLyr;
           
            IGxObjectFilter pObjectFilter = null;
        
            ESRI.ArcGIS.Carto.IActiveView pActiveView = null;
            IMxDocument pMxD = (IMxDocument)m_application.Document;
            IMap pMap = pMxD.FocusMap;
            pActiveView = (IActiveView)pMxD.FocusMap;
            returnValue = false;
            /// set up filters on the files that will be browsed
            pDlg = new GxDialog();
           
            if ((datasetType)pdatasetType == datasetType.dtRaster)
            {
                pObjectFilter = new ESRI.ArcGIS.Catalog.GxFilterRasterDatasets();
            }
            else if ((datasetType)pdatasetType == datasetType.dtFeature)
            {
                pObjectFilter = new GxFilterDatasetsAndLayers();

            }
            else if ((datasetType)pdatasetType == datasetType.dtTable)
            {
                pObjectFilter = new ESRI.ArcGIS.Catalog.GxFilterTables();
            }

            pDlg.AllowMultiSelect = false;
            pDlg.Title = "Select Data";
            pDlg.ObjectFilter = pObjectFilter;

            this.Hide();
            if ((pDlg.DoModalOpen(pActiveView.ScreenDisplay.hWnd, out pGXSelect) == false))
            {
                this.Show();
                return returnValue;
            }
           
            // got a valid selection from the GX Dialog, now extract the feature classes datasets etc.
            // loop through the selection enumeration
            pGXSelect.Reset();
            pGxObject = pGXSelect.Next();

            IRasterLayer pRasterLayer = null;
            ITable pTable = null;
            IStandaloneTable pStTab = null;
            IStandaloneTableCollection pStTabColl = null;
            if (((pGxObject != null)))
            {
                // We handle objects of various types, work out what types we have been handed and then open
                // them up and add a feature layer to handle them
                pGXDataset = (IGxDataset)pGxObject;
                if ((pGxObject is IGxDataset))
                {
                    if ((pGXDataset.Type == esriDatasetType.esriDTFeatureClass))
                    {
                        pFeatCls = (IFeatureClass)pGXDataset.Dataset;
                        if (pFeatCls.FeatureType == esriFeatureType.esriFTSimple)
                        {
                            pFeatLyr = new FeatureLayer();
                            pFeatLyr.FeatureClass = pFeatCls;

                            pFeatLyr.Name = pFeatCls.AliasName;
                            pFeatLyr.Visible = false;
                            pMap.AddLayer(pFeatLyr);
                            returnValue = true;
                            if (pControl.DropDownStyle == System.Windows.Forms.ComboBoxStyle.DropDownList)
                            {
                                pControl.Items.Add(pGxObject.Name);
                            }
                            if ((pGxObject.Name).IndexOf('.') >= 0)
                            {
                                pControl.Text = (pGxObject.Name).Substring(0, (pGxObject.Name).IndexOf('.'));
                            }
                            else
                            {
                                pControl.Text = pGxObject.Name;
                            }
                        }
                    }
                    else if ((pGXDataset.Type == esriDatasetType.esriDTRasterDataset))
                    {
                        pRasterLayer = new RasterLayer();
                        pRasterLayer.CreateFromDataset((IRasterDataset)pGXDataset.Dataset);
                        pMap.AddLayer(pRasterLayer);
                        pMxD.ActiveView.Refresh();
                        returnValue = true;
                        if (pControl.DropDownStyle == System.Windows.Forms.ComboBoxStyle.DropDownList)
                        {
                            pControl.Items.Add(pGxObject.Name);
                        }
                        if ((pGxObject.Name).IndexOf('.') >= 0)
                        {
                            pControl.Text = (pGxObject.Name).Substring(0, (pGxObject.Name).IndexOf('.'));
                        }
                        else
                        {
                            pControl.Text = pGxObject.Name;
                        }
                    }
                    else if ((pGXDataset.Type == esriDatasetType.esriDTTable))
                    {
                        pTable = (ITable)pGXDataset.Dataset;
                        pStTab = new StandaloneTable();
                        pStTab.Table = pTable;
                        pStTabColl = (IStandaloneTableCollection)pMap;
                        pStTabColl.AddStandaloneTable(pStTab);
                        if (pControl.DropDownStyle == System.Windows.Forms.ComboBoxStyle.DropDownList)
                        {
                            pControl.Items.Add(pGxObject.Name);
                        }
                        if ((pGxObject.Name).IndexOf('.') >= 0)
                        {
                            pControl.Text = (pGxObject.Name).Substring(0, (pGxObject.Name).IndexOf('.'));
                        }
                        else
                        {
                            pControl.Text = pGxObject.Name;
                        }
                    }
                }
            }

            this.Show();
            pRasterLayer = null;
            pGXDataset = null;
            return returnValue;
        }

        private void label8_Click(object sender, EventArgs e)
        {

        }

        private void cmdSave_Click(object sender, EventArgs e)
        {
            try
            {
           
                if (!Check_Datasets())
                    return;

                IMxDocument pMxD = (IMxDocument)m_application.Document;
                IMap pMap = pMxD.FocusMap;
                if (!SitingToolUtilities.ValidateDatasets_ST(false, pMap, _settings))
                    return;


                // Write to Source text File......

                SitingToolUtilities.SetDataDirectory_CatchFolder(m_application, _settings);

                if (!SitingToolUtilities.CheckDataPath_LayerName(m_application, _settings))
                    return;    
            
                pMxD = (IMxDocument)m_application.Document;
                pMap = pMxD.FocusMap;
                if (!SitingToolUtilities.CheckSelectedDataProjection(pMap, _settings))   
                    return;
                
                Settings.ApplicationPath = SitingToolUtilities.DefineApplicationPath_ST(m_application);
                if (cmbDEMpath.Text != "")
                {
                    Settings.DEMdata = cmbDEMpath.Text;

                    IRasterLayer pDEMRasterLayer = (IRasterLayer)SitingToolUtilities.GetInputFeatureLayer(Settings.DEMdata, pMap);

                    IRaster pDEMRaster = pDEMRasterLayer.Raster;
                    //Get the raster props
                    IRasterProps pDEMRasterProps = (IRasterProps)pDEMRaster;
                    //Get the raster cell size
                    Settings.CellSize = (pDEMRasterProps.MeanCellSize().X + pDEMRasterProps.MeanCellSize().Y) / 2;
                }
                else
                {
                    Settings.DEMdata = "";
                }
                if (cmbZUnit.Text != "")
                {
                    Settings.ZUnit = cmbZUnit.Text;
                }
                if (cmbMRLC.Text != "")
                {
                    Settings.RasterLanduseData = cmbMRLC.Text;
                }
                else
                {
                    Settings.RasterLanduseData = "";
                }
                if (cmbMrlc_lk.Text != "")
                {
                    Settings.RasterLanduseTable = cmbMrlc_lk.Text;
                }
                else
                {
                    Settings.RasterLanduseTable = "";
                }
                if (cmbImp.Text != "")
                {
                    Settings.Imperviousdata = cmbImp.Text;
                }
                else
                {
                    Settings.Imperviousdata = "";
                }
                if (cmbStreampath.Text != "")
                {
                    Settings.Streamdata = cmbStreampath.Text;
                }
                else
                {
                    Settings.Streamdata = "";
                }
                if (cmbRoadpath.Text != "")
                {
                    Settings.Roaddata = cmbRoadpath.Text;
                }
                else
                {
                    Settings.Roaddata = "";
                }
                if (cmbLandusepath.Text != "")
                {
                    Settings.Landusedata = cmbLandusepath.Text;
                }
                else
                {
                    Settings.Landusedata = "";
                }
                if (cmbWTPath.Text != "")
                {
                    Settings.WTdata = cmbWTPath.Text;
                }
                else
                {
                    Settings.WTdata = "";
                }
                if (cmbSoilpath.Text != "")
                {
                    Settings.Soildata = cmbSoilpath.Text;
                }
                else
                {
                    Settings.Soildata = "";
                }
                if (cmbSoil_lk.Text != "")
                {
                    Settings.SoilTable = cmbSoil_lk.Text;
                }
                else
                {
                    Settings.SoilTable = "";
                }
                if (cmbLandownerpath.Text != "")
                {
                    Settings.Landownerdata = cmbLandownerpath.Text;
                }
                else
                {
                    Settings.Landownerdata = "";
                }

                Settings.SaveSettings(Settings.SitingToolSettingsFile);
            }
            catch (Exception exception)
            {
                MessageBox.Show("Error at FrmDataManagement, cmdSave_Click: " + exception.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at FrmDataManagement, cmdSave_Click: " + exception.Message);
            }
            this.Close();
            return;
        }

        private void cmdBrowseIMP_Click(object sender, EventArgs e)
        {
            if (Browse_Dataset(datasetType.dtRaster, ref cmbImp, m_application))
                return;

            return;
        }

        private void cmdBrowseMRLC_Click(object sender, EventArgs e)
        {
            if (Browse_Dataset(datasetType.dtRaster, ref cmbMRLC, m_application))
                return;

            return;
        }

        private void cmdBrowseMrlc_lk_Click(object sender, EventArgs e)
        {
            if (Browse_Dataset(datasetType.dtTable, ref cmbMrlc_lk, m_application))
                return;

            return;
        }

        private void cmdBrowseRoad_Click(object sender, EventArgs e)
        {
            if (Browse_Dataset(datasetType.dtFeature, ref cmbRoadpath, m_application))
                return;

            return;
        }

        private void cmdBrowseStream_Click(object sender, EventArgs e)
        {
            if (Browse_Dataset(datasetType.dtFeature, ref cmbStreampath, m_application))
                return;

            return;
        }

        private void cmdBrowseSoil_Click(object sender, EventArgs e)
        {
            if (Browse_Dataset(datasetType.dtFeature, ref cmbSoilpath, m_application))
            {
                
                _settings.Soildata = cmbSoilpath.Text;
                _settings.SaveSettings(_settings.SitingToolSettingsFile);
            }
            return;
        }

        private void cmdBrowselanduse_Click(object sender, EventArgs e)
        {
            if (Browse_Dataset(datasetType.dtFeature, ref cmbLandusepath, m_application))
                return;

            return;
        }

        private void cmdBrowseWT_Click(object sender, EventArgs e)
        {
            if (Browse_Dataset(datasetType.dtFeature, ref cmbWTPath, m_application))
                return;

            return;
        }

        private void cmdBrowseSoil_lk_Click(object sender, EventArgs e)
        {
            if (Browse_Dataset(datasetType.dtTable, ref cmbSoil_lk, m_application))
            {
                
                _settings.SoilTable = cmbSoil_lk.Text;
                _settings.SaveSettings(_settings.SitingToolSettingsFile);
            }
            return;
        }

        private void cmdLandowner_Click(object sender, EventArgs e)
        {
            if (Browse_Dataset(datasetType.dtFeature, ref cmbLandownerpath, m_application))
                return;

            return;
        }
        private bool Check_Datasets()
        {
            bool returnValue = false;


            returnValue = false;

            if (string.IsNullOrEmpty(cmbDEMpath.Text) & string.IsNullOrEmpty(cmbImp.Text) & string.IsNullOrEmpty(cmbMRLC.Text) & string.IsNullOrEmpty(cmbStreampath.Text) & string.IsNullOrEmpty(cmbRoadpath.Text) & string.IsNullOrEmpty(cmbLandusepath.Text) & string.IsNullOrEmpty(cmbWTPath.Text) & string.IsNullOrEmpty(cmbSoilpath.Text) & string.IsNullOrEmpty(cmbLandownerpath.Text))
            {
                MessageBox.Show("Please select at least one data layer.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return returnValue;
            }

            /// MRLC
            if (!string.IsNullOrEmpty(cmbMRLC.Text) & string.IsNullOrEmpty(cmbMrlc_lk.Text))
            {
                MessageBox.Show("Please select land use lookup table.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return returnValue;
            }
            if (string.IsNullOrEmpty(cmbMRLC.Text) & !string.IsNullOrEmpty(cmbMrlc_lk.Text))
            {
                MessageBox.Show("Please select land use data layer.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return returnValue;
            }

            //SOIL
            if (!string.IsNullOrEmpty(cmbSoilpath.Text) & string.IsNullOrEmpty(cmbSoil_lk.Text))
            {
                MessageBox.Show("Please select Soil lookup table.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return returnValue;
            }
            if (string.IsNullOrEmpty(cmbSoilpath.Text) & !string.IsNullOrEmpty(cmbSoil_lk.Text))
            {
                MessageBox.Show("Please select soil data layer.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return returnValue;
            }

            if (!string.IsNullOrEmpty(cmbDEMpath.Text))
            {
                if (cmbDEMpath.Text.Length > 13)
                {
                    MessageBox.Show("The name of DEM raster layer cannot be longer than 13 characters.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    return returnValue;
                }
            }
            if (!string.IsNullOrEmpty(cmbImp.Text))
            {
                if (cmbImp.Text.Length > 13)
                {
                    MessageBox.Show("The name of Impervious raster layer cannot be longer than 13 characters.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    return returnValue;
                }
            }
            if (!string.IsNullOrEmpty(cmbMRLC.Text))
            {
                if (cmbMRLC.Text.Length > 13)
                {
                    MessageBox.Show("The name of land use raster layer cannot be longer than 13 characters.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    return returnValue;
                }
            }


            returnValue = true;

            return returnValue;

        }

        private void cmbZUnit_SelectedIndexChanged(object sender, EventArgs e)
        {
            _settings.ZUnit = cmbZUnit.Text;
            _settings.SaveSettings(_settings.SitingToolSettingsFile);
        }

        private void cmbMRLC_SelectedIndexChanged(object sender, EventArgs e)
        {

            if (cmbMRLC.Text == cmbImp.Text | cmbMRLC.Text == cmbDEMpath.Text)
            {
                MessageBox.Show("This layer has been used as other data layer, so it cannot be selected again.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                cmbMRLC.SelectedIndex = -1;
            }

            _settings.RasterLanduseData = cmbMRLC.Text;
            _settings.SaveSettings(_settings.SitingToolSettingsFile);
        }

        private void cmbLandusepath_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cmbSoilpath.Text == cmbLandusepath.Text | cmbWTPath.Text == cmbLandusepath.Text | cmbStreampath.Text == cmbLandusepath.Text | cmbRoadpath.Text == cmbLandusepath.Text | cmbLandownerpath.Text == cmbLandusepath.Text)
            {
                MessageBox.Show("This layer has been used as other data layer, so it cannot be selected again.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                cmbLandusepath.SelectedIndex = -1;
            }

            _settings.Landusedata = cmbLandusepath.Text;
            _settings.SaveSettings(_settings.SitingToolSettingsFile);
        }

        private void cmdCancel_Click(object sender, EventArgs e)
        {
            this.Close();

        }

        private void cmbRoadpath_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cmbSoilpath.Text == cmbRoadpath.Text | cmbWTPath.Text == cmbRoadpath.Text | cmbStreampath.Text == cmbRoadpath.Text | cmbLandusepath.Text == cmbRoadpath.Text | cmbLandownerpath.Text == cmbRoadpath.Text)
            {
                MessageBox.Show("This layer has been used as other data layer, so it cannot be selected again.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                cmbRoadpath.SelectedIndex = -1;
            }

            _settings.Roaddata = cmbRoadpath.Text;
            _settings.SaveSettings(_settings.SitingToolSettingsFile);
        }

        private void cmbStreampath_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cmbSoilpath.Text == cmbStreampath.Text | cmbWTPath.Text == cmbStreampath.Text | cmbRoadpath.Text == cmbStreampath.Text | cmbLandusepath.Text == cmbStreampath.Text | cmbLandownerpath.Text == cmbStreampath.Text)
            {
                MessageBox.Show("This layer has been used as other data layer, so it cannot be selected again.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                cmbStreampath.SelectedIndex = -1;
            }

            _settings.Streamdata = cmbStreampath.Text;
            _settings.SaveSettings(_settings.SitingToolSettingsFile);
        }

        private void cmbWTPath_SelectedIndexChanged(object sender, EventArgs e)
        {

            if (cmbSoilpath.Text == cmbWTPath.Text | cmbStreampath.Text == cmbWTPath.Text | cmbRoadpath.Text == cmbWTPath.Text | cmbLandusepath.Text == cmbWTPath.Text | cmbLandownerpath.Text == cmbWTPath.Text)
            {
                MessageBox.Show("This layer has been used as other data layer, so it cannot be selected again.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                cmbWTPath.SelectedIndex = -1;
            }

            _settings.WTdata = cmbWTPath.Text;
            _settings.SaveSettings(_settings.SitingToolSettingsFile);
        }

        private void cmbSoilpath_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cmbWTPath.Text == cmbSoilpath.Text | cmbStreampath.Text == cmbSoilpath.Text | cmbRoadpath.Text == cmbSoilpath.Text | cmbLandusepath.Text == cmbSoilpath.Text | cmbLandownerpath.Text == cmbSoilpath.Text)
            {
                MessageBox.Show("This layer has been used as other data layer, so it cannot be selected again.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                cmbSoilpath.SelectedIndex = -1;
            }

            _settings.Soildata = cmbSoilpath.Text;
            _settings.SaveSettings(_settings.SitingToolSettingsFile);
        }

        private void cmbSoil_lk_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cmbSoil_lk.Text == cmbMrlc_lk.Text)
            {
                MessageBox.Show("This table has been used at other area, so it cannot be selected again.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                cmbSoil_lk.SelectedIndex = -1;
            }

            _settings.SoilTable = cmbSoil_lk.Text;
            _settings.SaveSettings(_settings.SitingToolSettingsFile);
        }

        private void cmbMrlc_lk_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cmbMrlc_lk.Text == cmbSoil_lk.Text)
            {
                MessageBox.Show("This table has been used at other area, so it cannot be selected again.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                cmbMrlc_lk.SelectedIndex = -1;
            }

            _settings.RasterLanduseTable = cmbMrlc_lk.Text;
            _settings.SaveSettings(_settings.SitingToolSettingsFile);
        }

        private void cmbLandownerpath_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cmbWTPath.Text == cmbLandownerpath.Text | cmbStreampath.Text == cmbLandownerpath.Text | cmbRoadpath.Text == cmbLandownerpath.Text | cmbLandusepath.Text == cmbLandownerpath.Text | cmbSoilpath.Text == cmbLandownerpath.Text)
            {
                MessageBox.Show("This layer has been used as other data layer, so it cannot be selected again.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                cmbLandownerpath.SelectedIndex = -1;
            }

            _settings.Landownerdata = cmbLandownerpath.Text;
            _settings.SaveSettings(_settings.SitingToolSettingsFile);
        }

        private void cmbImp_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cmbImp.Text == cmbMRLC.Text | cmbImp.Text == cmbDEMpath.Text)
            {
                MessageBox.Show("This layer has been used as other data layer, so it cannot be selected again.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                cmbImp.SelectedIndex = -1;
            }

            _settings.Imperviousdata = cmbImp.Text;
            _settings.SaveSettings(_settings.SitingToolSettingsFile);
        }

        private void label3_Click(object sender, EventArgs e)
        {

        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

    }
}
