﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using BMPSitingTool.Utilities;
using BMPSitingTool.Common;
using BMPSitingTool.Classes;

using ESRI.ArcGIS.Framework;
using ESRI.ArcGIS.ADF.BaseClasses;
using ESRI.ArcGIS.ADF.CATIDs;
using ESRI.ArcGIS.ArcMapUI;
using ESRI.ArcGIS.SpatialAnalyst;
using ESRI.ArcGIS.Carto;
using ESRI.ArcGIS.CatalogUI;
using ESRI.ArcGIS.Catalog;
using ESRI.ArcGIS.ArcMap;
using ESRI.ArcGIS.Geodatabase;
using ESRI.ArcGIS.Geometry;

namespace BMPSitingTool.Forms
{

    public partial class FrmSelectBMPTypes : Form
    {
        private SitingToolSettings _settings;
        private BMPCriteria _bMPCriteria;
        private SelectedBMPType _selectedBMPType;
        private IApplication m_application;

        internal SelectedBMPType SelectedBMPType
        {
            get { return _selectedBMPType; }
            set { _selectedBMPType = value; }
        }


        internal BMPCriteria BMPCriteria
        {
            get { return _bMPCriteria; }
            set { _bMPCriteria = value; }
        }

        private List<string> selectedBMPTypeList;
      
        
        public IApplication ArcGISApplication
        {
            set
            {
                m_application = value;
            }
        }
        public SitingToolSettings Settings
        {
            get { return _settings; }
            set { _settings = value; }
        }
        public FrmSelectBMPTypes()
        {
            InitializeComponent();
        }

        private void FrmSelectBMPTypes_Load(object sender, EventArgs e)
        {
            try
            {
                _bMPCriteria.LoadBMPCriteria(_bMPCriteria.SitingToolCriteriaFile);
                ArrayList allBMPType = _bMPCriteria.GetBMPTypeList();
                IEnumerator allBMPTypeEnumerator = allBMPType.GetEnumerator();

                _selectedBMPType.LoadSelectedBMPList(_selectedBMPType.SelectBMPTypeFile);
                selectedBMPTypeList = _selectedBMPType.SelectedBMP;

                lstBMP.Items.Clear();
                lstBMPSel.Items.Clear();
                lstBMP.View = View.Details;
                lstBMP.Columns.Add("Name");
                lstBMP.Columns[0].Width = lstBMP.Width - 4;
                lstBMP.HeaderStyle = ColumnHeaderStyle.None;

                lstBMPSel.View = View.Details;
                lstBMPSel.Columns.Add("Name");
                lstBMPSel.Columns[0].Width = lstBMPSel.Width - 4;
                lstBMPSel.HeaderStyle = ColumnHeaderStyle.None;
                while (allBMPTypeEnumerator.MoveNext())
                {
                    lstBMP.Items.Add(allBMPTypeEnumerator.Current.ToString(), allBMPTypeEnumerator.Current.ToString(), "");

                }
                /// Now Fill the selected BMP list in the Listbox....
                if (selectedBMPTypeList != null)
                {
                    foreach (string selectedKey in selectedBMPTypeList)
                    {
                        lstBMPSel.Items.Add(selectedKey, selectedKey, "");
                        ListViewItem lstItem = lstBMP.FindItemWithText(selectedKey);
                        lstBMP.Items.RemoveAt(lstItem.Index);
                    }
                }
                
                lstBMP.Sorting = SortOrder.Ascending;
                lstBMP.Sort();
                lstBMPSel.Sorting = SortOrder.Ascending;
                lstBMPSel.Sort();
            }
            catch (Exception exception)
            {
                MessageBox.Show("ERROR in FrmSelectBMPTypes_Load: " + exception.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);

                Logger.WriteToLog(SitingToolBar.LOGFILE, "ERROR in FrmSelectBMPTypes_Load: " + exception.Message + "\n" + exception.StackTrace);
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            ArrayList oColItems = null;
            oColItems = new ArrayList();
            ///Collect the Items........
            foreach (ListViewItem lstItem in lstBMP.Items)
            {

                if (lstItem.Selected == true)
                {
                    oColItems.Add(lstItem.Text);
                }
            }
            ///Remove the Items........
            System.Collections.IEnumerator myEnumerator = oColItems.GetEnumerator();
            while ( myEnumerator.MoveNext() )
            {

                lstBMPSel.Items.Add(myEnumerator.Current.ToString(), myEnumerator.Current.ToString(), "");
                lstBMP.Items.RemoveByKey(myEnumerator.Current.ToString());
            }
            lstBMP.Sorting = SortOrder.Ascending;
            lstBMP.Sort();
            lstBMPSel.Sorting = SortOrder.Ascending;
            lstBMPSel.Sort();
            return;
        }
        private void cmdSave_Click(object sender, EventArgs e)
        {
            try
            {
                List<string> selectedBMPList = new List<string>();
                foreach (ListViewItem bMPTypes in lstBMPSel.Items)
                {
                    selectedBMPList.Add(bMPTypes.Text);

                }
                if (selectedBMPList.Count == 0)
                {
                    MessageBox.Show("Please select at least one BMP.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                else
                {
                    _selectedBMPType.SelectedBMP = selectedBMPList;
                    _selectedBMPType.SaveSelectedBMPList(_selectedBMPType.SelectBMPTypeFile);
                    this.Close();
                }
            }
            catch (Exception exception)
            {
                MessageBox.Show("Error at FrmSelectBMPTypes, cmdSave_Click: " + exception.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at FrmSelectBMPTypes, cmdSave_Click: " + exception.Message);
            }
        }

        private void lstBMPSel_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void cmdDel_Click(object sender, EventArgs e)
        {
            ArrayList oColItems = null;
            oColItems = new ArrayList();

            ///Collect the Items........
            foreach (ListViewItem lstItem in lstBMPSel.Items)
            {

                if (lstItem.Selected == true)
                {
                    oColItems.Add(lstItem.Text);
                }
            }
            //Remove the Items........
            System.Collections.IEnumerator myEnumerator = oColItems.GetEnumerator();
            while (myEnumerator.MoveNext())
            {

                lstBMP.Items.Add(myEnumerator.Current.ToString(), myEnumerator.Current.ToString(),"");
                lstBMPSel.Items.RemoveByKey(myEnumerator.Current.ToString());
            }
            lstBMP.Sorting = SortOrder.Ascending;
            lstBMP.Sort();
            lstBMPSel.Sorting = SortOrder.Ascending;
            lstBMPSel.Sort();


        }

        private void button1_Click_1(object sender, EventArgs e)
        {
            this.Close();
        }

        private void lstBMP_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

    }
}
