﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using BMPSitingTool.Utilities;
using BMPSitingTool.Common;
using BMPSitingTool.Classes;

using ESRI.ArcGIS.Framework;
using ESRI.ArcGIS.ADF.BaseClasses;
using ESRI.ArcGIS.ADF.CATIDs;
using ESRI.ArcGIS.ArcMapUI;
using ESRI.ArcGIS.SpatialAnalyst;
using ESRI.ArcGIS.Carto;
using ESRI.ArcGIS.CatalogUI;
using ESRI.ArcGIS.Catalog;
using ESRI.ArcGIS.ArcMap;
using ESRI.ArcGIS.Geodatabase;
using ESRI.ArcGIS.Geometry;

namespace BMPSitingTool.Forms
{
    public partial class FrmWeightCriteria : Form
    {

        private BMPCriteria _bMPCriteria;
        private IApplication m_application;
        private Boolean isHSG;
        private string bMPType;
        FrmBMPSitingCriteria _frmBMPSitingCriteria;

        public Boolean IsHSG
        {
            get { return isHSG; }
            set { isHSG = value; }
        }


        public string BMPType
        {
            get { return bMPType; }
            set { bMPType = value; }
        }

        internal BMPCriteria BMPCriteria
        {
            get { return _bMPCriteria; }
            set { _bMPCriteria = value; }
        }
        public FrmWeightCriteria()
        {
            InitializeComponent();
        }
        public FrmWeightCriteria(FrmBMPSitingCriteria frmBMPSitingCriteria)
        {
            _frmBMPSitingCriteria = frmBMPSitingCriteria;
            InitializeComponent();
        }
        private void WriteCriteriaWeightText()
        {
            BMPobj oBMP = _bMPCriteria.GetOneBMP(bMPType);
            string cwText = null;
            cwText = "";

            if (!string.IsNullOrEmpty(criteria0.Text) & !string.IsNullOrEmpty(weight0.Text))
            {
                if (!isHSG)
                    cwText = cwText + criteria0.Text + ":" + weight0.Text + ";";
                else
                    cwText = cwText + (criteria0.Text).ToUpper() + ":" + weight0.Text.ToUpper() + ";";
            }
            if (!string.IsNullOrEmpty(criteria1.Text) & !string.IsNullOrEmpty(weight1.Text))
            {
                if (!isHSG)
                    cwText = cwText + criteria1.Text + ":" + weight1.Text + ";";
                else
                    cwText = cwText + (criteria1.Text).ToUpper() + ":" + weight1.Text.ToUpper() + ";";
            }
            if (!string.IsNullOrEmpty(criteria2.Text) & !string.IsNullOrEmpty(weight2.Text))
            {
                if (!isHSG)
                    cwText = cwText + criteria2.Text + ":" + weight2.Text + ";";
                else
                    cwText = cwText + (criteria2.Text).ToUpper() + ":" + weight2.Text.ToUpper() + ";";
            }
            if (!string.IsNullOrEmpty(criteria3.Text) & !string.IsNullOrEmpty(weight3.Text))
            {
                if (!isHSG)
                    cwText = cwText + criteria3.Text + ":" + weight3.Text + ";";
                else
                    cwText = cwText + (criteria3.Text).ToUpper() + ":" + weight3.Text.ToUpper() + ";";
            }


            if ((cwText).Length > 0)
            {
                cwText = cwText.Substring(0, cwText.Length-1);
            }



            if (!isHSG)
            {
                if (chkCriteria.CheckState == CheckState.Checked)
                {
                    oBMP.DC_DS_Weight_State = "1";
                }
                else
                {
                    oBMP.DC_DS_Weight_State = "0";
                }

                oBMP.DC_DS_Weight = cwText;

            }
            else 
            {
                if (chkCriteria.CheckState == CheckState.Checked)
                {
                    oBMP.DC_HG_Weight_State = "1";
                }
                else
                {
                    oBMP.DC_HG_Weight_State = "0";
                }
                
                oBMP.DC_HG_Weight = cwText;

                _bMPCriteria.SetOneBMP(bMPType, oBMP);
            }

            return;

        }

        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                if (chkCriteria.CheckState == CheckState.Checked) {
                    if (!string.IsNullOrEmpty(criteria0.Text) & !string.IsNullOrEmpty(weight0.Text))
                    {
                        if ((Convert.ToInt16(weight0.Text) < 0) | (Convert.ToInt16(weight0.Text) > 10))
                        {
                            weight0.Focus();
                            MessageBox.Show(this, "Weight value should be 0-10.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Error);
                            return;
                        }
                    }
                    if (!string.IsNullOrEmpty(criteria1.Text) & !string.IsNullOrEmpty(weight1.Text))
                    {
                        if ((Convert.ToInt16(weight1.Text) < 0) | (Convert.ToInt16(weight1.Text) > 10))
                        {
                            weight1.Focus();
                            MessageBox.Show(this, "Weight value should be 0-10.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Error);
                            return;
                        }
                    }
                    if (!string.IsNullOrEmpty(criteria2.Text) & !string.IsNullOrEmpty(weight2.Text))
                    {
                        if ((Convert.ToInt16(weight2.Text) < 0) | (Convert.ToInt16(weight2.Text) > 10))
                        {
                            weight2.Focus();
                            MessageBox.Show(this, "Weight value should be 0-10.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Error);
                            return;
                        }
                    }
                    if (!string.IsNullOrEmpty(criteria3.Text) & !string.IsNullOrEmpty(weight3.Text))
                    {
                        if ((Convert.ToInt16(weight3.Text) < 0) | (Convert.ToInt16(weight3.Text) > 10))
                        {
                            weight3.Focus();
                            MessageBox.Show(this, "Weight value should be 0-10.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Error);
                            return;
                        }
                    }
			    }
            
                if (isHSG)
                {
                    if (chkCriteria.CheckState == CheckState.Checked)
                    {
                        _frmBMPSitingCriteria.CriteriaStored_HG_Visible = true;
                        _frmBMPSitingCriteria.OpenCriteriaWeight_HG_Visible = false;
                    }
                    else
                    {
                        _frmBMPSitingCriteria.CriteriaStored_HG_Visible = false;
                        _frmBMPSitingCriteria.OpenCriteriaWeight_HG_Visible = true;
                    }               
                }
                else
                {
                    if (chkCriteria.CheckState == CheckState.Checked)
                    {
                        _frmBMPSitingCriteria.CriteriaStored_DS_Visible = true;
                        _frmBMPSitingCriteria.OpenCriteriaWeight_DS_Visible = false;
                    }
                    else
                    {
                        _frmBMPSitingCriteria.CriteriaStored_DS_Visible = false;
                        _frmBMPSitingCriteria.OpenCriteriaWeight_DS_Visible = true;
                    }
                }

                WriteCriteriaWeightText();
            }
            catch (Exception exception)
            {
                MessageBox.Show(this, "Error at FrmWeightCriteria, button1_Click: " + exception.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at FrmWeightCriteria, button1_Click: " + exception.Message);
            }
            this.Close();
        }
        private void Populate_Criteria_Weight()
        {

            string allCriteria = null;
            string[] criteriaItems = null;
            string[] criteriaItem = null;
            int itemLen = 0;
            BMPobj oBMPLocal = _bMPCriteria.GetOneBMP(bMPType);
            switch (isHSG)
            {

                case false:
                    if (!string.IsNullOrEmpty(oBMPLocal.DC_DS_Weight))
                    {
                        allCriteria = oBMPLocal.DC_DS_Weight;
                    }
                    break;
                case true:
                    if (!string.IsNullOrEmpty(oBMPLocal.DC_HG_Weight))
                    {
                        allCriteria = oBMPLocal.DC_HG_Weight;
                    }
                    break;
                default:
                    allCriteria = "";
                    break;
            }

            criteriaItems = allCriteria.Split(';');
            itemLen = criteriaItems.GetUpperBound(0) - criteriaItems.GetLowerBound(0) + 1;

            if (itemLen > 0)
            {
                criteriaItem = criteriaItems[0].Split(':');
                criteria0.Text = criteriaItem[0];
                weight0.Text = criteriaItem[1];
            }
            if (itemLen > 1)
            {
                criteriaItem = criteriaItems[1].Split(':');
                criteria1.Text = criteriaItem[0];
                weight1.Text = criteriaItem[1];
            }
            if (itemLen > 2)
            {
                criteriaItem = criteriaItems[2].Split(':');
                criteria2.Text = criteriaItem[0];
                weight2.Text = criteriaItem[1];
            }
            if (itemLen > 3)
            {
                criteriaItem = criteriaItems[3].Split(':');
                criteria3.Text = criteriaItem[0];
                weight3.Text = criteriaItem[1];
            }
            return;

        }
        private void FrmWeightCriteria_Load(object sender, EventArgs e)
        {

            BMPobj oBMP = _bMPCriteria.GetOneBMP(bMPType);
            switch (isHSG)
            {
                case false:
                    if (oBMP.DC_DS_Weight_State == "1")
                    {
                        chkCriteria.CheckState = System.Windows.Forms.CheckState.Checked;
                    }
                    else
                    {
                        chkCriteria.CheckState = System.Windows.Forms.CheckState.Unchecked;
                    }
                    toolTip1.SetToolTip(criteria0, "<5");
                    toolTip1.SetToolTip(criteria1, "<10");
                    toolTip1.SetToolTip(criteria2, "<15");
                    toolTip1.SetToolTip(criteria3, ">=15");
                    break;

                case true:
                    if (oBMP.DC_HG_Weight_State == "1")
                    {
                        chkCriteria.CheckState = System.Windows.Forms.CheckState.Checked;
                    }
                    else
                    {
                        chkCriteria.CheckState = System.Windows.Forms.CheckState.Unchecked;
                    }
                    criteria0.ReadOnly = true;
                    criteria1.ReadOnly = true;
                    criteria2.ReadOnly = true;
                    criteria3.ReadOnly = true;
                    break;
            }

            Populate_Criteria_Weight();


        }
        private void criteria0_TextChanged(object sender, EventArgs e)
        {

        }

        private void chkCriteria_CheckedChanged(object sender, EventArgs e)
        {

        }


    }
}
