using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.IO;
using System.Windows.Forms;
using ESRI.ArcGIS.ADF.BaseClasses;
using ESRI.ArcGIS.ADF.CATIDs;
using ESRI.ArcGIS.Framework;
using ESRI.ArcGIS.ArcMapUI;
using ESRI.ArcGIS.CatalogUI;
using ESRI.ArcGIS.Catalog;
using ESRI.ArcGIS.ArcMap;
using ESRI.ArcGIS.Geodatabase;
using ESRI.ArcGIS.Carto;
using BMPSitingTool.Forms;
using BMPSitingTool.Utilities;
using BMPSitingTool.Common;
using BMPSitingTool.Classes;

namespace BMPSitingTool.MenuItems
{
    /// <summary>
    /// Summary description for Command1.
    /// </summary>
    [Guid("44a9269b-9a2b-4113-9d7c-b3375bd6c694")]
    [ClassInterface(ClassInterfaceType.None)]
    [ProgId("BMPSitingTool.MenuItems.BMPSitingCriteria")]
    public sealed class BMPSitingCriteria : BaseCommand
    {
        #region COM Registration Function(s)
        [ComRegisterFunction()]
        [ComVisible(false)]
        static void RegisterFunction(Type registerType)
        {
            // Required for ArcGIS Component Category Registrar support
            ArcGISCategoryRegistration(registerType);

            //
            // TODO: Add any COM registration code here
            //
        }

        [ComUnregisterFunction()]
        [ComVisible(false)]
        static void UnregisterFunction(Type registerType)
        {
            // Required for ArcGIS Component Category Registrar support
            ArcGISCategoryUnregistration(registerType);

            //
            // TODO: Add any COM unregistration code here
            //
        }

        #region ArcGIS Component Category Registrar generated code
        /// <summary>
        /// Required method for ArcGIS Component Category registration -
        /// Do not modify the contents of this method with the code editor.
        /// </summary>
        private static void ArcGISCategoryRegistration(Type registerType)
        {
            string regKey = string.Format("HKEY_CLASSES_ROOT\\CLSID\\{{{0}}}", registerType.GUID);
            MxCommands.Register(regKey);

        }
        /// <summary>
        /// Required method for ArcGIS Component Category unregistration -
        /// Do not modify the contents of this method with the code editor.
        /// </summary>
        private static void ArcGISCategoryUnregistration(Type registerType)
        {
            string regKey = string.Format("HKEY_CLASSES_ROOT\\CLSID\\{{{0}}}", registerType.GUID);
            MxCommands.Unregister(regKey);

        }

        #endregion
        #endregion
        private FrmBMPSitingCriteria m_frmBMPSitingCriteria;
        private SitingToolSettings _settings = null;
        private BMPCriteria _bMPCriteria = null;
        private SelectedBMPType _selectedBMPType = null;

        private IApplication m_application;

        public BMPSitingCriteria()
        {
            //
            // TODO: Define values for the public properties
            //
            base.m_category = "BMP Siting Criteria"; //localizable text
            base.m_caption = "BMP Siting Criteria";  //localizable text
            //base.m_message = "BMP Siting Criteria";  //localizable text 
            //base.m_toolTip = "BMP Siting Criteria";  //localizable text 
            base.m_name = "BMPSitingCriteria";   //unique id, non-localizable 

            try
            {
                //
                // TODO: change bitmap name if necessary
                //
                string bitmapResourceName = GetType().Name + ".bmp";
                base.m_bitmap = new Bitmap(GetType(), bitmapResourceName);
            }
            catch (Exception ex)
            {
                System.Diagnostics.Trace.WriteLine(ex.Message, "Invalid Bitmap");
            }
        }

        #region Overridden Class Methods

        /// <summary>
        /// Occurs when this command is created
        /// </summary>
        /// <param name="hook">Instance of the application</param>
        public override void OnCreate(object hook)
        {
            if (hook == null)
                return;

            m_application = hook as IApplication;

            //Disable if it is not ArcMap
            if (hook is IMxApplication)
                base.m_enabled = true;
            else
                base.m_enabled = false;

            // TODO:  Add other initialization code
        }

        public override bool Enabled
        {
            get
            {
                string applicationPath = SitingToolUtilities.DefineApplicationPath_ST(m_application);
                if (File.Exists(Path.GetDirectoryName(applicationPath) + "\\" + BMPSitingTool.Resource.SelectedBMP + Resource.XMLFileExt))
                    return true;
                else
                    return false;
            }
        }
        /// <summary>
        /// Occurs when this command is clicked
        /// </summary>
        public override void OnClick()
        {
            // TODO: Add Command1.OnClick implementation

            if (!SitingToolUtilities.CheckMapDocumentSavedStatus_ST(m_application))
            {
                return;
            }

            string applicationPath = SitingToolUtilities.DefineApplicationPath_ST(m_application);
            String logFile = applicationPath + Resource.LogFileName + Resource.XMLFileExt;
            // Set the Selected BMP type
            _selectedBMPType = new SelectedBMPType(applicationPath);
            if (File.Exists(_selectedBMPType.SelectBMPTypeFile))
            {
                _selectedBMPType.LoadSelectedBMPList(_selectedBMPType.SelectBMPTypeFile);
            }
            else
            {
                Logger.WriteToLog(SitingToolBar.LOGFILE, "Select BMP types: Selected BMP Type file does not exist. A new Selected BMP Type file was created");
                _selectedBMPType.SaveSelectedBMPList(_selectedBMPType.SelectBMPTypeFile);
            }
            if (_selectedBMPType.SelectedBMP.Count == 0)
            {
                MessageBox.Show("Please select at least one BMP type to proceed.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                return;
            }

            if (m_frmBMPSitingCriteria == null || m_frmBMPSitingCriteria.IsDisposed)
            {
                m_frmBMPSitingCriteria = new FrmBMPSitingCriteria();
                m_frmBMPSitingCriteria.ArcGISApplication = m_application;
                string iconResourceName = GetType().Name + ".bmp";
                Bitmap pBitmap = new Bitmap(GetType(), iconResourceName);
                IntPtr Hicon = pBitmap.GetHicon();
                Icon pIcon = Icon.FromHandle(Hicon);

                m_frmBMPSitingCriteria.Icon = pIcon;

                try
                {

                    // Set the layername setting file
                    _settings = new SitingToolSettings(applicationPath);// should appear in every Command
                    SitingToolBar.LOGFILE = Logger.GenerateProjectLogFileName(logFile);
                    Logger.WriteToLog(SitingToolBar.LOGFILE, "Select BMP types: loading settings from " + _settings.SitingToolSettingsFile);
                    if (File.Exists(_settings.SitingToolSettingsFile))
                    {
                        _settings.LoadSettings(_settings.SitingToolSettingsFile);
                    }
                    else
                    {
                        Logger.WriteToLog(SitingToolBar.LOGFILE, "Select BMP types: settings file does not exist. A new settings Siting Tool settings file was created");
                        _settings.SaveSettings(_settings.SitingToolSettingsFile);
                    }
                    _settings.LogSettings();

                    // Set the BMP criteria file
                    _bMPCriteria = new BMPCriteria(applicationPath);
                    _bMPCriteria.LoadBMPCriteria(_bMPCriteria.SitingToolCriteriaFile);
                    _bMPCriteria.SaveBMPCriteria(_bMPCriteria.SitingToolCriteriaFile);

                    m_frmBMPSitingCriteria.BMPCriteria = _bMPCriteria;
                    m_frmBMPSitingCriteria.SelectedBMPType = _selectedBMPType;
                    m_frmBMPSitingCriteria.Settings = _settings;

                    CheckSpatialAnalyst checkSpatialAnalyst1 = new CheckSpatialAnalyst();
                    if (checkSpatialAnalyst1.CheckSuccess())
                    {
                        if (!m_frmBMPSitingCriteria.Visible)
                        {
                            m_frmBMPSitingCriteria.TopMost = true;
                            m_frmBMPSitingCriteria.Show();
                        }
                    }
                    else
                    {
                        MessageBox.Show("Spatial analyst not exist.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    }

                }
                catch (Exception exception)
                {
                    MessageBox.Show("Error at MenuItem: BMPSitingCriteria, OnClick: " + exception.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at MenuItem: BMPSitingCriteria, OnClick: " + exception.Message);
                }

                Logger.WriteToLog(SitingToolBar.LOGFILE, "BMPSitingCriteria:  end ");
            }



        #endregion
        }
    }
}
