using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using System.IO;
using ESRI.ArcGIS.ADF.BaseClasses;
using ESRI.ArcGIS.ADF.CATIDs;
using ESRI.ArcGIS.Framework;
using ESRI.ArcGIS.ArcMapUI;
using ESRI.ArcGIS.SpatialAnalyst;
using ESRI.ArcGIS.Carto;
using ESRI.ArcGIS.CatalogUI;
using ESRI.ArcGIS.Catalog;
using ESRI.ArcGIS.ArcMap;
using ESRI.ArcGIS.Geodatabase;
using BMPSitingTool.Forms;
using BMPSitingTool.Utilities;
using BMPSitingTool.Common;
using BMPSitingTool.Classes;

namespace BMPSitingTool.MenuItems
{
    /// <summary>
    /// Summary description for DataManagement.
    /// </summary>
    [Guid("5bdbb3b1-3e65-49d7-ab5d-8049bf6b1834")]
    [ClassInterface(ClassInterfaceType.None)]
    [ProgId("BMPSitingTool.MenuItems.DataManagement")]
    public sealed class DataManagement : BaseCommand
    {
        private FrmDataManagement m_frmDataManagement;
        private SitingToolSettings _settings = null;

        #region COM Registration Function(s)
        [ComRegisterFunction()]
        [ComVisible(false)]
        
        static void RegisterFunction(Type registerType)
        {
            // Required for ArcGIS Component Category Registrar support
            ArcGISCategoryRegistration(registerType);

            //
            // TODO: Add any COM registration code here
            //
        }

        [ComUnregisterFunction()]
        [ComVisible(false)]
        static void UnregisterFunction(Type registerType)
        {
            // Required for ArcGIS Component Category Registrar support
            ArcGISCategoryUnregistration(registerType);

            //
            // TODO: Add any COM unregistration code here
            //
        }

        #region ArcGIS Component Category Registrar generated code
        /// <summary>
        /// Required method for ArcGIS Component Category registration -
        /// Do not modify the contents of this method with the code editor.
        /// </summary>
        private static void ArcGISCategoryRegistration(Type registerType)
        {
            string regKey = string.Format("HKEY_CLASSES_ROOT\\CLSID\\{{{0}}}", registerType.GUID);
            MxCommands.Register(regKey);

        }
        /// <summary>
        /// Required method for ArcGIS Component Category unregistration -
        /// Do not modify the contents of this method with the code editor.
        /// </summary>
        private static void ArcGISCategoryUnregistration(Type registerType)
        {
            string regKey = string.Format("HKEY_CLASSES_ROOT\\CLSID\\{{{0}}}", registerType.GUID);
            MxCommands.Unregister(regKey);

        }

        #endregion
        #endregion

        private IApplication m_application;
        
        public DataManagement()
        {
            //
            // TODO: Define values for the public properties
            //
            base.m_category = "Data Management"; //localizable text
            base.m_caption = "Data Management";  //localizable text
            //base.m_message = "Data Management";  //localizable text 
            //base.m_toolTip = "Data Management";  //localizable text 
            base.m_name = "DataManagement";   //unique id, non-localizable 

            try
            {
                //
                // TODO: change bitmap name if necessary
                //
                string bitmapResourceName = GetType().Name + ".bmp";
                base.m_bitmap = new Bitmap(GetType(), bitmapResourceName);
            }
            catch (Exception ex)
            {
                System.Diagnostics.Trace.WriteLine(ex.Message, "Invalid Bitmap");
            }
        }

        #region Overridden Class Methods

        /// <summary>
        /// Occurs when this command is created
        /// </summary>
        /// <param name="hook">Instance of the application</param>
        public override void OnCreate(object hook)
        {
            if (hook == null)
                return;

            m_application = hook as IApplication;
                      

            //Disable if it is not ArcMap
            if (hook is IMxApplication)
                base.m_enabled = true;
            else
                base.m_enabled = false;

            // TODO:  Add other initialization code

        }


        /// <summary>
        /// Occurs when this command is clicked
        /// </summary>
        public override void OnClick()
        {

            if (!SitingToolUtilities.CheckMapDocumentSavedStatus_ST(m_application))
            {
                return;
            }
            
            if (m_frmDataManagement == null || m_frmDataManagement.IsDisposed)
            {
                m_frmDataManagement = new FrmDataManagement();
                m_frmDataManagement.ArcGISApplication = m_application;
                string iconResourceName = GetType().Name + ".bmp";
                Bitmap pBitmap = new Bitmap(GetType(), iconResourceName);
                IntPtr Hicon = pBitmap.GetHicon();
                Icon pIcon = Icon.FromHandle(Hicon);

                //Icon pIcon = new Icon(iconResourceName);
                m_frmDataManagement.Icon = pIcon;
                string applicationPath = SitingToolUtilities.DefineApplicationPath_ST(m_application);
                String logFile = applicationPath + BMPSitingTool.Resource.LogFileName + Resource.XMLFileExt;
                Logger.WriteToLog(SitingToolBar.LOGFILE, "ProjectLoading:  start ");

                try
                {

                    _settings = new SitingToolSettings(applicationPath);// should appear in every Command

                    SitingToolBar.LOGFILE = Logger.GenerateProjectLogFileName(logFile);
                    Logger.WriteToLog(SitingToolBar.LOGFILE, "ProjectLoading: loading settings from " + _settings.SitingToolSettingsFile);
                    if (File.Exists(_settings.SitingToolSettingsFile))
                    {
                        _settings.LoadSettings(_settings.SitingToolSettingsFile);
                    }
                    else
                    {
                        Logger.WriteToLog(SitingToolBar.LOGFILE, "ProjectLoading: settings file does not exist. A new settings Siting Tool settings file was created");
                        _settings.SaveSettings(_settings.SitingToolSettingsFile);
                    }


                    _settings.LogSettings();

                    m_frmDataManagement.Settings = _settings;
                }
                catch (Exception exception)
                {

                    MessageBox.Show("Error at MenuItem: DataManagement, OnClick: " + exception.Message, BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                    Logger.WriteToLog(BMPSitingTool.SitingToolBar.LOGFILE, "Error at MenuItem: DataManagement, OnClick: " + exception.Message);
                }

                Logger.WriteToLog(SitingToolBar.LOGFILE, "DataManagement:  end ");
            }
            
            CheckSpatialAnalyst checkSpatialAnalyst1 = new CheckSpatialAnalyst();
            if (checkSpatialAnalyst1.CheckSuccess())
            {
                if (!m_frmDataManagement.Visible)
                    m_frmDataManagement.Show();
            }
            else
            {
                MessageBox.Show("Spatial analyst not exist.", Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
        }

        #endregion
    }
}
