using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using System.IO;
using ESRI.ArcGIS.ADF.BaseClasses;
using ESRI.ArcGIS.ADF.CATIDs;
using ESRI.ArcGIS.Framework;
using ESRI.ArcGIS.ArcMapUI;

namespace BMPSitingTool.MenuItems
{
    /// <summary>
    /// Summary description for Help.
    /// </summary>
    [Guid("d3a0488b-9e23-4ed0-a211-abc842b863de")]
    [ClassInterface(ClassInterfaceType.None)]
    [ProgId("BMPSitingTool.MenuItems.Help")]
    public sealed class Help : BaseCommand
    {
        #region COM Registration Function(s)
        [ComRegisterFunction()]
        [ComVisible(false)]
        static void RegisterFunction(Type registerType)
        {
            // Required for ArcGIS Component Category Registrar support
            ArcGISCategoryRegistration(registerType);

            //
            // TODO: Add any COM registration code here
            //
        }

        [ComUnregisterFunction()]
        [ComVisible(false)]
        static void UnregisterFunction(Type registerType)
        {
            // Required for ArcGIS Component Category Registrar support
            ArcGISCategoryUnregistration(registerType);

            //
            // TODO: Add any COM unregistration code here
            //
        }

        #region ArcGIS Component Category Registrar generated code
        /// <summary>
        /// Required method for ArcGIS Component Category registration -
        /// Do not modify the contents of this method with the code editor.
        /// </summary>
        private static void ArcGISCategoryRegistration(Type registerType)
        {
            string regKey = string.Format("HKEY_CLASSES_ROOT\\CLSID\\{{{0}}}", registerType.GUID);
            MxCommands.Register(regKey);

        }
        /// <summary>
        /// Required method for ArcGIS Component Category unregistration -
        /// Do not modify the contents of this method with the code editor.
        /// </summary>
        private static void ArcGISCategoryUnregistration(Type registerType)
        {
            string regKey = string.Format("HKEY_CLASSES_ROOT\\CLSID\\{{{0}}}", registerType.GUID);
            MxCommands.Unregister(regKey);

        }

        #endregion
        #endregion

        private IApplication m_application;
        public Help()
        {
            //
            // TODO: Define values for the public properties
            //
            base.m_category = "Help"; //localizable text
            base.m_caption = "Help";  //localizable text
            //base.m_message = "";  //localizable text 
            //base.m_toolTip = "";  //localizable text 
            base.m_name = "Help";   //unique id, non-localizable (e.g. "MyCategory_ArcMapCommand")

            try
            {
                //
                // TODO: change bitmap name if necessary
                //
                string bitmapResourceName = GetType().Name + ".bmp";
                base.m_bitmap = new Bitmap(GetType(), bitmapResourceName);
            }
            catch (Exception ex)
            {
                System.Diagnostics.Trace.WriteLine(ex.Message, "Invalid Bitmap");
            }
        }

        #region Overridden Class Methods

        /// <summary>
        /// Occurs when this command is created
        /// </summary>
        /// <param name="hook">Instance of the application</param>
        public override void OnCreate(object hook)
        {
            if (hook == null)
                return;

            m_application = hook as IApplication;

            //Disable if it is not ArcMap
            if (hook is IMxApplication)
                base.m_enabled = true;
            else
                base.m_enabled = false;

            // TODO:  Add other initialization code
        }

        /// <summary>
        /// Occurs when this command is clicked
        /// </summary>
        public override void OnClick()
        {
            // TODO: Add Help.OnClick implementation
            string pdfPath = Environment.GetFolderPath(Environment.SpecialFolder.ProgramFilesX86) + "\\" + Resource.BMPSitingTitle + "\\BMPSitingTool_UserGuide.pdf";
            if (!File.Exists(pdfPath))
            {
                MessageBox.Show("The PDF file " + pdfPath + " could not be found.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                return;
            }
            try
            {
                System.Diagnostics.Process.Start(pdfPath);
            }
            catch (Exception e)
            {
                MessageBox.Show("The PDF file  " + pdfPath + " could not be opened.", BMPSitingTool.Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);
                return;
            }
        }
        #endregion
    }
}
