using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.IO;
using System.Windows.Forms;
using ESRI.ArcGIS.ADF.BaseClasses;
using ESRI.ArcGIS.ADF.CATIDs;
using ESRI.ArcGIS.Framework;
using ESRI.ArcGIS.ArcMapUI;
using ESRI.ArcGIS.CatalogUI;
using ESRI.ArcGIS.Catalog;
using ESRI.ArcGIS.ArcMap;
using ESRI.ArcGIS.Geodatabase;
using ESRI.ArcGIS.Carto;
using BMPSitingTool.Forms;
using BMPSitingTool.Utilities;
using BMPSitingTool.Common;
using BMPSitingTool.Classes;

namespace BMPSitingTool.MenuItems
{
    /// <summary>
    /// Summary description for SelectBMPTypes.
    /// </summary>
    [Guid("f068aa20-203c-44ff-b1d7-95059e338284")]
    [ClassInterface(ClassInterfaceType.None)]
    [ProgId("BMPSitingTool.MenuItems.SelectBMPTypes")]
    public sealed class SelectBMPTypes : BaseCommand
    {
        #region COM Registration Function(s)
        [ComRegisterFunction()]
        [ComVisible(false)]
        static void RegisterFunction(Type registerType)
        {
            // Required for ArcGIS Component Category Registrar support
            ArcGISCategoryRegistration(registerType);

            //
            // TODO: Add any COM registration code here
            //
        }

        [ComUnregisterFunction()]
        [ComVisible(false)]
        static void UnregisterFunction(Type registerType)
        {
            // Required for ArcGIS Component Category Registrar support
            ArcGISCategoryUnregistration(registerType);

            //
            // TODO: Add any COM unregistration code here
            //
        }

        #region ArcGIS Component Category Registrar generated code
        /// <summary>
        /// Required method for ArcGIS Component Category registration -
        /// Do not modify the contents of this method with the code editor.
        /// </summary>
        private static void ArcGISCategoryRegistration(Type registerType)
        {
            string regKey = string.Format("HKEY_CLASSES_ROOT\\CLSID\\{{{0}}}", registerType.GUID);
            MxCommands.Register(regKey);

        }
        /// <summary>
        /// Required method for ArcGIS Component Category unregistration -
        /// Do not modify the contents of this method with the code editor.
        /// </summary>
        private static void ArcGISCategoryUnregistration(Type registerType)
        {
            string regKey = string.Format("HKEY_CLASSES_ROOT\\CLSID\\{{{0}}}", registerType.GUID);
            MxCommands.Unregister(regKey);

        }

        #endregion
        #endregion

        private FrmSelectBMPTypes m_frmSelectBMPTypes;
        private SitingToolSettings _settings = null;
        private BMPCriteria _bMPCriteria = null;
        private SelectedBMPType _selectedBMPType = null;

        private IApplication m_application;
        public SelectBMPTypes()
        {
            //
            // TODO: Define values for the public properties
            //
            base.m_category = "Select BMP Types"; //localizable text
            base.m_caption = "Select BMP Types";  //localizable text
            //base.m_message = "Select BMP Types";  //localizable text 
            //base.m_toolTip = "Select BMP Types";  //localizable text 
            base.m_name = "SelectBMPTypes";   //unique id, non-localizable (e.g. "MyCategory_ArcMapCommand")

            try
            {
                //
                // TODO: change bitmap name if necessary

                string bitmapResourceName = GetType().Name + ".bmp";
                base.m_bitmap = new Bitmap(GetType(), bitmapResourceName);

            }
            catch (Exception ex)
            {
                System.Diagnostics.Trace.WriteLine(ex.Message, "Invalid Bitmap");
            }
        }

        #region Overridden Class Methods

        /// <summary>
        /// Occurs when this command is created
        /// </summary>
        /// <param name="hook">Instance of the application</param>
        public override void OnCreate(object hook)
        {
            if (hook == null)
                return;

            m_application = hook as IApplication;

            //Disable if it is not ArcMap
            if (hook is IMxApplication)
                base.m_enabled = true;
            else
                base.m_enabled = false;

            // TODO:  Add other initialization code
        }

        public override bool Enabled
        {
            get
            {
                string applicationPath = SitingToolUtilities.DefineApplicationPath_ST(m_application);
                if (File.Exists(Path.GetDirectoryName(applicationPath) + "\\" + BMPSitingTool.Resource.SitingToolConfig + Resource.XMLFileExt))
                    return true;
                else
                    return false;
            }
        }
        /// <summary>
        /// Occurs when this command is clicked
        /// </summary>
        public override void OnClick()
        {
            // TODO: Add SelectBMPTypes.OnClick implementation

            if (!SitingToolUtilities.CheckMapDocumentSavedStatus_ST(m_application))
            {
                return;
            }
            try
            {
                if (m_frmSelectBMPTypes == null || m_frmSelectBMPTypes.IsDisposed)
                {
                    m_frmSelectBMPTypes = new FrmSelectBMPTypes();
                    m_frmSelectBMPTypes.ArcGISApplication = m_application;
                    string iconResourceName = GetType().Name + ".bmp";
                    Bitmap pBitmap = new Bitmap(GetType(), iconResourceName);
                    IntPtr Hicon = pBitmap.GetHicon();
                    Icon pIcon = Icon.FromHandle(Hicon);

                    //Icon pIcon = new Icon(iconResourceName);
                    m_frmSelectBMPTypes.Icon = pIcon;
                    string applicationPath = SitingToolUtilities.DefineApplicationPath_ST(m_application);
                    String logFile = applicationPath + BMPSitingTool.Resource.LogFileName + Resource.XMLFileExt;
                    Logger.WriteToLog(SitingToolBar.LOGFILE, "Select BMP types:  ");

                    // Set the layername setting file
                    _settings = new SitingToolSettings(applicationPath);// should appear in every Command
                    SitingToolBar.LOGFILE = Logger.GenerateProjectLogFileName(logFile);
                    Logger.WriteToLog(SitingToolBar.LOGFILE, "Select BMP types: loading settings from " + _settings.SitingToolSettingsFile);
                    if (File.Exists(_settings.SitingToolSettingsFile))
                    {
                        _settings.LoadSettings(_settings.SitingToolSettingsFile);
                    }
                    else
                    {
                        Logger.WriteToLog(SitingToolBar.LOGFILE, "Select BMP types: settings file does not exist. A new settings Siting Tool settings file was created");
                        _settings.SaveSettings(_settings.SitingToolSettingsFile);
                    }
                    _settings.LogSettings();

                    // Set the BMP criteria file
                    _bMPCriteria = new BMPCriteria(applicationPath);

                    _bMPCriteria.LoadBMPCriteria(_bMPCriteria.SitingToolCriteriaFile);

                    _bMPCriteria.SaveBMPCriteria(_bMPCriteria.SitingToolCriteriaFile);
                    
                    // Set the Selected BMP type
                    _selectedBMPType = new SelectedBMPType(applicationPath);
                    if (File.Exists(_selectedBMPType.SelectBMPTypeFile))
                    {
                        _selectedBMPType.LoadSelectedBMPList(_selectedBMPType.SelectBMPTypeFile);
                    }
                    else
                    {
                        Logger.WriteToLog(SitingToolBar.LOGFILE, "Select BMP types: Selected BMP Type file does not exist. A new Selected BMP Type file was created");
                        _selectedBMPType.SaveSelectedBMPList(_selectedBMPType.SelectBMPTypeFile);
                    }
                    m_frmSelectBMPTypes.BMPCriteria = _bMPCriteria;
                    m_frmSelectBMPTypes.SelectedBMPType = _selectedBMPType;
                    m_frmSelectBMPTypes.Settings = _settings;

                    Logger.WriteToLog(SitingToolBar.LOGFILE, "SelectBMPTypes:  end ");
                }

                //CheckSpatialAnalyst checkSpatialAnalyst1 = new CheckSpatialAnalyst();

                if (!m_frmSelectBMPTypes.Visible)
                    m_frmSelectBMPTypes.Show();
            }
            catch (Exception e)
            {
                MessageBox.Show("ERROR in MenuItem: SelectBMPTypes, OnClick: " + e.Message, Resource.BMPSitingTitle, MessageBoxButtons.OK, MessageBoxIcon.Information);

                Logger.WriteToLog(SitingToolBar.LOGFILE, "ERROR in MenuItem: SelectBMPTypes, OnClick: " + e.Message + "\n" + e.StackTrace);
            }
        }

        #endregion
    }
}
