using System;
using System.Collections.Generic;
using System.Text;

using System.Runtime.InteropServices;
using ESRI.ArcGIS.ADF.CATIDs;
using ESRI.ArcGIS.ADF.BaseClasses;
using ESRI.ArcGIS.SystemUI;
using ESRI.ArcGIS.ArcMap;
using ESRI.ArcGIS.esriSystem;

using BMPSitingTool.Common;

namespace BMPSitingTool
{
    /// <summary>
    /// Summary description for SitingToolBar.
    /// </summary>
    [Guid("c9af7675-463a-441e-b7cc-d4ed6b7be894")]
    [ClassInterface(ClassInterfaceType.None)]
    [ProgId("BMPSitingTool.SitingToolBar")]
    public sealed class SitingToolBar : BaseToolbar
    {
        public static string LOGFILE = Logger.GenerateDefaultLogFileName("sitingtool");
        #region COM Registration Function(s)
        [ComRegisterFunction()]
        [ComVisible(false)]
        static void RegisterFunction(Type registerType)
        {
            // Required for ArcGIS Component Category Registrar support
            ArcGISCategoryRegistration(registerType);

            //
            // TODO: Add any COM registration code here
            //
        }

        [ComUnregisterFunction()]
        [ComVisible(false)]
        static void UnregisterFunction(Type registerType)
        {
            // Required for ArcGIS Component Category Registrar support
            ArcGISCategoryUnregistration(registerType);

            //
            // TODO: Add any COM unregistration code here
            //
        }

        #region ArcGIS Component Category Registrar generated code
        /// <summary>
        /// Required method for ArcGIS Component Category registration -
        /// Do not modify the contents of this method with the code editor.
        /// </summary>
        private static void ArcGISCategoryRegistration(Type registerType)
        {
            string regKey = string.Format("HKEY_CLASSES_ROOT\\CLSID\\{{{0}}}", registerType.GUID);
            MxCommandBars.Register(regKey);
        }
        /// <summary>
        /// Required method for ArcGIS Component Category unregistration -
        /// Do not modify the contents of this method with the code editor.
        /// </summary>
        private static void ArcGISCategoryUnregistration(Type registerType)
        {
            string regKey = string.Format("HKEY_CLASSES_ROOT\\CLSID\\{{{0}}}", registerType.GUID);
            MxCommandBars.Unregister(regKey);
        }

        #endregion
        #endregion

        public SitingToolBar()
        {


            //Adding a command by ProgID
            string progID = "BMPSitingTool.MenuItems.DataManagement";
            AddItem(progID);
            progID = "BMPSitingTool.MenuItems.SelectBMPTypes";
            AddItem(progID);
            progID = "BMPSitingTool.MenuItems.BMPSitingCriteria";
            AddItem(progID);
            progID = "BMPSitingTool.MenuItems.Help";
            AddItem(progID);

        }

        public override string Caption
        {
            get
            {
                //TODO: Replace bar caption
                return "BMP Siting Tool";
            }
        }
        public override string Name
        {
            get
            {
                //TODO: Replace bar ID
                return "SitingToolBar";
            }
        }
    }
}