using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using ESRI.ArcGIS.esriSystem;


namespace BMPSitingTool.Utilities
{


    [Guid("02879365-60aa-4b87-b3b7-e53329de71c5")]
    [ClassInterface(ClassInterfaceType.None)]
    [ProgId("BMPSitingTool.CheckSpatialAnalyst")]

    public class CheckSpatialAnalyst
    {

        public bool CheckSuccess()
        {

            if (GetSpatialAnalystLicense() == esriLicenseStatus.esriLicenseAlreadyInitialized | GetSpatialAnalystLicense() == esriLicenseStatus.esriLicenseCheckedOut)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        public esriLicenseStatus GetSpatialAnalystLicense()
        {
            //Check out a Spatial Analyst license with the ArcInfo, ArcEditor or ArcView product, also in that order. 

            IAoInitialize pAoInitialize = new AoInitializeClass();
            esriLicenseStatus licenseStatus = esriLicenseStatus.esriLicenseUnavailable;

            esriLicenseProductCode productCode = esriLicenseProductCode.esriLicenseProductCodeAdvanced;
            licenseStatus = pAoInitialize.IsProductCodeAvailable(productCode);
            if (licenseStatus != esriLicenseStatus.esriLicenseAvailable)
            {
                productCode = esriLicenseProductCode.esriLicenseProductCodeStandard;
                licenseStatus = pAoInitialize.IsProductCodeAvailable(productCode);
                if (licenseStatus != esriLicenseStatus.esriLicenseAvailable)
                {
                    productCode = esriLicenseProductCode.esriLicenseProductCodeBasic;
                    licenseStatus = pAoInitialize.IsProductCodeAvailable(productCode);
                    if (licenseStatus != esriLicenseStatus.esriLicenseAvailable)
                    {
                        licenseStatus = esriLicenseStatus.esriLicenseFailure;
                        return licenseStatus;
                    }
                }
            }
            
            //Check the extensionCode. 
            licenseStatus = pAoInitialize.IsExtensionCodeAvailable(productCode,
                esriLicenseExtensionCode.esriLicenseExtensionCodeSpatialAnalyst);
            if (licenseStatus == esriLicenseStatus.esriLicenseAvailable)
            {
                //Initialize the license. 
                licenseStatus = pAoInitialize.Initialize(productCode);
                if ((licenseStatus == esriLicenseStatus.esriLicenseCheckedOut))
                {
                    //Check out the Spatial Analyst extension. 
                    licenseStatus = pAoInitialize.CheckOutExtension(esriLicenseExtensionCode.esriLicenseExtensionCodeSpatialAnalyst);
                }
            }
            return licenseStatus;

        }
    }
}
