# This parses the results from Model Averaging
# and summarizes in a csv file

BEGIN {
  FS = " ";     # Input field separator
  OFS = ",";    # Output field separator
  RS = "\r\n";  # Input record separator
  ORS = "\r\n"; # Output record separator
  iModels = 5;  # Include the header row
  i=0;    # Flag for printing original data results
  iNum=0; # Test file count
  MaxDose=0.0; # Maximum dose from input data
# Set a default output name if not provided as argument
  if (TestName == "") TestName = "ModelAvgSummary";
  FName = TestName "_Summary.csv"
# Some of these columns include spaces; ensure that output
# values are enclosed in ""s
  if (DoHeader != "") {
    # Use j to hold array index so that it's easier to update order without renumbering
    j=0;
    sOut[++j]="Test#"; sOut[++j]="Max dose";
    sOut[++j]="Linear BMD"; sOut[++j]="Linear BMDL"; sOut[++j]="Linear BIC";
    sOut[++j]="Polynomial3 BMD"; sOut[++j]="Polynomial3 BMDL"; sOut[++j]="Polynomial3 BIC";
    sOut[++j]="Power BMD"; sOut[++j]="Power BMDL"; sOut[++j]="Power BIC";
    sOut[++j]="Hill BMD"; sOut[++j]="Hill BMDL"; sOut[++j]="Hill BIC";
    sOut[++j]="Meth1 BMD"; sOut[++j]="Meth1 BMDL"; sOut[++j]="Meth1 msec";
    sOut[++j]="Meth2a BMDL"; sOut[++j]="Meth2a msec";
    sOut[++j]="Meth2b BMDL"; sOut[++j]="Meth2b msec";
    sOut[++j]="Meth2c BMDL"; sOut[++j]="Meth2c msec";
    sOut[++j]="Meth3a BMDL"; sOut[++j]="Meth3a msec";
    sOut[++j]="Meth3b BMDL"; sOut[++j]="Meth3b msec";
    sOut[++j]="Meth3c BMDL"; sOut[++j]="Meth3c msec";
    print join(sOut, 1, j, OFS) > FName ;
    exit
  }
 }

# Find maximum dose to display in first column after test#
/^Original input data:/ {
  # Skip two lines to get to data values
  MyGetLine(); MyGetLine();
  while ($1 != "") {
    MaxDose = $1;
    MyGetLine();
  }
# MaxDose is printed below
}

# Get interesting values from Method 1 results
/^Result of first run \(original data\):/ {
  i=1;
  # get the next record so that next section doesn't redo this one
  MyGetLine();
# Isolate test number to include in output
  iPos = match(FILENAME, /_[0-9][0-9][0-9][0-9]\.log/);
  iNum = substr(FILENAME, iPos+1, 4);
  printf "%04d,%9.8f,", iNum, MaxDose >> FName ;
}

i==1 {
  i++;
  MyGetLine();
}
i>1 && i<= iModels {
  printf "%9.8f,%9.8f,%9.8f,", $3, $4, $5  >> FName ;
  i++;
}

/^METHOD 1 :/ {
  MyGetLine();
  printf "%9.8f,", $4 >> FName ;
  MyGetLine();
  printf "%9.8f,", $4 >> FName ;
  MyGetLine();
  printf "%d,", $3 >> FName ;
  }
/^METHOD 2 :/ {
  MyGetLine();
  printf "%9.8f,", $4 >> FName ;
  MyGetLine();
  printf "%d,", $3 >> FName ;
  MyGetLine();
  printf "%9.8f,", $4 >> FName ;
  MyGetLine();
  printf "%d,", $3 >> FName ;
  MyGetLine();
  printf "%9.8f,", $4 >> FName ;
  MyGetLine();
  printf "%d,", $3 >> FName ;
  }
/^METHOD 3 :/ {
  MyGetLine();
  printf "%9.8f,", $4 >> FName ;
  MyGetLine();
  printf "%d,", $3 >> FName ;
  MyGetLine();
  printf "%9.8f,", $4 >> FName ;
  MyGetLine();
  printf "%d,", $3 >> FName ;
  MyGetLine();
  printf "%9.8f,", $4 >> FName ;
  MyGetLine();
  printf "%d", $3 >> FName ;
}

END {
# Complete output record and close file
  if (DoHeader == "") print "" >> FName ;
  close(FName);
}

function MyGetLine() {
  if (getline <= 0) {
    m = "unexpected EOF or error"
    m = (m ": " ERRNO)
    print m > "/dev/stderr"
    exit
  }
}

# This is a sample function from the gawk info pages
# join.awk --- join an array into a string
function join(array, start, end, sep,    result, i)
{
  if (sep == "")
    sep = " "
  else if (sep == SUBSEP) # magic value
    sep = ""
  result = "\"" array[start] "\""
  for (i = start + 1; i <= end; i++)
    result = result sep "\"" array[i] "\""
  return result
}
