/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.juel;

import com.sun.script.juel.JuelScriptEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JuelScriptEngineFactory
implements ScriptEngineFactory {
    private static List<String> names = new ArrayList<String>(1);
    private static List<String> extensions;
    private static List<String> mimeTypes;

    static {
        names.add("juel");
        names = Collections.unmodifiableList(names);
        extensions = names;
        mimeTypes = new ArrayList<String>(0);
        mimeTypes = Collections.unmodifiableList(mimeTypes);
    }

    @Override
    public String getEngineName() {
        return "juel";
    }

    @Override
    public String getEngineVersion() {
        return "2.1.0-rc2";
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public String getLanguageName() {
        return "JSP 2.1 EL";
    }

    @Override
    public String getLanguageVersion() {
        return "2.1";
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        throw new UnsupportedOperationException("getMethodCallSyntax");
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuilder buf = new StringBuilder();
        buf.append("out:print(\"");
        int len = toDisplay.length();
        int i = 0;
        while (i < len) {
            char ch = toDisplay.charAt(i);
            switch (ch) {
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                default: {
                    buf.append(ch);
                }
            }
            ++i;
        }
        buf.append("\")");
        return buf.toString();
    }

    @Override
    public String getParameter(String key) {
        if (key.equals("javax.script.name")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        return null;
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder buf = new StringBuilder();
        if (statements.length != 0) {
            int i = 0;
            while (i < statements.length) {
                buf.append("${");
                buf.append(statements[i]);
                buf.append("} ");
                ++i;
            }
        }
        return buf.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new JuelScriptEngine(this);
    }
}

