/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.oasis.Style;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;

public class ParagraphStyle
extends Style {
    protected static final String HORIZONTAL_ALIGN_LEFT = "start";
    protected static final String HORIZONTAL_ALIGN_RIGHT = "end";
    protected static final String HORIZONTAL_ALIGN_CENTER = "center";
    protected static final String HORIZONTAL_ALIGN_JUSTIFY = "justified";
    private static final String VERTICAL_ALIGN_TOP = "top";
    private static final String VERTICAL_ALIGN_MIDDLE = "middle";
    private static final String VERTICAL_ALIGN_BOTTOM = "bottom";
    protected static final String ROTATION_ALIGN_NONE = "none";
    protected static final String ROTATION_ALIGN_TOP = "top";
    protected static final String ROTATION_ALIGN_CENTER = "center";
    protected static final String ROTATION_ALIGN_BOTTOM = "bottom";
    private String verticalAlignment;
    private String horizontalAlignment;
    private String runDirection;
    private String textRotation = "0";

    public ParagraphStyle(Writer styleWriter, JRPrintText text) {
        super(styleWriter);
        this.horizontalAlignment = ParagraphStyle.getHorizontalAlignment(text.getHorizontalAlignmentValue(), text.getVerticalAlignmentValue(), text.getRotationValue());
        this.verticalAlignment = ParagraphStyle.getVerticalAlignment(text.getHorizontalAlignmentValue(), text.getVerticalAlignmentValue(), text.getRotationValue());
        switch (text.getRotationValue()) {
            case LEFT: {
                this.textRotation = "90";
                break;
            }
            case RIGHT: {
                this.textRotation = "270";
                break;
            }
            default: {
                this.textRotation = "0";
            }
        }
        this.runDirection = null;
        if (text.getRunDirectionValue() == RunDirectionEnum.RTL) {
            this.runDirection = "rl";
        }
    }

    public static String getVerticalAlignment(HorizontalAlignEnum horizontalAlignment, VerticalAlignEnum verticalAlignment, RotationEnum rotation) {
        switch (rotation) {
            case LEFT: {
                switch (horizontalAlignment) {
                    case RIGHT: {
                        return "top";
                    }
                    case CENTER: {
                        return VERTICAL_ALIGN_MIDDLE;
                    }
                    case JUSTIFIED: {
                        return HORIZONTAL_ALIGN_JUSTIFY;
                    }
                }
                return "bottom";
            }
            case RIGHT: {
                switch (horizontalAlignment) {
                    case RIGHT: {
                        return "bottom";
                    }
                    case CENTER: {
                        return VERTICAL_ALIGN_MIDDLE;
                    }
                    case JUSTIFIED: {
                        return HORIZONTAL_ALIGN_JUSTIFY;
                    }
                }
                return "top";
            }
        }
        switch (verticalAlignment) {
            case BOTTOM: {
                return "bottom";
            }
            case MIDDLE: {
                return VERTICAL_ALIGN_MIDDLE;
            }
        }
        return "top";
    }

    public static String getHorizontalAlignment(HorizontalAlignEnum horizontalAlignment, VerticalAlignEnum verticalAlignment, RotationEnum rotation) {
        switch (rotation) {
            case LEFT: {
                switch (verticalAlignment) {
                    case BOTTOM: {
                        return HORIZONTAL_ALIGN_RIGHT;
                    }
                    case MIDDLE: {
                        return "center";
                    }
                }
                return HORIZONTAL_ALIGN_LEFT;
            }
            case RIGHT: {
                switch (verticalAlignment) {
                    case BOTTOM: {
                        return HORIZONTAL_ALIGN_LEFT;
                    }
                    case MIDDLE: {
                        return "center";
                    }
                }
                return HORIZONTAL_ALIGN_RIGHT;
            }
        }
        switch (horizontalAlignment) {
            case RIGHT: {
                return HORIZONTAL_ALIGN_RIGHT;
            }
            case CENTER: {
                return "center";
            }
            case JUSTIFIED: {
                return HORIZONTAL_ALIGN_JUSTIFY;
            }
        }
        return HORIZONTAL_ALIGN_LEFT;
    }

    public String getId() {
        return this.verticalAlignment + "|" + this.horizontalAlignment + "|" + this.runDirection + "|" + this.textRotation;
    }

    public void write(String paragraphStyleName) throws IOException {
        this.styleWriter.write("<style:style style:name=\"" + paragraphStyleName + "\"");
        this.styleWriter.write(" style:family=\"paragraph\">\n");
        this.styleWriter.write("<style:paragraph-properties");
        this.styleWriter.write(" fo:text-align=\"" + this.horizontalAlignment + "\"");
        this.styleWriter.write(" style:vertical-align=\"" + this.verticalAlignment + "\"");
        if (this.runDirection != null) {
            this.styleWriter.write(" style:writing-mode=\"" + this.runDirection + "\"");
        }
        this.styleWriter.write(">\n");
        this.styleWriter.write("</style:paragraph-properties>\n");
        this.styleWriter.write("<style:text-properties");
        this.styleWriter.write(" style:text-rotation-angle=\"" + this.textRotation + "\"");
        this.styleWriter.write(">\n");
        this.styleWriter.write("</style:text-properties>\n");
        this.styleWriter.write("</style:style>\n");
    }
}

