/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextMeasurerUtil;
import net.sf.jasperreports.engine.util.LineBoxWrapper;
import net.sf.jasperreports.engine.util.MarkupProcessor;
import net.sf.jasperreports.engine.util.MarkupProcessorFactory;

public abstract class JRFillTextElement
extends JRFillElement
implements JRTextElement {
    private static final JRSingletonCache markupProcessorFactoryCache = new JRSingletonCache(MarkupProcessorFactory.class);
    private static final Map markupProcessors = new HashMap();
    private boolean isLeftToRight = true;
    private JRTextMeasurer textMeasurer;
    private float lineSpacingFactor;
    private float leadingOffset;
    private float textHeight;
    private int textStart;
    private int textEnd;
    private short[] lineBreakOffsets;
    private String textTruncateSuffix;
    private String rawText;
    private JRStyledText styledText;
    private Map styledTextAttributesMap = new HashMap();
    protected final JRReportFont reportFont;
    protected final JRLineBox lineBox;

    protected JRFillTextElement(JRBaseFiller filler, JRTextElement textElement, JRFillObjectFactory factory) {
        super(filler, textElement, factory);
        this.reportFont = factory.getReportFont(textElement.getReportFont());
        this.lineBox = textElement.getLineBox().clone(this);
    }

    protected JRFillTextElement(JRFillTextElement textElement, JRFillCloneFactory factory) {
        super(textElement, factory);
        this.reportFont = textElement.reportFont;
        this.lineBox = textElement.getLineBox().clone(this);
    }

    private void createTextMeasurer() {
        this.textMeasurer = JRTextMeasurerUtil.createTextMeasurer(this);
    }

    protected void ensureTextMeasurer() {
        if (this.textMeasurer == null) {
            this.createTextMeasurer();
        }
    }

    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode((JRCommonElement)this, ModeEnum.TRANSPARENT);
    }

    public byte getTextAlignment() {
        return this.getHorizontalAlignment();
    }

    public void setTextAlignment(byte horizontalAlignment) {
        throw new UnsupportedOperationException();
    }

    public byte getHorizontalAlignment() {
        return this.getHorizontalAlignmentValue().getValue();
    }

    public Byte getOwnHorizontalAlignment() {
        return this.getOwnHorizontalAlignmentValue() == null ? null : this.getOwnHorizontalAlignmentValue().getValueByte();
    }

    public HorizontalAlignEnum getHorizontalAlignmentValue() {
        return JRStyleResolver.getHorizontalAlignmentValue(this);
    }

    public HorizontalAlignEnum getOwnHorizontalAlignmentValue() {
        return ((JRTextElement)this.parent).getOwnHorizontalAlignmentValue();
    }

    public void setHorizontalAlignment(byte horizontalAlignment) {
        throw new UnsupportedOperationException();
    }

    public void setHorizontalAlignment(Byte horizontalAlignment) {
        throw new UnsupportedOperationException();
    }

    public void setHorizontalAlignment(HorizontalAlignEnum horizontalAlignment) {
        throw new UnsupportedOperationException();
    }

    public byte getVerticalAlignment() {
        return this.getVerticalAlignmentValue().getValue();
    }

    public Byte getOwnVerticalAlignment() {
        return this.getOwnVerticalAlignmentValue() == null ? null : this.getOwnVerticalAlignmentValue().getValueByte();
    }

    public VerticalAlignEnum getVerticalAlignmentValue() {
        return JRStyleResolver.getVerticalAlignmentValue(this);
    }

    public VerticalAlignEnum getOwnVerticalAlignmentValue() {
        return ((JRTextElement)this.parent).getOwnVerticalAlignmentValue();
    }

    public void setVerticalAlignment(byte verticalAlignment) {
        throw new UnsupportedOperationException();
    }

    public void setVerticalAlignment(Byte verticalAlignment) {
        throw new UnsupportedOperationException();
    }

    public void setVerticalAlignment(VerticalAlignEnum verticalAlignment) {
        throw new UnsupportedOperationException();
    }

    public byte getRotation() {
        return this.getRotationValue().getValue();
    }

    public Byte getOwnRotation() {
        return this.getOwnRotationValue() == null ? null : this.getOwnRotationValue().getValueByte();
    }

    public void setRotation(byte rotation) {
        throw new UnsupportedOperationException();
    }

    public void setRotation(Byte rotation) {
        throw new UnsupportedOperationException();
    }

    public RotationEnum getRotationValue() {
        return JRStyleResolver.getRotationValue(this);
    }

    public RotationEnum getOwnRotationValue() {
        return ((JRTextElement)this.parent).getOwnRotationValue();
    }

    public void setRotation(RotationEnum rotation) {
        throw new UnsupportedOperationException();
    }

    public byte getLineSpacing() {
        return JRStyleResolver.getLineSpacing(this);
    }

    public Byte getOwnLineSpacing() {
        return ((JRTextElement)this.parent).getOwnLineSpacing();
    }

    public void setLineSpacing(byte lineSpacing) {
        throw new UnsupportedOperationException();
    }

    public void setLineSpacing(Byte lineSpacing) {
        throw new UnsupportedOperationException();
    }

    public LineSpacingEnum getLineSpacingValue() {
        return JRStyleResolver.getLineSpacingValue(this);
    }

    public LineSpacingEnum getOwnLineSpacingValue() {
        return ((JRTextElement)this.parent).getOwnLineSpacingValue();
    }

    public void setLineSpacing(LineSpacingEnum lineSpacing) {
        throw new UnsupportedOperationException();
    }

    public boolean isStyledText() {
        return "styled".equals(this.getMarkup());
    }

    public Boolean isOwnStyledText() {
        String mkp = this.getOwnMarkup();
        return "styled".equals(mkp) ? Boolean.TRUE : (mkp == null ? null : Boolean.FALSE);
    }

    public void setStyledText(boolean isStyledText) {
    }

    public void setStyledText(Boolean isStyledText) {
    }

    public String getMarkup() {
        return JRStyleResolver.getMarkup(this);
    }

    public String getOwnMarkup() {
        return ((JRTextElement)this.parent).getOwnMarkup();
    }

    public void setMarkup(String markup) {
    }

    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getPen());
    }

    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getPen());
    }

    public void setBorder(byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.getLineBox().getPen());
    }

    public void setBorder(Byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.getLineBox().getPen());
    }

    public Color getBorderColor() {
        return this.getLineBox().getPen().getLineColor();
    }

    public Color getOwnBorderColor() {
        return this.getLineBox().getPen().getOwnLineColor();
    }

    public void setBorderColor(Color borderColor) {
        this.getLineBox().getPen().setLineColor(borderColor);
    }

    public int getPadding() {
        return this.getLineBox().getPadding();
    }

    public Integer getOwnPadding() {
        return this.getLineBox().getOwnPadding();
    }

    public void setPadding(int padding) {
        this.getLineBox().setPadding(padding);
    }

    public void setPadding(Integer padding) {
        this.getLineBox().setPadding(padding);
    }

    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getTopPen());
    }

    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getTopPen());
    }

    public void setTopBorder(byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.getLineBox().getTopPen());
    }

    public void setTopBorder(Byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.getLineBox().getTopPen());
    }

    public Color getTopBorderColor() {
        return this.getLineBox().getTopPen().getLineColor();
    }

    public Color getOwnTopBorderColor() {
        return this.getLineBox().getTopPen().getOwnLineColor();
    }

    public void setTopBorderColor(Color topBorderColor) {
        this.getLineBox().getTopPen().setLineColor(topBorderColor);
    }

    public int getTopPadding() {
        return this.getLineBox().getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.getLineBox().getOwnTopPadding();
    }

    public void setTopPadding(int topPadding) {
        this.getLineBox().setTopPadding(topPadding);
    }

    public void setTopPadding(Integer topPadding) {
        this.getLineBox().setTopPadding(topPadding);
    }

    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getLeftPen());
    }

    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getLeftPen());
    }

    public void setLeftBorder(byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.getLineBox().getLeftPen());
    }

    public void setLeftBorder(Byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.getLineBox().getLeftPen());
    }

    public Color getLeftBorderColor() {
        return this.getLineBox().getLeftPen().getLineColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.getLineBox().getLeftPen().getOwnLineColor();
    }

    public void setLeftBorderColor(Color leftBorderColor) {
        this.getLineBox().getLeftPen().setLineColor(leftBorderColor);
    }

    public int getLeftPadding() {
        return this.getLineBox().getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.getLineBox().getOwnLeftPadding();
    }

    public void setLeftPadding(int leftPadding) {
        this.getLineBox().setLeftPadding(leftPadding);
    }

    public void setLeftPadding(Integer leftPadding) {
        this.getLineBox().setLeftPadding(leftPadding);
    }

    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getBottomPen());
    }

    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getBottomPen());
    }

    public void setBottomBorder(byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.getLineBox().getBottomPen());
    }

    public void setBottomBorder(Byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.getLineBox().getBottomPen());
    }

    public Color getBottomBorderColor() {
        return this.getLineBox().getBottomPen().getLineColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.getLineBox().getBottomPen().getOwnLineColor();
    }

    public void setBottomBorderColor(Color bottomBorderColor) {
        this.getLineBox().getBottomPen().setLineColor(bottomBorderColor);
    }

    public int getBottomPadding() {
        return this.getLineBox().getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.getLineBox().getOwnBottomPadding();
    }

    public void setBottomPadding(int bottomPadding) {
        this.getLineBox().setBottomPadding(bottomPadding);
    }

    public void setBottomPadding(Integer bottomPadding) {
        this.getLineBox().setBottomPadding(bottomPadding);
    }

    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getRightPen());
    }

    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getRightPen());
    }

    public void setRightBorder(byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.getLineBox().getRightPen());
    }

    public void setRightBorder(Byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.getLineBox().getRightPen());
    }

    public Color getRightBorderColor() {
        return this.getLineBox().getRightPen().getLineColor();
    }

    public Color getOwnRightBorderColor() {
        return this.getLineBox().getRightPen().getOwnLineColor();
    }

    public void setRightBorderColor(Color rightBorderColor) {
        this.getLineBox().getRightPen().setLineColor(rightBorderColor);
    }

    public int getRightPadding() {
        return this.getLineBox().getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.getLineBox().getOwnRightPadding();
    }

    public void setRightPadding(int rightPadding) {
        this.getLineBox().setRightPadding(rightPadding);
    }

    public void setRightPadding(Integer rightPadding) {
        this.getLineBox().setRightPadding(rightPadding);
    }

    public JRFont getFont() {
        return this;
    }

    protected Map getStyledTextAttributes() {
        JRStyle style = this.getStyle();
        HashMap<TextAttribute, Color> styledTextAttributes = (HashMap<TextAttribute, Color>)this.styledTextAttributesMap.get(style);
        if (styledTextAttributes == null) {
            styledTextAttributes = new HashMap<TextAttribute, Color>();
            JRFontUtil.getAttributesWithoutAwtFont(styledTextAttributes, this);
            styledTextAttributes.put(TextAttribute.FOREGROUND, this.getForecolor());
            if (this.getModeValue() == ModeEnum.OPAQUE) {
                styledTextAttributes.put(TextAttribute.BACKGROUND, this.getBackcolor());
            }
            this.styledTextAttributesMap.put(style, styledTextAttributes);
        }
        return styledTextAttributes;
    }

    protected float getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    protected void setLineSpacingFactor(float lineSpacingFactor) {
        this.lineSpacingFactor = lineSpacingFactor;
    }

    protected float getLeadingOffset() {
        return this.leadingOffset;
    }

    protected void setLeadingOffset(float leadingOffset) {
        this.leadingOffset = leadingOffset;
    }

    protected byte getRunDirection() {
        return this.getRunDirectionValue().getValue();
    }

    public RunDirectionEnum getRunDirectionValue() {
        return this.isLeftToRight ? RunDirectionEnum.LTR : RunDirectionEnum.RTL;
    }

    protected float getTextHeight() {
        return this.textHeight;
    }

    protected void setTextHeight(float textHeight) {
        this.textHeight = textHeight;
    }

    protected int getTextStart() {
        return this.textStart;
    }

    protected void setTextStart(int textStart) {
        this.textStart = textStart;
    }

    protected int getTextEnd() {
        return this.textEnd;
    }

    protected void setTextEnd(int textEnd) {
        this.textEnd = textEnd;
    }

    protected short[] getLineBreakOffsets() {
        return this.lineBreakOffsets;
    }

    protected void setLineBreakOffsets(short[] lineBreakOffsets) {
        this.lineBreakOffsets = lineBreakOffsets;
    }

    protected void resetTextChunk() {
        this.textStart = 0;
        this.textEnd = 0;
        this.textTruncateSuffix = null;
        this.lineBreakOffsets = null;
    }

    protected String getRawText() {
        return this.rawText;
    }

    protected void setRawText(String rawText) {
        this.rawText = rawText;
        this.styledText = null;
    }

    protected void reset() {
        super.reset();
        this.isLeftToRight = true;
        this.lineSpacingFactor = 0.0f;
        this.leadingOffset = 0.0f;
        this.textHeight = 0.0f;
    }

    protected void rewind() {
        this.resetTextChunk();
    }

    protected JRStyledText getStyledText() {
        String text;
        if (this.styledText == null && (text = this.getRawText()) != null) {
            this.styledText = this.filler.getStyledTextParser().getStyledText(this.getStyledTextAttributes(), text, !"none".equals(this.getMarkup()), this.filler.getLocale());
        }
        return this.styledText;
    }

    public String getText() {
        JRStyledText tmpStyledText = this.getStyledText();
        if (tmpStyledText == null) {
            return null;
        }
        return tmpStyledText.getText();
    }

    protected void chopTextElement(int availableStretchHeight) {
        this.ensureTextMeasurer();
        JRStyledText tmpStyledText = this.getStyledText();
        if (tmpStyledText == null) {
            return;
        }
        if (this.getTextEnd() == tmpStyledText.getText().length()) {
            return;
        }
        JRMeasuredText measuredText = this.textMeasurer.measure(tmpStyledText, this.getTextEnd(), availableStretchHeight, this.canOverflow());
        this.isLeftToRight = measuredText.isLeftToRight();
        this.setTextHeight(measuredText.getTextHeight());
        if (this.getRotationValue().equals(RotationEnum.NONE)) {
            this.setStretchHeight((int)this.getTextHeight() + this.getLineBox().getTopPadding() + this.getLineBox().getBottomPadding());
        } else {
            this.setStretchHeight(this.getHeight());
        }
        this.setTextStart(this.getTextEnd());
        this.setTextEnd(measuredText.getTextOffset());
        this.setLineBreakOffsets(measuredText.getLineBreakOffsets());
        this.setTextTruncateSuffix(measuredText.getTextSuffix());
        this.setLineSpacingFactor(measuredText.getLineSpacingFactor());
        this.setLeadingOffset(measuredText.getLeadingOffset());
    }

    protected abstract boolean canOverflow();

    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    public void setReportFont(JRReportFont reportFont) {
    }

    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    public String getOwnFontName() {
        return ((JRFont)((Object)this.parent)).getOwnFontName();
    }

    public void setFontName(String fontName) {
    }

    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    public Boolean isOwnBold() {
        return ((JRFont)((Object)this.parent)).isOwnBold();
    }

    public void setBold(boolean isBold) {
    }

    public void setBold(Boolean isBold) {
    }

    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    public Boolean isOwnItalic() {
        return ((JRFont)((Object)this.parent)).isOwnItalic();
    }

    public void setItalic(boolean isItalic) {
    }

    public void setItalic(Boolean isItalic) {
    }

    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    public Boolean isOwnUnderline() {
        return ((JRFont)((Object)this.parent)).isOwnUnderline();
    }

    public void setUnderline(boolean isUnderline) {
    }

    public void setUnderline(Boolean isUnderline) {
    }

    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    public Boolean isOwnStrikeThrough() {
        return ((JRFont)((Object)this.parent)).isOwnStrikeThrough();
    }

    public void setStrikeThrough(boolean isStrikeThrough) {
    }

    public void setStrikeThrough(Boolean isStrikeThrough) {
    }

    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    public Integer getOwnFontSize() {
        return ((JRFont)((Object)this.parent)).getOwnFontSize();
    }

    public void setFontSize(int size) {
    }

    public void setFontSize(Integer size) {
    }

    public int getSize() {
        return this.getFontSize();
    }

    public Integer getOwnSize() {
        return this.getOwnFontSize();
    }

    public void setSize(int size) {
    }

    public void setSize(Integer size) {
    }

    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    public String getOwnPdfFontName() {
        return ((JRFont)((Object)this.parent)).getOwnPdfFontName();
    }

    public void setPdfFontName(String pdfFontName) {
    }

    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    public String getOwnPdfEncoding() {
        return ((JRFont)((Object)this.parent)).getOwnPdfEncoding();
    }

    public void setPdfEncoding(String pdfEncoding) {
    }

    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    public Boolean isOwnPdfEmbedded() {
        return ((JRFont)((Object)this.parent)).isOwnPdfEmbedded();
    }

    public void setPdfEmbedded(boolean isPdfEmbedded) {
        this.setPdfEmbedded(isPdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setPdfEmbedded(Boolean isPdfEmbedded) {
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    public void setHeight(int height) {
        super.setHeight(height);
        this.createTextMeasurer();
    }

    public void setWidth(int width) {
        super.setWidth(width);
        this.createTextMeasurer();
    }

    protected String processMarkupText(String text) {
        String markup;
        if ((text = JRStringUtil.replaceCRwithLF(text)) != null && !"none".equals(markup = this.getMarkup()) && !"styled".equals(markup)) {
            text = JRFillTextElement.getMarkupProcessor(markup).convert(text);
        }
        return text;
    }

    protected static MarkupProcessor getMarkupProcessor(String markup) {
        MarkupProcessor markupProcessor = (MarkupProcessor)markupProcessors.get(markup);
        if (markupProcessor == null) {
            String factoryClass = JRProperties.getProperty("net.sf.jasperreports.markup.processor.factory." + markup);
            if (factoryClass == null) {
                throw new JRRuntimeException("No markup processor factory specifyed for '" + markup + "' markup.");
            }
            MarkupProcessorFactory factory = null;
            try {
                factory = (MarkupProcessorFactory)markupProcessorFactoryCache.getCachedInstance(factoryClass);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
            markupProcessor = factory.createMarkupProcessor();
            markupProcessors.put(markup, markupProcessor);
        }
        return markupProcessor;
    }

    protected void setPrintText(JRPrintText printText) {
        boolean keepAllText;
        int startIndex = this.getTextStart();
        int endIndex = this.getTextEnd();
        JRStyledText fullStyledText = this.getStyledText();
        String fullText = fullStyledText.getText();
        boolean bl = keepAllText = !this.canOverflow() && JRProperties.getBooleanProperty(this, "net.sf.jasperreports.print.keep.full.text", false);
        if (keepAllText) {
            if (startIndex != 0) {
                throw new JRRuntimeException("Text start index != 0 on keep all text.");
            }
            if (!"none".equals(this.getMarkup())) {
                String styledText = this.filler.getStyledTextParser().write(fullStyledText);
                printText.setText(styledText);
            } else {
                printText.setText(fullText);
            }
            if (endIndex < fullText.length()) {
                printText.setTextTruncateIndex(endIndex);
            }
        } else {
            String printedText = !"none".equals(this.getMarkup()) ? this.filler.getStyledTextParser().write(fullStyledText, startIndex, endIndex) : fullText.substring(startIndex, endIndex);
            printText.setText(printedText);
        }
        printText.setTextTruncateSuffix(this.getTextTruncateSuffix());
        printText.setLineBreakOffsets(this.getLineBreakOffsets());
    }

    protected String getTextTruncateSuffix() {
        return this.textTruncateSuffix;
    }

    protected void setTextTruncateSuffix(String textTruncateSuffix) {
        this.textTruncateSuffix = textTruncateSuffix;
    }
}

