/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.directwebremoting.Container;

public class ContainerMap
extends AbstractMap
implements Map {
    private boolean filterNonStringValues;
    private Container container;
    protected Map proxy;

    public ContainerMap(Container container, boolean filterNonStringValues) {
        this.container = container;
        this.filterNonStringValues = filterNonStringValues;
    }

    private void init() {
        if (this.proxy == null) {
            this.proxy = new HashMap();
            Iterator it = this.container.getBeanNames().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                Object value = this.container.getBean(name);
                if (this.filterNonStringValues && !(value instanceof String)) continue;
                this.proxy.put(name, value);
            }
        }
    }

    public Object get(Object key) {
        this.init();
        return this.proxy.get(key);
    }

    public Set entrySet() {
        this.init();
        return this.proxy.entrySet();
    }

    public boolean containsKey(Object key) {
        this.init();
        return this.proxy.containsKey(key);
    }

    public boolean containsValue(Object value) {
        this.init();
        return this.proxy.containsValue(value);
    }

    public boolean equals(Object o) {
        this.init();
        return ((Object)this.proxy).equals(o);
    }

    public int hashCode() {
        this.init();
        return ((Object)this.proxy).hashCode();
    }

    public boolean isEmpty() {
        this.init();
        return this.proxy.isEmpty();
    }

    public Set keySet() {
        this.init();
        return this.proxy.keySet();
    }

    public int size() {
        this.init();
        return this.proxy.size();
    }

    public Collection values() {
        this.init();
        return this.proxy.values();
    }

    public String toString() {
        this.init();
        return this.proxy.toString();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException("ContainerMaps are read only");
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException("ContainerMaps are read only");
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException("ContainerMaps are read only");
    }

    public void clear() {
        throw new UnsupportedOperationException("ContainerMaps are read only");
    }
}

