/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.event.EventSource;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;

public final class Cascade {
    public static final int AFTER_INSERT_BEFORE_DELETE = 1;
    public static final int BEFORE_INSERT_AFTER_DELETE = 2;
    public static final int AFTER_INSERT_BEFORE_DELETE_VIA_COLLECTION = 3;
    public static final int AFTER_UPDATE = 0;
    public static final int BEFORE_FLUSH = 0;
    public static final int AFTER_EVICT = 0;
    public static final int BEFORE_REFRESH = 0;
    public static final int AFTER_LOCK = 0;
    public static final int BEFORE_MERGE = 0;
    private static final Log log = LogFactory.getLog((Class)Cascade.class);
    private int cascadeTo;
    private EventSource eventSource;
    private CascadingAction action;

    public Cascade(CascadingAction action, int cascadeTo, EventSource eventSource) {
        this.cascadeTo = cascadeTo;
        this.eventSource = eventSource;
        this.action = action;
    }

    public void cascade(EntityPersister persister, Object parent) throws HibernateException {
        this.cascade(persister, parent, null);
    }

    public void cascade(EntityPersister persister, Object parent, Object anything) throws HibernateException {
        if (persister.hasCascades() || this.action.requiresNoCascadeChecking()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("processing cascade " + this.action + " for: " + persister.getEntityName()));
            }
            Type[] types = persister.getPropertyTypes();
            CascadeStyle[] cascadeStyles = persister.getPropertyCascadeStyles();
            EntityMode entityMode = this.eventSource.getEntityMode();
            boolean hasUninitializedLazyProperties = persister.hasUninitializedLazyProperties(parent, entityMode);
            for (int i = 0; i < types.length; ++i) {
                CascadeStyle style = cascadeStyles[i];
                if (hasUninitializedLazyProperties && persister.getPropertyLaziness()[i] && !this.action.performOnLazyProperty()) continue;
                if (style.doCascade(this.action)) {
                    this.cascadeProperty(persister.getPropertyValue(parent, i, entityMode), types[i], style, anything, false);
                    continue;
                }
                if (!this.action.requiresNoCascadeChecking()) continue;
                this.action.noCascade(this.eventSource, persister.getPropertyValue(parent, i, entityMode), parent, persister, i);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("done processing cascade " + this.action + " for: " + persister.getEntityName()));
            }
        }
    }

    private void cascadeProperty(Object child, Type type, CascadeStyle style, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
        if (child != null) {
            if (type.isAssociationType()) {
                AssociationType associationType = (AssociationType)type;
                if (this.cascadeAssociationNow(associationType)) {
                    this.cascadeAssociation(child, type, style, anything, isCascadeDeleteEnabled);
                }
            } else if (type.isComponentType()) {
                this.cascadeComponent(child, (AbstractComponentType)type, anything);
            }
        }
    }

    private boolean cascadeAssociationNow(AssociationType associationType) {
        return associationType.getForeignKeyDirection().cascadeNow(this.cascadeTo) && (this.eventSource.getEntityMode() != EntityMode.DOM4J || associationType.isEmbeddedInXML());
    }

    private void cascadeComponent(Object child, AbstractComponentType componentType, Object anything) {
        Object[] children = componentType.getPropertyValues(child, this.eventSource);
        Type[] types = componentType.getSubtypes();
        for (int i = 0; i < types.length; ++i) {
            CascadeStyle componentPropertyStyle = componentType.getCascadeStyle(i);
            if (!componentPropertyStyle.doCascade(this.action)) continue;
            this.cascadeProperty(children[i], types[i], componentPropertyStyle, anything, false);
        }
    }

    private void cascadeAssociation(Object child, Type type, CascadeStyle style, Object anything, boolean isCascadeDeleteEnabled) {
        if (type.isEntityType() || type.isAnyType()) {
            this.cascadeToOne(child, type, style, anything, isCascadeDeleteEnabled);
        } else if (type.isCollectionType()) {
            this.cascadeCollection(child, style, anything, (CollectionType)type);
        }
    }

    private void cascadeCollection(Object child, CascadeStyle style, Object anything, CollectionType type) {
        CollectionPersister persister = this.eventSource.getFactory().getCollectionPersister(type.getRole());
        Type elemType = persister.getElementType();
        int oldCascadeTo = this.cascadeTo;
        if (this.cascadeTo == 1) {
            this.cascadeTo = 3;
        }
        if (elemType.isEntityType() || elemType.isAnyType() || elemType.isComponentType()) {
            this.cascadeCollectionElements(child, type, style, elemType, anything, persister.isCascadeDeleteEnabled());
        }
        this.cascadeTo = oldCascadeTo;
    }

    private void cascadeToOne(Object child, Type type, CascadeStyle style, Object anything, boolean isCascadeDeleteEnabled) {
        String entityName;
        String string = entityName = type.isEntityType() ? ((EntityType)type).getAssociatedEntityName() : null;
        if (style.reallyDoCascade(this.action)) {
            this.action.cascade(this.eventSource, child, entityName, anything, isCascadeDeleteEnabled);
        }
    }

    private void cascadeCollectionElements(Object child, CollectionType collectionType, CascadeStyle style, Type elemType, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
        boolean deleteOrphans;
        boolean reallyDoCascade;
        boolean embeddedElements = this.eventSource.getEntityMode() != EntityMode.DOM4J || ((EntityType)collectionType.getElementType(this.eventSource.getFactory())).isEmbeddedInXML();
        boolean bl = reallyDoCascade = style.reallyDoCascade(this.action) && embeddedElements && child != CollectionType.UNFETCHED_COLLECTION;
        if (reallyDoCascade) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascade " + this.action + " for collection: " + collectionType.getRole()));
            }
            Iterator iter = this.action.getCascadableChildrenIterator(this.eventSource, collectionType, child);
            while (iter.hasNext()) {
                this.cascadeProperty(iter.next(), elemType, style, anything, isCascadeDeleteEnabled);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("done cascade " + this.action + " for collection: " + collectionType.getRole()));
            }
        }
        boolean bl2 = deleteOrphans = style.hasOrphanDelete() && this.action.deleteOrphans() && elemType.isEntityType() && child instanceof PersistentCollection;
        if (deleteOrphans) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("deleting orphans for collection: " + collectionType.getRole()));
            }
            String entityName = collectionType.getAssociatedEntityName(this.eventSource.getFactory());
            this.deleteOrphans(entityName, (PersistentCollection)child);
            if (log.isTraceEnabled()) {
                log.trace((Object)("done deleting orphans for collection: " + collectionType.getRole()));
            }
        }
    }

    private void deleteOrphans(String entityName, PersistentCollection pc) throws HibernateException {
        CollectionEntry ce;
        Collection orphans = pc.wasInitialized() ? ((ce = this.eventSource.getPersistenceContext().getCollectionEntry(pc)) == null ? CollectionHelper.EMPTY_COLLECTION : ce.getOrphans(entityName, pc)) : pc.getQueuedOrphans(entityName);
        Iterator orphanIter = orphans.iterator();
        while (orphanIter.hasNext()) {
            Object orphan = orphanIter.next();
            if (orphan == null) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("deleting orphaned entity instance: " + entityName));
            }
            this.eventSource.delete(entityName, orphan, false, new HashSet());
        }
    }
}

