/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.proxy.map.MapProxyFactory;
import org.hibernate.tuple.DynamicMapInstantiator;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.entity.AbstractEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;

public class DynamicMapEntityTuplizer
extends AbstractEntityTuplizer {
    static final Log log = LogFactory.getLog((Class)DynamicMapEntityTuplizer.class);

    DynamicMapEntityTuplizer(EntityMetamodel entityMetamodel, PersistentClass mappedEntity) {
        super(entityMetamodel, mappedEntity);
    }

    public EntityMode getEntityMode() {
        return EntityMode.MAP;
    }

    private PropertyAccessor buildPropertyAccessor(Property mappedProperty) {
        if (mappedProperty.isBackRef()) {
            return mappedProperty.getPropertyAccessor(null);
        }
        return PropertyAccessorFactory.getDynamicMapPropertyAccessor();
    }

    protected Getter buildPropertyGetter(Property mappedProperty, PersistentClass mappedEntity) {
        return this.buildPropertyAccessor(mappedProperty).getGetter(null, mappedProperty.getName());
    }

    protected Setter buildPropertySetter(Property mappedProperty, PersistentClass mappedEntity) {
        return this.buildPropertyAccessor(mappedProperty).getSetter(null, mappedProperty.getName());
    }

    protected Instantiator buildInstantiator(PersistentClass mappingInfo) {
        return new DynamicMapInstantiator(mappingInfo);
    }

    protected ProxyFactory buildProxyFactory(PersistentClass mappingInfo, Getter idGetter, Setter idSetter) {
        MapProxyFactory pf = new MapProxyFactory();
        try {
            pf.postInstantiate(this.getEntityName(), null, null, null, null, null);
        }
        catch (HibernateException he) {
            log.warn((Object)("could not create proxy factory for:" + this.getEntityName()), (Throwable)he);
            pf = null;
        }
        return pf;
    }

    public Class getMappedClass() {
        return Map.class;
    }

    public Class getConcreteProxyClass() {
        return Map.class;
    }

    public boolean isInstrumented() {
        return false;
    }

    public EntityNameResolver[] getEntityNameResolvers() {
        return new EntityNameResolver[]{BasicEntityNameResolver.INSTANCE};
    }

    public String determineConcreteSubclassEntityName(Object entityInstance, SessionFactoryImplementor factory) {
        return DynamicMapEntityTuplizer.extractEmbeddedEntityName((Map)entityInstance);
    }

    public static String extractEmbeddedEntityName(Map entity) {
        return (String)entity.get("$type$");
    }

    public static class BasicEntityNameResolver
    implements EntityNameResolver {
        public static final BasicEntityNameResolver INSTANCE = new BasicEntityNameResolver();

        public String resolveEntityName(Object entity) {
            String entityName = DynamicMapEntityTuplizer.extractEmbeddedEntityName((Map)entity);
            if (entityName == null) {
                throw new HibernateException("Could not determine type of dynamic map entity");
            }
            return entityName;
        }

        public boolean equals(Object obj) {
            return this.getClass().equals(obj.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

