$(document).ready(function() {
	var spinnerDisplayed = false;
	//****************** Error handling
	$("#eebcErrorBlock").dialog({
		autoOpen : false,
		height : 300,
		width : 350,
		modal : true,
		buttons: {
			Close: function() {
				$( this ).dialog( "close" );					
			}
		}
	});
	
	$.fn.isError = function(data) {
		if (data.indexOf("<h2>System Error</h2>") > 0)
		{
			$.fn.displayError(data);
			return true;
		}
		else
		{
			return false;
		}
	}
	
	$.fn.displayError = function(data) {
		$('#eebcErrorBlock').html(data);
		$('#eebcErrorBlock').dialog('open');
	}
	
	// saving modal
	$("#eebcSavingBlock").dialog({
		autoOpen : false,
		height : 80,
		width : 50,
		modal : true,
		draggable : false,
		resizable : false,
		open: function(event, ui) { $(".ui-dialog-titlebar-close", ui).hide();  $(".ui-dialog-titlebar").hide();}
	});
	
	$.fn.displaySpinner = function(target) {
		if (spinnerDisplayed == false) {
			var opts = {
			  lines: 12, // The number of lines to draw
			  length: 7, // The length of each line
			  width: 3, // The line thickness
			  radius: 5, // The radius of the inner circle
			  color: '#000', // #rgb or #rrggbb
			  speed: 1, // Rounds per second
			  trail: 60, // Afterglow percentage
			  shadow: false // Whether to render a shadow
			};
			var target = document.getElementById(target);
			var spinner = new Spinner(opts).spin(target);
			spinnerDisplayed = true;
		}
	}
	
	// append asterisk to required labels
	$("label.required").each(function() {
		$(this).text($(this).text() + " *");
	});
});