package com.saic.eebc.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.w3c.dom.*;
import org.xml.sax.ContentHandler;

import java.io.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Iterator;

import com.saic.eebc.dto.EebcProductEntryObjectDTO;
import com.saic.eebc.dto.EndOfLifeDTO;
import com.saic.eebc.dto.InputUseAndEOLDTO;
import com.saic.eebc.dto.ProductDetailsDTO;
import com.saic.eebc.dto.ProductInformationDTO;
import com.saic.eebc.dto.UseDataDTO;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.Annotations;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;


public class EebcImportExportServiceImpl implements EebcImportExportService {
	private static DateFormat df;
	private static final Log log = LogFactory.getLog(EebcImportExportService.class);

	
	public String  GenerateXmlFileFromEEBC(EebcProductEntryObjectDTO eebcProductEntryObject) {
		String xmlFile = "";
		try {
			XmlFriendlyReplacer replacer = new XmlFriendlyReplacer("ddd", "_"); 
			XStream xs = new XStream(new DomDriver("UTF-8", replacer)); 
		
			if(eebcProductEntryObject!=null)
			{
				xs.alias("eebcProductEntryObject", EebcProductEntryObjectDTO.class);
				xs.alias("inputUseAndEOLDTO",InputUseAndEOLDTO.class);
				xs.alias("productInformationDTO", ProductInformationDTO.class);
				xs.alias("useDataDTO", UseDataDTO.class);
				xs.alias("endOfLifeDTO", EndOfLifeDTO.class);
				xs.alias("productDetailsDTO", ProductDetailsDTO.class);
				xmlFile = xs.toXML(eebcProductEntryObject);
			}
			

		}catch (Exception e) {
			log.error("Exception Message", e);
			e.printStackTrace();
		}
		return xmlFile;
	}

	public EebcProductEntryObjectDTO writeXml(String xmlFile )
	{
		EebcProductEntryObjectDTO  EebcProductEntryObject  = null;
		try {
			
		
	XmlFriendlyReplacer replacer = new XmlFriendlyReplacer("ddd", "_"); 
	XStream xs = new XStream(new DomDriver("UTF-8", replacer)); 
	xs.alias("eebcProductEntryObject", EebcProductEntryObjectDTO.class);
	xs.alias("inputUseAndEOLDTO",InputUseAndEOLDTO.class);
	xs.alias("productInformationDTO", ProductInformationDTO.class);
	xs.alias("useDataDTO", UseDataDTO.class);
	xs.alias("endOfLifeDTO", EndOfLifeDTO.class);
	xs.alias("productDetailsDTO", ProductDetailsDTO.class);
    EebcProductEntryObject = (EebcProductEntryObjectDTO) xs.fromXML(xmlFile);	
		}
	catch (Exception e) {
		log.error("Exception Message", e);
		e.printStackTrace();
	}
		return EebcProductEntryObject;
	}
}
	
	

