package com.saic.eebc.web;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.validator.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.saic.eebc.*;
import com.saic.eebc.dto.DataCompProductInterimResultDTO;
import com.saic.eebc.dto.DataCompProductMainResultDTO;
import com.saic.eebc.dto.EebcProductEntryObjectDTO;
import com.saic.eebc.dto.EndOfLifeDTO;
import com.saic.eebc.dto.InputUseAndEOLDTO;
import com.saic.eebc.dto.ProductInformationDTO;
import com.saic.eebc.dto.SavingsReport;
import com.saic.eebc.dto.UseDataDTO;
import com.saic.eebc.service.EebcCalculationService;
import com.saic.eebc.service.EebcImportExportService;
import com.saic.eebc.validator.EolValidator;
import com.saic.eebc.validator.ProductValidator;


@Controller
@SessionAttributes("eebcProductEntryObjectSession") 
public class EebcCalculatorController {
	
	DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
	
	@Autowired
	private EebcCalculationService eebcCalculationService;
	
	@Autowired
	private EebcImportExportService eebcImportExportService;
	
	 @Autowired 
    private EolValidator validator;  
	 
	 @Autowired 
	private ProductValidator productValidator; 

	
	protected final Logger logger = Logger.getLogger(getClass());
	
	   @ModelAttribute("eebcProductEntryObjectSession")
	    public EebcProductEntryObjectDTO createEebcProductEntryObjectDTO() {
	        return new EebcProductEntryObjectDTO();
	    }


	/**
	 * Go to the home page
	 * 
	 * @param model
	 * @throws Exception
	 */
	@RequestMapping(value = "/home.do", method = RequestMethod.GET)
	protected String goHome (
			ModelMap model,
			HttpSession session) throws Exception {
		String forward = "home";
		
		return forward;
	}
	
	/**
	 * Go to the home page
	 * 
	 * @param model
	 * @throws Exception
	 */
	@RequestMapping(value = "/eebcCalculator", method = RequestMethod.GET)
	protected String goCalculator (
			ModelMap model,
			@ModelAttribute("eebcProductEntryObject") EebcProductEntryObjectDTO eebcProductEntryObject,
			@ModelAttribute("eebcProductEntryObjectSession") EebcProductEntryObjectDTO eebcProductEntryObjectSession,
			HttpSession session) throws Exception {
		String forward = "eebcCalculator";
	
		if(eebcProductEntryObjectSession == null)
		{
			model.addAttribute("eebcProductEntryObject",new EebcProductEntryObjectDTO());
		}else{
			if(session.getAttribute("productAdded") != null)
			{
				if(eebcProductEntryObjectSession.getProductInformationList() == null)
				{
					List<ProductInformationDTO>productInformationList = new ArrayList<ProductInformationDTO>();
					productInformationList.add((ProductInformationDTO)session.getAttribute("productAdded"));
					eebcProductEntryObjectSession.setProductInformationList(productInformationList);
				}else{
				eebcProductEntryObjectSession.getProductInformationList().add((ProductInformationDTO)session.getAttribute("productAdded"));
				}
				model.addAttribute("defaultTab", "productList");
				session.removeAttribute("productAdded");
			}
			model.addAttribute("eebcProductEntryObject",eebcProductEntryObjectSession);
		}
		
		return forward;
	}
	
	/**
	 * Go to the home page
	 * 
	 * @param model
	 * @throws Exception
	 */
	@RequestMapping(value = "/eebcCalculator", method = RequestMethod.POST)
	protected String postCalculator (
			ModelMap model,
			@ModelAttribute("eebcProductEntryObject") EebcProductEntryObjectDTO eebcProductEntryObject,
			@ModelAttribute("eebcProductEntryObjectSession") EebcProductEntryObjectDTO eebcProductEntryObjectSession,
		    @RequestParam(value="defaultTab", required=false) String defaultTab,
			HttpSession session) throws Exception {
		String forward = "eebcCalculator";
	
		if(eebcProductEntryObjectSession == null)
		{
			model.addAttribute("eebcProductEntryObject",new EebcProductEntryObjectDTO());
		}else{
			if(session.getAttribute("productAdded") != null)
			{
				ProductInformationDTO productInfo = (ProductInformationDTO)session.getAttribute("productAdded");
				if(eebcProductEntryObjectSession.getProductInformationList() == null)
				{
					
					eebcProductEntryObjectSession.setProductInformationList(new ArrayList<ProductInformationDTO>());
				}
				List<ProductInformationDTO> productInformationList = eebcProductEntryObjectSession.getProductInformationList();
				ProductInformationDTO updateProduct = null;
				ProductInformationDTO oldProduct = null;
					 for(ProductInformationDTO product:productInformationList)
					 {
						 if(product.getProductInfoID() != null && productInfo.getProductInfoID().equalsIgnoreCase(product.getProductInfoID()))
						 {
							 updateProduct = productInfo;
							 oldProduct = product;
						 }
					 }
				
				if(updateProduct != null)
				{
					eebcProductEntryObjectSession.getProductInformationList().remove(oldProduct);
					eebcProductEntryObjectSession.getProductInformationList().add(updateProduct);
				}else{
					eebcProductEntryObjectSession.getProductInformationList().add(productInfo);
					
				}
				 eebcProductEntryObjectSession.setProductInformationList(productInformationList);
				model.addAttribute("defaultTab", "productList");
				session.removeAttribute("productAdded");
			}
			model.addAttribute("eebcProductEntryObject",eebcProductEntryObjectSession);
		}
		
		return forward;
	}
	

	
	/**
	 * Go to the home page
	 *  
	 * @param model
	 * @throws Exception
	 */
	@RequestMapping(value = "/saveEndoflife.do", method = RequestMethod.POST)
	protected String saveEndoflife(
			ModelMap model,
			@ModelAttribute("eebcProductEntryObjectSession") EebcProductEntryObjectDTO eebcProductEntryObjectSession,
			@ModelAttribute("eebcProductEntryObject") EebcProductEntryObjectDTO eebcProductEntryObject,
			BindingResult errors) throws Exception {
		String forward = "eebcCalculator";
		validator.validate( eebcProductEntryObject, errors);
		if (!errors.hasErrors()) {	
	   	eebcProductEntryObjectSession.setInputUseAndEolObject(eebcProductEntryObject.getInputUseAndEolObject());
		}
		model.addAttribute("eebcProductEntryObject",eebcProductEntryObject);
      return forward;
	}
	
	
	/**
	 * Go to the home page
	 *  
	 * @param model
	 * @throws Exception
	 */
	@RequestMapping(value = "/resetEndoflife.do", method = RequestMethod.GET)
	protected String resetEndoflife(
			ModelMap model,
			@ModelAttribute("eebcProductEntryObjectSession") EebcProductEntryObjectDTO eebcProductEntryObjectSession,
			@ModelAttribute("eebcProductEntryObject") EebcProductEntryObjectDTO eebcProductEntryObject,
			BindingResult errors) throws Exception {
		String forward = "eebcCalculator";
		eebcProductEntryObjectSession.getInputUseAndEolObject().setEndOfLifeInputs(new EndOfLifeDTO());
		eebcProductEntryObjectSession.getInputUseAndEolObject().setCrtUse(new UseDataDTO());
		eebcProductEntryObjectSession.getInputUseAndEolObject().setDesktopComputerUse(new UseDataDTO());
		eebcProductEntryObjectSession.getInputUseAndEolObject().setLcdUse(new UseDataDTO());
		eebcProductEntryObjectSession.getInputUseAndEolObject().setNotebookUse(new UseDataDTO());
		eebcProductEntryObjectSession.getInputUseAndEolObject().setTotalNumOfUnitsInService(null);
		eebcProductEntryObjectSession.getInputUseAndEolObject().setUseTotal(null);
		model.addAttribute("eebcProductEntryObject",eebcProductEntryObjectSession);
      return forward;
	}
	
	
	/**
	 * Go to the home page
	 * 
	 * @param model
	 * @throws Exception
	 */
	@RequestMapping(value = "/extractEebcProductEntryObjectDTOXML.do", method = RequestMethod.GET)
	protected void extractEebcProductEntryObjectDTOXML (
			ModelMap model,
			@ModelAttribute("eebcProductEntryObjectSession") EebcProductEntryObjectDTO eebcProductEntryObjectSession,
			HttpServletRequest request,
			HttpServletResponse response,
			HttpSession session) throws Exception {
		String xmlString ="";
		if(eebcProductEntryObjectSession!=null)
		{
			xmlString = eebcImportExportService.GenerateXmlFileFromEEBC(eebcProductEntryObjectSession);
		}
		response.setHeader("Content-Type", "application/xml");
		PrintWriter writer = response.getWriter();
		writer.write(xmlString);

		
	}
	
	@RequestMapping(value = "/addFile_json.do", method = RequestMethod.POST)	
	public String addFile_json(
			@RequestParam("fileToUpload") MultipartFile file, 
			ModelMap model) throws IOException {
		 EebcProductEntryObjectDTO eebcProductEntryObject = null;
			String fileName="";
			String xmlString ="";
	       if(file.getSize()>0)
	       {
			if(file!=null){
				fileName = file.getOriginalFilename();
				if(file.getBytes() !=null)
				{
				 eebcProductEntryObject = eebcImportExportService.writeXml(new String(file.getBytes()));
				}
			model.addAttribute("eebcProductEntryObjectSession",eebcProductEntryObject);
			model.addAttribute("eebcProductEntryObject",eebcProductEntryObject);
			}
	       }
	 
			return "redirect:eebcCalculator.do";
	}
	
	
	/**
	 * Go to the home page
	 * 
	 * @param model
	 * @throws Exception
	 */
	@RequestMapping(value = "/updateProduct.do", method = RequestMethod.GET)
	protected String updateProduct (
			@RequestParam("productInfoID") String productInfoID, 
			@ModelAttribute("eebcProductEntryObjectSession") EebcProductEntryObjectDTO eebcProductEntryObjectSession,
			ModelMap model,
			HttpSession session) throws Exception {
		String forward = "productInfo";
		 ProductInformationDTO productInformation =  null ;
		 List<ProductInformationDTO> productList = eebcProductEntryObjectSession.getProductInformationList();
		 for(ProductInformationDTO product:productList)
		 {
			 if(product.getProductInfoID() != null && productInfoID.equalsIgnoreCase(product.getProductInfoID()))
			 {
				 model.addAttribute("newProduct", product);
			 }
		 }
		return forward;
	}
	
	
	/**
	 * Go to the home page
	 * 
	 * @param model
	 * @throws Exception
	 */
	@RequestMapping(value = "/deleteProduct.do", method = RequestMethod.GET)
	protected String deleteProduct (
			@RequestParam("productInfoID") String productInfoID, 
			@ModelAttribute("eebcProductEntryObjectSession") EebcProductEntryObjectDTO eebcProductEntryObjectSession,
			ModelMap model,
			HttpSession session) throws Exception {
		String forward = "forward:eebcCalculator.do";
		 ProductInformationDTO productInformation =  null ;
		 List<ProductInformationDTO> productList = eebcProductEntryObjectSession.getProductInformationList();
		 ProductInformationDTO deleteProduct = null;
		 if(productList != null)
		 {
		 for(ProductInformationDTO product:productList)
		 {
			 if(product.getProductInfoID() != null && productInfoID.equalsIgnoreCase(product.getProductInfoID()))
			 {
				 deleteProduct = product;
			 }
		 }
		 }
		 productList.remove(deleteProduct);
		 eebcProductEntryObjectSession.setProductInformationList(productList);
		 
		 model.addAttribute("eebcProductEntryObjectSession",eebcProductEntryObjectSession);
	    model.addAttribute("defaultTab", "productList");
		return forward;
	}
	
	/**
	 * Go to the home page
	 * 
	 * @param model
	 * @throws Exception
	 */
	@RequestMapping(value = "/generateReports.do", method = RequestMethod.GET)
	protected String generateReports (
			@ModelAttribute("eebcProductEntryObjectSession") EebcProductEntryObjectDTO eebcProductEntryObjectSession,
			ModelMap model,
			HttpSession session) throws Exception {
		String forward = "eebcReportProduct";
		SavingsReport savingsReport = eebcCalculationService.GenerateReportFromEEBCObject(eebcProductEntryObjectSession);
		if (savingsReport !=null)
		{
	    model.put("userEntry",eebcProductEntryObjectSession);
		model.put("productList",savingsReport.getSavingsproduct());
		model.put("endofLife",savingsReport.getEndOfLise());
		model.put("useInput",savingsReport.getUseInput());
		model.put("allProduct",savingsReport.getSavingsAllproduct());
		}
		return forward;
	}
	
	
	/**
	 * Handle any exceptions
	 * @param ex	The exception
	 * @return		Error page
	 */
	@ExceptionHandler()
    public ModelAndView handleException(Exception ex) {
    	String guid = UUID.randomUUID().toString(); 
    	logger.error("Error: Search: GUID=" + guid, ex);
    	ModelAndView mav = new ModelAndView("error");
    	mav.addObject("guid", guid);
    	mav.addObject("error", ex);
    	return mav;
    }
}
