classdef class_REVS_accessory_load
    %class_REVS_accessory_load
    %   Generic accessory load via dynamic lookup
    
    properties
        enable = true;
        electrical_loss_map_A@class_REVS_dynamic_lookup;		% Loss map as dynamic lookup
        mechanical_loss_map_Nm@class_REVS_dynamic_lookup;
        inertia_kgm2 = 0.0;
    end
    
    methods
        
        function obj = class_REVS_accessory_load( elec_power_W, max_elec_current_A, mech_power_W, max_mech_torque_Nm )
            
            if nargin == 0
				obj.electrical_loss_map_A = class_REVS_dynamic_lookup;
                obj.electrical_loss_map_A.table                 = [0,0];
                obj.electrical_loss_map_A.axis_1.breakpoints    = [0,100];
                obj.electrical_loss_map_A.axis_1.signal         = 'acc_volt_V';
                
                obj.mechanical_loss_map_Nm = class_REVS_dynamic_lookup;
				obj.mechanical_loss_map_Nm.table                = [0,0];
                obj.mechanical_loss_map_Nm.axis_1.breakpoints   = [0,1000];
                obj.mechanical_loss_map_Nm.axis_1.signal        = 'acc_spd_radps';
            else
                
                min_full_power_volts                            = elec_power_W ./ (eps + max_elec_current_A );
                obj.electrical_loss_map_A = class_REVS_dynamic_lookup;
				obj.electrical_loss_map_A.axis_1.signal         = 'acc_volt_V' ;               
                obj.electrical_loss_map_A.axis_1.breakpoints    = union(0, linspace(min_full_power_volts, 4 * min_full_power_volts+1, 19 ))';
                obj.electrical_loss_map_A.table                 = min( elec_power_W ./ (eps + obj.electrical_loss_map_A.axis_1.breakpoints ),  max_elec_current_A);
                
                
                min_full_power_speed                            = mech_power_W ./ ( eps + max_mech_torque_Nm );
                obj.mechanical_loss_map_Nm = class_REVS_dynamic_lookup;
				obj.mechanical_loss_map_Nm.axis_1.signal        = 'acc_spd_radps';
                obj.mechanical_loss_map_Nm.axis_1.breakpoints   = union(0,linspace(min_full_power_speed, 7 * min_full_power_speed+1, 19 ))';
                obj.mechanical_loss_map_Nm.table                = min(mech_power_W ./  ( eps + obj.mechanical_loss_map_Nm.axis_1.breakpoints ), max_mech_torque_Nm);
                        
            end
            
        end
        
    end
    
end
