classdef class_REVS_electric
	%REVS_ALPHA_electric
	%   ALPHA Electric description class. Contains definitions for
	%	starter, alternator, battery & air conditioning and other
	%	accessory losses
	
	properties
        name = '';
        matrix_vintage = enum_matrix_vintage.present;
		starter;
		alternator;
		battery = class_REVS_battery;		
	end
	
	methods
		
		function obj = class_REVS_electric( engine )
			% Pass in Engine class to auto calculate starter & alternator
			% parameters
			
			if nargin > 0
				obj.starter = class_REVS_starter( engine );
				obj.alternator = class_REVS_alternator( engine );
            else
                obj.starter = class_REVS_starter;
                obj.alternator = class_REVS_alternator;
            end
						
			
		end
				
	end
	
end

