classdef class_REVS_emachine < handle
    %REVS_emachine
    %   REVS Electric Machine class definition
    
    properties
        inertia_kgm2 = 0;
        
        max_speed_radps
        max_torque_Nm
        max_motor_power_W
        max_regen_power_W
        max_speed_max_motor_power_W
        max_speed_max_regen_power_W
        
        efficiency_map_speed_index_radps
        efficiency_map_torque_index_Nm
        efficiency_norm
        
        spinloss_torque_Nm      = [0 0];
        spinloss_speed_radps    = [0 1];
                
        power_map_voltage_index_V
        
    end
    
    properties ( Dependent )
        
        max_torque_curve_speed_radps
        max_motor_power_curve_W
        max_regen_power_curve_W
        max_motor_torque_curve_Nm
        max_regen_torque_curve_Nm
        
        power_map_speed_index_radps
        power_map_torque_index_Nm
        power_map_W
        
    end
    
    methods
        
        %% setters/getters for Dependent properties
        function val = get.max_torque_curve_speed_radps( obj )
            val = linspace(0, obj.max_speed_radps, 50);
        end
        
        function val = get.max_motor_power_curve_W( obj )
            val = interp1([0 obj.max_motor_power_W/obj.max_torque_Nm obj.max_speed_radps],[0 obj.max_motor_power_W obj.max_speed_max_motor_power_W], obj.max_torque_curve_speed_radps);
        end
        
        function val = get.max_regen_power_curve_W( obj )
            val = interp1([0 obj.max_regen_power_W/obj.max_torque_Nm obj.max_speed_radps],[0 obj.max_regen_power_W obj.max_speed_max_regen_power_W], obj.max_torque_curve_speed_radps);
        end
        
        function val = get.max_motor_torque_curve_Nm( obj )
            max_motor_torque_curve_Nm       = min(obj.max_torque_Nm, obj.max_motor_power_curve_W ./ obj.max_torque_curve_speed_radps);
            max_motor_torque_curve_Nm(end)  = 0;
            val = max_motor_torque_curve_Nm;
        end
        
        function val = get.max_regen_torque_curve_Nm( obj )
            max_regen_torque_curve_Nm       = min(obj.max_torque_Nm, obj.max_regen_power_curve_W ./ obj.max_torque_curve_speed_radps);
            max_regen_torque_curve_Nm(end)  = 0;
            val = max_regen_torque_curve_Nm;
        end
        
        function val = get.power_map_speed_index_radps( obj )
            val = [-fliplr(obj.efficiency_map_speed_index_radps), obj.efficiency_map_speed_index_radps];
        end
        
        function val = get.power_map_torque_index_Nm( obj )
            val = fliplr([fliplr(obj.efficiency_map_torque_index_Nm) -obj.efficiency_map_torque_index_Nm]);
        end
        
        function val = get.power_map_W( obj )
            mg_nominal_power_map_W      = obj.efficiency_map_torque_index_Nm' * obj.efficiency_map_speed_index_radps;
            mg_discharge_power_map_W    = mg_nominal_power_map_W ./ obj.efficiency_norm;
            mg_charge_power_map_W       = mg_nominal_power_map_W .* obj.efficiency_norm;
            
            mg_power_map_quadrant1_2 = [-flipud(mg_charge_power_map_W); mg_discharge_power_map_W];
            power_map_W = horzcat(rot90(mg_power_map_quadrant1_2,2), mg_power_map_quadrant1_2);
            
            mapsize = size(power_map_W);
            
            if length(mapsize) == 2
                map3d(:,:,1) = power_map_W;
                map3d(:,:,2) = power_map_W;
            end
            
            val = map3d;
        end
        
    end
    
end

