classdef class_REVS_uber_dynamic_lockup
    %class_REVS_uber_dynamic_lockup
    
    
    properties(Constant = true)
        type = enum_transmission_lockup_select.uber_dynamic;
    end
    
    properties 
        
        lock_table@class_REVS_dynamic_lookup;
        unlock_table@class_REVS_dynamic_lookup;

        downshift_unlock_condition = [];
        upshift_unlock_condition = [];

        always_unlock_gear = 0;
        always_lock_gear = inf;

        lock_condition	= '(@gb_spd_in_radps > @table_lock_spd && @trans_curr_gear > transmission.tcc_strategy.always_unlock_gear ) || @trans_curr_gear >= transmission.tcc_strategy.always_lock_gear ';
        unlock_condition	= '(@gb_spd_in_radps < @table_unlock_spd && @trans_curr_gear < transmission.tcc_strategy.always_lock_gear ) || @trans_curr_gear <= transmission.tcc_strategy.always_unlock_gear';

        lockup_delay_secs = 0.1;
        lockup_allowed = true;
    end
        
    
    methods
        
        function  obj = class_REVS_uber_dynamic_lockup
        
            obj.lock_table = class_REVS_dynamic_lookup;
            obj.unlock_table = class_REVS_dynamic_lookup;
        end
        
    end
    
end

