classdef enum_powertrain_type < Simulink.IntEnumType
    enumeration
        none(-1)       
        conventional(0)
        hybrid_P2(1)
        hybrid_P2_BAS(2)
        hybrid_powersplit(3)
        hybrid_BAS(8)
        battery_electric(7)       
	end
    
	
	methods
				
		function val = is_conventional(obj)		
			val = (obj == enum_powertrain_type.conventional) ;
		end		
				
		function val = is_hybrid(obj)		
			val = (obj == enum_powertrain_type.hybrid_P2) || (obj == enum_powertrain_type.hybrid_P2_BAS) || (obj == enum_powertrain_type.hybrid_BAS) || (obj == enum_powertrain_type.hybrid_powersplit) ;
		end
		
		function val = is_bev(obj)		
			val = (obj == enum_powertrain_type.battery_electric) ;
		end		
		
	end
	
end
