%% ----------------------- local functions -------------------------------
function [] = DOR_xy_plot( test_data, model_data, data_descriptor, x_signal_str, x_signal_descriptor, y_signal_str, y_signal_descriptor, varargin)
model_pts  = parse_varargs(varargin,'model_pts',[]);
line_style = parse_varargs(varargin,'line_style','-');
line_color = parse_varargs(varargin,'line_color','b','string');
new_figure = parse_varargs(varargin,'no_fig',true,'toggle');
no_legend  = parse_varargs(varargin,'no_legend',false,'toggle');
ylimits    = parse_varargs(varargin,'ylim',[]);

fig_handle = [];

try % just in case we get a recursion or some other error during plotting!
    for i = 1:length(test_data)
        test_xdata = eval(['test_data{i}.' x_signal_str]);
        test_ydata = eval(['test_data{i}.' y_signal_str]);
        
        if sum(isnan(test_ydata)) ~= length(test_ydata)
            if new_figure && isempty(fig_handle);
                fig_handle = figure;
            else
                hold on;
            end
            
            plothg(test_xdata, test_ydata(:),['r.' line_style]); % test_ydata(:) prevents plothg from creating a legend entry
            
            if ~no_legend
                add_legend('data');
            end
        end
    end
    
    if isempty(model_pts)
        model_xdata = eval(['model_data.' x_signal_str]);
        model_ydata = eval(['model_data.' y_signal_str]);
    else
        model_xdata = eval(['model_data.' x_signal_str '(model_pts)']);
        model_ydata = eval(['model_data.' y_signal_str '(model_pts)']);
    end
    
    if sum(isnan(model_ydata)) ~= length(model_ydata)
        if new_figure && isempty(fig_handle);
            fig_handle = figure;
        else
            hold on;
        end
        
        plothg(model_xdata, model_ydata(:), [line_color '.' line_style]); % model_ydata(:) prevents plothg from creating a legend entry
        
        if ~no_legend
            add_legend('model');
        end
        
        xyt(x_signal_descriptor,[data_descriptor ' ' y_signal_descriptor]);
    end
    
    if new_figure && isempty(fig_handle)
        warning OFF BACKTRACE
        warning(['DOR_xy_plot, NO DATA TO PLOT : ' [data_descriptor ' ' y_signal_descriptor] ' v. ' x_signal_descriptor]);
        warning ON BACKTRACE
    elseif new_figure && ~isempty(ylimits)
        ylim(ylimits);
    end
    
catch
    close;
    warning OFF BACKTRACE
    warning(['#PLOTFAIL DOR_xy_plot,' [data_descriptor ' ' y_signal_descriptor] ' v. ' x_signal_descriptor]);
    warning ON BACKTRACE
end

end
