function [ revs_data ] = REVS_CVM_renamalyzer( vehicle, engine, transmission, audit, datalog )
% function [ revs_data ] = REVS_CVM_renamalyzer( audit, datalog )
%   stores raw model outputs in REVS class_test_data for comparison with test
%   data in the same format, for example

revs_data = REVS_VM_vehicle_renamalyzer(vehicle, audit, datalog);

revs_data = REVS_VM_engine_renamalyzer(revs_data, vehicle, engine, audit, datalog);

revs_data = REVS_VM_transmission_renamalyzer(revs_data, transmission, audit, datalog);

revs_data.accessory.alternator_A                    = audit.elec.alternator.input_Amps;
revs_data.accessory.alternator_V                    = audit.elec.alternator.input_Volts;
revs_data.accessory.alternator_electrical_kW        = audit.elec.alternator.input_kW;
revs_data.accessory.alternator_speed_radps          = audit.mech.alternator.output_radps;
revs_data.accessory.alternator_torque_Nm            = audit.mech.alternator.output_Nm;
revs_data.accessory.alternator_mechanical_kW        = audit.mech.alternator.output_kW;

revs_data.accessory.battery.terminal_current_A      = audit.elec.battery_Amps;
revs_data.accessory.battery.terminal_voltage_V      = audit.elec.battery_Volts;
revs_data.accessory.battery.terminal_power_kW       = audit.elec.battery_kW;
try
    revs_data.accessory.battery.state_of_charge_norm    = datalog.battery.SoC_norm;
catch % temporary fix until executables get updated, 9/12/16
    revs_data.accessory.battery.state_of_charge_norm = audit.elec.battery_SoC_norm;
end

revs_data.accessory.torque_Nm                       = audit.mech.accessories.total_Nm;
revs_data.accessory.speed_radps                     = audit.mech.accessories.total_radps;
revs_data.accessory.mechanical_kW                   = audit.mech.accessories.total_kW;

end
