function [ ] = REVS_DOR_electrification( test_data, model_data, varargin )
% function [ ] = REVS_DOR_electrification( test_data, model_data )
%   creates a Electrification (propulsion battery, emachines, DCDC, etc) DOR.
%   test_data can be a cell array of class_test_data objects or a single
%   class_test_data object.
%   model_data is intended to be a class_test_data object of model data
%   but could also be any singular class_test_data object.
%
% varargs:
% data_descriptor     = parse_varargs(varargin,'descriptor','','string');
% time_range          = parse_varargs(varargin,'time_range',[]);

data_descriptor     = parse_varargs(varargin,'descriptor','','string');
time_range          = parse_varargs(varargin,'time_range',[]);

if isempty(time_range)
    model_pts = [];
    time_range = [model_data.time(1) model_data.time(end)];
else
    model_pts = (model_data.time >= time_range(1)) & (model_data.time <= time_range(end));
end

if ~iscell(test_data)
    test_data = {test_data};
end

DOR_time_plot(test_data, model_data, data_descriptor, 'propulsion_battery.terminal_voltage_V',      'Propulsion Battery Voltage', 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, 'propulsion_battery.terminal_current_A',      'Propulsion Battery Current', 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, 'propulsion_battery.state_of_charge_norm',    'Propulsion Battery SoC', 'model_pts', model_pts, 'ylim', [0 1]);

% motor plots
DOR_time_plot(test_data, model_data, data_descriptor, 'emachine.torque_Nm',             'Emachine Torque', 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, 'emachine.speed_radps',           'Emachine Speed', 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, 'emachine.mechanical_power_kW',   'Emachine Shaft Power', 'model_pts', model_pts);

DOR_time_plot(test_data, model_data, data_descriptor, 'emachine.voltage_V',             'Emachine Voltage', 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, 'emachine.current_A',             'Emachine Current', 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, 'emachine.electrical_power_kW',   'Emachine Electrical Power', 'model_pts', model_pts);

DOR_time_plot(test_data, model_data, data_descriptor, 'emachine.efficiency_norm',       'Emachine Efficiency Norm', 'model_pts', model_pts, 'ylim', [0 1]);

end
