function [ ] = REVS_DOR_transmission( test_data, model_data, varargin )
% function [ ] = REVS_DOR_transmission( test_data, model_data )
%   creates a Transmission DOR.
%   test_data can be a cell array of class_test_data objects or a single
%   class_test_data object.
%   model_data is intended to be a class_test_data object of model data
%   but could also be any singular class_test_data object.
%
% varargs:
% data_descriptor     = parse_varargs(varargin,'descriptor','','string');
% engine              = parse_varargs(varargin,'engine','');
% %time_range         = parse_varargs(varargin,'time_range',[model_data.time(1) model_data.time(end)]);
% time_range          = parse_varargs(varargin,'time_range',[]);
% analyze_ratios      = parse_varargs(varargin,'analyze_ratios',false,'toggle');
% vehicle_speed_units = parse_varargs(varargin,'vehicle_speed_units','mph','string');
% fuel_plots          = parse_varargs(varargin,'fuel_plots',false,'toggle');
% engine_speed_units  = parse_varargs(varargin,'engine_speed_units','rpm','string');
% accessory_plots     = parse_varargs(varargin,'accessory_plots',false,'toggle');

data_descriptor     = parse_varargs(varargin,'descriptor','','string');
engine              = parse_varargs(varargin,'engine','');
%time_range         = parse_varargs(varargin,'time_range',[model_data.time(1) model_data.time(end)]);
time_range          = parse_varargs(varargin,'time_range',[]);
analyze_ratios      = parse_varargs(varargin,'analyze_ratios',false,'toggle');
vehicle_speed_units = parse_varargs(varargin,'vehicle_speed_units','mph','string');
fuel_plots          = parse_varargs(varargin,'fuel_plots',false,'toggle');
engine_speed_units  = parse_varargs(varargin,'engine_speed_units','rpm','string');
accessory_plots     = parse_varargs(varargin,'accessory_plots',false,'toggle');

if strcmpi(engine_speed_units,'rpm')
    engine_speed_units_label = 'RPM';
else
    engine_speed_units_label = 'rad/s';
end

if strcmpi(vehicle_speed_units,'mph')
    vehicle_speed_units_label = 'MPH';
else
    vehicle_speed_units_label = 'm/s';
end

if isempty(time_range)
    model_pts = [];
    time_range = [model_data.time(1) model_data.time(end)];
else
    model_pts = (model_data.time >= time_range(1)) & (model_data.time <= time_range(end));
end

if ~iscell(test_data)
    test_data = {test_data};
end

%% lockup
DOR_time_plot(test_data, model_data, data_descriptor, 'transmission.launch_device_lockup_norm','Launch Device Lockup','model_pts',model_pts);

% % return;
% %% gear ratio plot
 if model_data.transmission.type == enum_transmission_type.CVT
     DOR_time_plot(test_data, model_data, data_descriptor, 'transmission.current_CVT_ratio','CVT Ratio','model_pts',model_pts);
     if ~isempty(test_data)
         ylim([0  max(max(test_data{:}.transmission.current_CVT_ratio), max(model_data.transmission.current_CVT_ratio))]);
     end
 end
 
%
% %% gearbox input speed v. vehicle speed plot
% DOR_xy_plot(test_data, model_data, data_descriptor, 'vehicle.speed_mph', 'Vehicle Speed (mph)', 'transmission.gearbox_input_speed_rpm', 'Transmission Input Speed (RPM)', 'model_pts', (model_data.vehicle.speed_mph > 0) & model_pts, 'line_style', '');
%
% %% gear ratio v. speed plot
%
% if model_data.transmission.type == enum_transmission_type.CVT
%     DOR_xy_plot(test_data, model_data, data_descriptor, 'vehicle.speed_mph', 'Vehicle Speed (mph)', 'transmission.current_CVT_ratio', 'CVT Ratio', 'model_pts', (model_data.vehicle.speed_mph > 0) & model_pts, 'line_style', '');
% end
%
%% gear number v. time
DOR_time_plot(test_data, model_data, data_descriptor, 'transmission.commanded_gear_number','Commanded Gear Number','model_pts',model_pts);

%% gear number v. time
DOR_time_plot(test_data, model_data, data_descriptor, 'transmission.current_gear_number','Current Gear Number','model_pts',model_pts);

%% gearbox input torque
DOR_time_plot(test_data, model_data, data_descriptor, 'transmission.gearbox_input_torque_Nm','Gearbox Input Torque','model_pts',model_pts);

%% gearbox output torque
DOR_time_plot(test_data, model_data, data_descriptor, 'transmission.output_torque_Nm','Gearbox Output Torque','model_pts',model_pts);

%% gearbox output speed
DOR_time_plot(test_data, model_data, data_descriptor, ['transmission.gearbox_output_speed_' engine_speed_units],['Geabox Output Speed (' engine_speed_units_label ')'],'model_pts',model_pts);

%% gearbox input speed
DOR_time_plot(test_data, model_data, data_descriptor, ['transmission.gearbox_input_speed_' engine_speed_units],['Geabox Input Speed (' engine_speed_units_label ')'],'model_pts',model_pts);

if analyze_ratios
    REVS_ratios_DOR( test_data, model_data, varargin{:} );
end

end
