function [ spd ] = REVS_calc_engine_power_speed( e, power_norm, mode )
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here

hires_speeds_radps = 0:0.1:e.full_throttle_speed_radps(end);
hires_torque_Nm = interp1(e.full_throttle_speed_radps, e.full_throttle_torque_Nm, hires_speeds_radps);
hires_power_W = hires_speeds_radps .* hires_torque_Nm;

[max_power_W, max_power_idx] = max(hires_power_W); 

idx = find( hires_power_W >= max_power_W .* power_norm);

if nargin <= 2
	% Highest and Lowest speeds that meet target engine power
	idx = [idx(1), idx(end)];
elseif strcmp(mode , 'min' )
	% Lowest speed that meets target engine power
	idx = idx(1);
elseif strcmp(mode , 'max' )
	% Highest speed that meets target engine power
	idx = idx(end);
end

spd = hires_speeds_radps(idx);
	
end
