function [ ratios ] = REVS_gen_transmission_ratios( num_gears, varargin )
% function [ ratios ] = REVS_gen_transmission_ratios( num_gears, varargin )
% 
% arithmetic  = parse_varargs(varargin, 'arithmetic', false, 'toggle');
% geometric   = parse_varargs(varargin, 'geometric', false, 'toggle');
% phi         = parse_varargs(varargin, 'phi', [], 'numeric');
% min_ratio   = parse_varargs(varargin, 'min_ratio', [], 'numeric');
% max_ratio   = parse_varargs(varargin, 'max_ratio', [], 'numeric');
% spread      = parse_varargs(varargin, 'spread', [], 'numeric');
% include_neutral = parse_varargs(varargin, 'include_neutral', false, 'toggle');

arithmetic  = parse_varargs(varargin, 'arithmetic', false, 'toggle');
geometric   = parse_varargs(varargin, 'geometric', false, 'toggle');
phi         = parse_varargs(varargin, 'phi', [], 'numeric');
min_ratio   = parse_varargs(varargin, 'min_ratio', [], 'numeric');
max_ratio   = parse_varargs(varargin, 'max_ratio', [], 'numeric');
spread      = parse_varargs(varargin, 'spread', [], 'numeric');
include_neutral = parse_varargs(varargin, 'include_neutral', false, 'toggle');

if isempty(spread) && (isempty(min_ratio) || isempty(max_ratio))
    error('Must provide min or max and spread or min and max ratios');
elseif ~isempty(min_ratio) && ~isempty(spread) && ~isempty(max_ratio)
    error('Transmission may be overspecified, please provide min and max ratios or min or max and spread');
elseif ~isempty(min_ratio) && ~isempty(spread)
    max_ratio = min_ratio * spread;
elseif ~isempty(max_ratio) && ~isempty(spread)
    min_ratio = max_ratio / spread;
end

if isempty(spread)
    spread = max_ratio/min_ratio;
end

ratios = zeros(1,num_gears);

if ~isempty(phi)
    iz = min_ratio;
    
    for g = 1:num_gears
        ratios(g) = min(max_ratio, max(iz, iz*(spread/(phi^(0.5*(num_gears-1)*(g-1))))^((num_gears-g)/(num_gears-1))));
    end
elseif geometric
    % ratio of the ratios is constant R(n)/R(n+1) = K    
    for g = 1:num_gears
        ratios(g+1) = min_ratio(end) * (spread^(1/(num_gears-1)))^(num_gears-g);  % calc gear ratios with constant ratio of the ratios between gears...
    end
elseif arithmetic
    % change in ratios = constant, R(n) - R(n+1) = K
    ratios = linspace(max_ratio, min_ratio, num_gears);
end

if include_neutral
    ratios = [0 ratios];
end


end
