function REVS_plot_battery(b, format)
% % REVS_plot_battery(b, format)


switch upper(format)
    case {'POWER','WATTS','W'}
        subplot(2,1,1);
        %Power limit: State of Charge vs Temperature  (discharge)
        contour(b.powerlimit_map_index_soc_norm,b.powerlimit_map_index_temp_degC,b.powerlimit_discharge_map_W,'ShowText','on')
        title('Power Limit Discharge')
        xlabel('SOC')
        ylabel('temp (C)');
        
        subplot(2,1,2)
        
        %power limit: State of Charge vs Temperature  (charge)
        contour(b.powerlimit_map_index_soc_norm,b.powerlimit_map_index_temp_degC,b.powerlimit_charge_map_W,'ShowText','on')
        title('Power Limit Charge')
        xlabel('SOC')
        ylabel('temp (C)');
        
    case {'V', 'VOLTAGE'}
        subplot(3,1,1);
        
        %Power limit: State of Charge vs Temperature  (discharge)
        contour(b.open_circuit_voltage_map_index_soc_norm,b.open_circuit_voltage_map_index_temp_degC,b.open_circuit_voltage_map_discharge_V,'ShowText','on')
        title('Open Circuit Voltage Discharge')
        xlabel('SOC')
        ylabel('temp (C)');
        
        
        subplot(3,1,2)
        
        
        %Power limit: State of Charge vs Temperature  (discharge)
        contour(b.open_circuit_voltage_map_index_soc_norm,b.open_circuit_voltage_map_index_temp_degC,b.open_circuit_voltage_map_charge_V,'ShowText','on')
        title('Open Circuit Voltage Charge')
        xlabel('SOC')
        ylabel('temp (C)');
        
        
        subplot(3,1,3)
        
        
        %Power limit: State of Charge vs Temperature  (discharge)
        contour(b.open_circuit_voltage_map_index_soc_norm,b.open_circuit_voltage_map_index_temp_degC,b.open_circuit_voltage_map_average_V,'ShowText','on')
        title('Open Circuit Voltage Charge')
        xlabel('SOC')
        ylabel('temp (C)');
        
        
    case {'RESISTANCE','O','OHMS'}
        
        subplot(2,1,1);
        %Power limit: State of Charge vs Temperature  (discharge)
        contour(b.resistance_map_index_soc_norm,b.resistance_map_index_temp_degC,b.resistance_map_discharge_Ohms,'ShowText','on')
        title('Resistance Discharge')
        xlabel('SOC')
        ylabel('temp (C)');
        
        subplot(2,1,2)
        
        %power limit: State of Charge vs Temperature  (charge)
        contour(b.resistance_map_index_soc_norm,b.resistance_map_index_temp_degC,b.resistance_map_charge_Ohms,'ShowText','on')
        title('Resistance Charge')
        xlabel('SOC')
        ylabel('temp (C)');
    otherwise
        error('Unknown plot format %s',format)
end

