function [] = REVS_plot_drive_cycle( drive_cycle )
% function [] = REVS_plot_drive_cycle( drive_cycle )
% does what it says it does

figure;
subplot(2,1,1)
hold on

if isfield(drive_cycle, 'cycle_speed_mps_raw')
    plot(drive_cycle.cycle_time_raw, drive_cycle.cycle_speed_mps_raw,'m.-')
end
add_legend('raw speed');

plot(drive_cycle.cycle_time,drive_cycle.cycle_speed_mps,'b.-', 'linewidth', 2); add_legend('speed');
stairs(drive_cycle.ignition_time,drive_cycle.ignition*30,'r.-', 'linewidth', 2); add_legend('ignition');
stairs(drive_cycle.in_gear_time,drive_cycle.in_gear*35,'g.-', 'linewidth', 2); add_legend('in gear');
stairs(drive_cycle.phase_time, drive_cycle.phase,'k-', 'linewidth', 2); add_legend('phase');
%plot(drive_cycle.phase_time, drive_cycle.phase,'kx');
xlabel('Time (S)');
grid on;

subplot(2,1,2);
hold on

dist = integral( drive_cycle.cycle_speed_mps, drive_cycle.cycle_time, 1);
plot(drive_cycle.grade_dist_m, drive_cycle.grade_pct,'r.-');
plot(dist,drive_cycle.cycle_speed_mps,'b.-');

phase_dist = interp1( drive_cycle.cycle_time, dist, drive_cycle.phase_time,'linear','extrap');
stairs(phase_dist, drive_cycle.phase,'k-', 'linewidth', 2);
%plot(phase_dist, drive_cycle.phase,'kx');
legend('grade','speed','phase');
xlabel('Distance (m)');
grid on;

end

