function REVS_plot_engine_fuel_linearity( e, varargin)
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here



fuel_mgpi = e.fuel_map_gpi*1000;
legend_speed_radps = [];

figure;
hold on

for s = 1:length(e.fuel_map_speed_radps)

	speed_radps = e.fuel_map_speed_radps(s);

	min_torque_Nm = interp1(e.closed_throttle_speed_radps, e.closed_throttle_torque_Nm, speed_radps,'linear','extrap' );
	max_torque_Nm = interp1(e.full_throttle_speed_radps, e.full_throttle_torque_Nm, speed_radps,'linear','extrap' );
	
	map_torque_Nm = e.fuel_map_torque_Nm(:);
	remove = map_torque_Nm < min_torque_Nm | map_torque_Nm > max_torque_Nm;
	
	if speed_radps * convert.radps2rpm > 475 && ~all(remove)
		plot_torque_Nm = [min_torque_Nm; map_torque_Nm(~remove); max_torque_Nm];
		plot_fuel_gpi = interp1( e.fuel_map_torque_Nm, fuel_mgpi(:,s), plot_torque_Nm );
	
		line_color = interp1(linspace(0,1,length(jet)), jet, (s-1)/(length(e.fuel_map_speed_radps)-1));
	
		plot( plot_torque_Nm, plot_fuel_gpi ,'.-','color',line_color)
		legend_speed_radps(end+1) = speed_radps;
	end
		
end

speed_str = cellstr(int2str(legend_speed_radps(:) * convert.radps2rpm));

legend(strcat( speed_str,' RPM'));
xlabel( 'Torque (Nm)');
ylabel( 'Fuel per Injection (mg)');

end

