function [i_ci, i_co, i_gs] = calc_gearbox_inertia(i_tot, gr)


m_ci_max = linspace(0,min(i_tot),1000)';

% Convert to matrix
m_ci = repmat(m_ci_max,[1,length(gr)]);
m_tot = repmat(i_tot, [1000,1]);
m_gr = repmat(gr,[1000,1]);

m_co_max = min((m_tot - m_ci - 0) .* (m_gr .^2),[],2);
m_co = repmat(m_co_max,[1,length(gr)]);


plot(m_ci_max, m_co_max)


m_gs = m_tot - m_ci - m_co ./ ( m_gr .^2);

m_gs_sum = sum(m_gs,2);

[~,idx] = min(m_gs_sum);

i_ci = m_ci_max(idx);
i_co = m_co_max(idx);
i_gs= m_gs(idx,:);











