function [ revs_data ] = REVS_VM_transmission_renamalyzer( revs_data, transmission, audit, datalog )

revs_data.transmission.type                         = transmission.type;
revs_data.transmission.gear_ratios                  = transmission.gear.ratio;
revs_data.transmission.current_gear_number          = datalog.transmission.current_gear;
revs_data.transmission.commanded_gear_number        = datalog.transmission.selected_gear_num;
revs_data.transmission.output_torque_Nm             = datalog.transmission.output_torque_Nm; % Logan

if revs_data.transmission.type == enum_transmission_type.DCT
    revs_data.transmission.gearbox_input_torque_Nm      = audit.mech.gearbox1.input_Nm + audit.mech.gearbox2.input_Nm;
else
    revs_data.transmission.gearbox_input_torque_Nm      = audit.mech.gearbox.input_Nm;
end

if isfield(datalog.controls,'clutch_engage_norm')
    revs_data.transmission.launch_device_lockup_norm    = datalog.controls.clutch_engage_norm;
elseif revs_data.transmission.type == enum_transmission_type.automatic
    revs_data.transmission.launch_device_lockup_norm    = datalog.transmission.torque_converter_clutch_command_norm; % datalog.torque_converter.tcc_engage_norm;
elseif revs_data.transmission.type == enum_transmission_type.CVT
    revs_data.transmission.launch_device_lockup_norm    = datalog.transmission.torque_converter_clutch_command_norm; % datalog.torque_converter.tcc_engage_norm;
    % other trans types here
end

if revs_data.transmission.type == enum_transmission_type.CVT
    revs_data.transmission.current_CVT_ratio        = min(max(transmission.gear.ratio), datalog.gearbox.actual_ratio .* (datalog.gearbox.engage_norm > 0));
elseif revs_data.transmission.type == enum_transmission_type.DCT
    odd_pts     = datalog.transmission.clutch1_engage ~= 0;
    even_pts    = datalog.transmission.clutch1_engage ~= 0;
    
    temp.transmission_current_gear_ratio                    = zeros(size(revs_data.time));
    temp.transmission_current_gear_ratio(odd_pts)           = datalog.gearbox1.actual_ratio(odd_pts);
    temp.transmission_current_gear_ratio(even_pts)          = datalog.gearbox2.actual_ratio(even_pts);
    revs_data.transmission.current_gear_ratio               = temp.transmission_current_gear_ratio;
    
    temp.transmission.gearbox_input_speed_radps             = zeros(size(revs_data.time));
    temp.transmission.gearbox_input_speed_radps(odd_pts)    = audit.mech.gearbox1.input_radps(odd_pts);
    temp.transmission.gearbox_input_speed_radps(even_pts)   = audit.mech.gearbox2.input_radps(even_pts);
    revs_data.transmission.gearbox_input_speed_radps        = temp.transmission.gearbox_input_speed_radps;
else
    try % GEM -v,3 fix
        revs_data.transmission.current_gear_ratio       = datalog.gearbox.actual_ratio;
    end
end

if revs_data.transmission.type == enum_transmission_type.DCT
    revs_data.transmission.gearbox_input_torque_Nm      = audit.mech.dual_clutch.input_Nm;
    revs_data.transmission.output_torque_Nm             = datalog.transmission.output_torque_Nm;
    revs_data.transmission.gearbox_output_speed_radps   = audit.mech.gearbox1.output_radps;
else
    revs_data.transmission.gearbox_input_torque_Nm      = audit.mech.gearbox.input_Nm;
    revs_data.transmission.output_torque_Nm             = audit.mech.gearbox.output_Nm;
    revs_data.transmission.gearbox_input_speed_radps    = audit.mech.gearbox.input_radps;
    revs_data.transmission.gearbox_output_speed_radps   = audit.mech.gearbox.output_radps;
end

if isfield(datalog.transmission,'temperature_degC')
    revs_data.transmission.oil_temp_degC            = datalog.transmission.temperature_degC;
end

if isfield(datalog, 'transmission.command_line_pressure_bar')
    revs_data.transmission.line_pressure_bar            = datalog.transmission.command_line_pressure_bar;
end

end
