clear c publish_dir winning_config_nums % workspace cleanup

run_cycle_postproc;

cold_correction_past    = [0.170,0.025];
cold_correction_present = [0.150,0.025];
cold_correction_future  = [0.110,0.000];

if engine.matrix_vintage == enum_matrix_vintage.past
    cold_correction = cold_correction_past;
elseif engine.matrix_vintage == enum_matrix_vintage.present
    cold_correction = cold_correction_present;
else
    cold_correction = cold_correction_future;
end

cold_corrected_result = result;
cold_corrected_result.phase_fuel_consumed_g(1:2) = result.phase_fuel_consumed_g(1:2) .* (1 + cold_correction);

weighted_results.ftp_FE_mpg = CFR_FTP_harmonic_average(cold_corrected_result.phase_distance_mi(1:3), cold_corrected_result.phase_fuel_consumed_CFR_gallons(1:3));
weighted_results.hwfet_FE_mpg = result.phase_FE_CFR_mpg(5);

weighted_results.city_highway_FE_mpg = CFR_city_highway_weighted_combined( weighted_results.ftp_FE_mpg, weighted_results.hwfet_FE_mpg, 'mpg');
weighted_results.city_highway_GHG_gCO2pmi = vehicle.fuel.gCO2pgal / weighted_results.city_highway_FE_mpg
